unit hlavni;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DBGrids, DB, DBTables, StdCtrls, Uvod, Vypocet, Operace, Stroje, Vyrobky,
  Zaloha, Obnovit, ExtCtrls, Zprava, Vkladani;

type
  TForm1 = class(TForm)
    Stroje: TButton;
    Vyrobky: TButton;
    Operace: TButton;
    vypocet: TButton;
    zaloha: TButton;
    EndButton: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    DataSource1: TDataSource;
    Table1: TTable;
    Table2: TTable;
    DataSource2: TDataSource;
    Table3: TTable;
    DataSource3: TDataSource;
    Obnoveni: TButton;
    Label7: TLabel;
    DataSource5: TDataSource;
    Table5: TTable;
    procedure StrojeClick(Sender: TObject);
    procedure VyrobkyClick(Sender: TObject);
    procedure OperaceClick(Sender: TObject);
    procedure vypocetClick(Sender: TObject);
    procedure zalohaClick(Sender: TObject);
    procedure ObnoveniClick(Sender: TObject);
    procedure EndButtonClick(Sender: TObject);
    procedure DataSource2DataChange(Sender: TObject; Field: TField);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    function Zprava(obsah : string ;stav : integer) : boolean;
    function Vlozit(obsah : string ;var promena_f : string) : boolean;
  private
    { Private declarations }
  public
   	{ Public declarations }
    nastaveni_filtru_operaci : boolean;
		Cesta : string;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.StrojeClick(Sender: TObject);
// Tato procedura spusti formular stroje
var
	masiny : TStrojeForm;
begin
 	masiny := TStrojeForm.Create(self);
  masiny.ShowModal;
  masiny.destroy;
end;

procedure TForm1.VyrobkyClick(Sender: TObject);
// Tato procedura spusti formular vyrobky
var
	vyrobky : TVyrobkyForm;
begin
 	vyrobky := TVyrobkyForm.Create(self);
  vyrobky.ShowModal;
  vyrobky.destroy;
end;

procedure TForm1.OperaceClick(Sender: TObject);
// Tato procedura spusti formular vypocet
var
	oper : TOperaceForm;
  pokracuj : boolean;
begin
	pokracuj := True;
	// zkontrolujeme zda v souboru mashiny.dbf neco je
  if Table1.IsEmpty then begin
  	Form1.Zprava('Neexistuj dn stroje, nejdve njak pidejte !!', 1);
		pokracuj := False;
  end;
	// zkontrolujeme zda v souboru vyrobky.dbf neco je
  if Table2.IsEmpty then begin
  	Form1.Zprava('Neexistuj dn vrobky, nejdve njak pidejte !!', 1);
		pokracuj := False;
  end;
  if pokracuj then begin
	 	oper := TOperaceForm.Create(self);
	  oper.ShowModal;
	  oper.destroy;
  end;
end;

procedure TForm1.vypocetClick(Sender: TObject);
// Tato procedura spusti formular vypocet
var
	vyp : TVypocetForm;
begin
	// zkontrolujeme zda v souboru operace.dbf neco je
  if Table3.IsEmpty then
  	Form1.Zprava('Neexistuj dn operace, nen co potat !!',1)
  else begin
  	Form1.Nastaveni_filtru_operaci := False;
	 	vyp := TVypocetForm.Create(self);
	  vyp.ShowModal;
	  vyp.destroy;
   	Form1.Nastaveni_filtru_operaci := True;
  end;
end;

procedure TForm1.zalohaClick(Sender: TObject);
// Tato procedura spusti formular zaloha
var
	zaloha : TZalohaForm;
begin
	// zkontrolujeme zda v souboru operace.dbf neco je
  if Table3.IsEmpty then
  	Form1.Zprava('Neexistuj dn operace, nen co zlohovat !!',1)
  else begin
	 	zaloha := TZalohaForm.Create(self);
	  zaloha.ShowModal;
	  zaloha.destroy;
  end;
	//zde se skontroluje zda je co nhravat a pripadne vypne tlacitko obnovit
  if Form1.Table5.IsEmpty then Obnoveni.Enabled := False
		else Obnoveni.Enabled := True;
end;

procedure TForm1.ObnoveniClick(Sender: TObject);
// Tato procedura spusti formular obnovit
var
	obnovit : TObnovitForm;
begin
	// zkontrolujeme zda v souboru operace.dbf neco je
 	obnovit := TObnovitForm.Create(self);
  obnovit.ShowModal;
  obnovit.destroy;
	//zde se skontroluje zda je co nhravat a pripadne vypne tlacitko obnovit
  if Form1.Table5.IsEmpty then Obnoveni.Enabled := False
		else Obnoveni.Enabled := True;
end;

procedure TForm1.EndButtonClick(Sender: TObject);
begin
	if Zprava('Chcete opravdu skonit ?',2) then Close;
end;

procedure TForm1.DataSource2DataChange(Sender: TObject; Field: TField);
begin
// nastaveni filtru na okamzitou nastavenou hodnotu vyrobku atd
  if Form1.Nastaveni_filtru_operaci and (Form1.Table2.Fields[0].Text <> '') then
		Form1.Table3.Filter:='idv=' + IntToStr(Form1.Table2.Fields[0].AsInteger);
end;

procedure TForm1.FormCreate(Sender: TObject);
var hod : boolean;
begin
	// Co se provede pri vytvoreni formulare
	// A ZDE SE DO GLOBALNI PROMENNE 	nahraje puvodni cesta
	Cesta := GetCurrentDir;
	// A ZDE SE DO GLOBALNI PROMENNE 	zda filtrovat operace nebo ne
 	Form1.Nastaveni_filtru_operaci := True;
  // Zde se kontroluje zda soubory dbf jsou vubec umisteny v aktualnim adresary
	// a pokud nejsou nahrajise ze zalohy
     if (FileSearch('adresar.dbf',Form1.Cesta) = '') then
        CopyFile(PChar('zaloha\adresar.dbf'), 'adresar.dbf', hod);
     if (FileSearch('mashiny.dbf',Form1.Cesta) = '') then
        CopyFile(PChar('zaloha\mashiny.dbf'), 'mashiny.dbf', hod);
     if (FileSearch('vyrobky.dbf',Form1.Cesta) = '') then
	  	  CopyFile(PChar('zaloha\vyrobky.dbf'), 'vyrobky.dbf', hod);
     if (FileSearch('operace.dbf',Form1.Cesta) = '') then
			  CopyFile(PChar('zaloha\operace.dbf'), 'operace.dbf', hod);
	// Kontrola a vymazani MASHINY.DBF
	repeat // opakuje dokud to neni spravne nebo nezmackne Cancel
 		try
    	Table1.Exclusive := True; // nastavi Exclusive na True
    	Table1.Active := True;
    	Break; // jestlize nedojde k zadne chybe skonci cyklus
	  except
	    on EDatabaseError do
      // Klavesa OK znamena opakovani
      if Form1.Zprava('Program je pravdpodobn ji putn! Opakovat ?', 2) then raise; // jestlize chce skncit
      // pokud ne cyklus se opakuje
  	end;
	until False;
	Table1.EmptyTable;

	// Kontrola a vymazani VYROBKY.DBF
	repeat // opakuje dokud to neni spravne nebo nezmackne Cancel
 		try
    	Table2.Exclusive := True; // nastavi Exclusive na True
    	Table2.Active := True;
    	Break; // jestlize nedojde k zadne chybe skonci cyklus
	  except
	    on EDatabaseError do
      // Klavesa OK znamena opakovani
      if Form1.Zprava('Program je pravdpodobn ji putn!  Opakovat ?',2) then raise; // jestlize chce skncit
      // pokud ne cyklus se opakuje
  	end;
	until False;
	Table2.EmptyTable;

	// Kontrola a vymazani OPERACE.DBF
	repeat // opakuje dokud to neni spravne nebo nezmackne Cancel
 		try
    	Table3.Exclusive := True; // nastavi Exclusive na True
    	Table3.Active := True;
    	Break; // jestlize nedojde k zadne chybe skonci cyklus
	  except
	    on EDatabaseError do
      // Klavesa OK znamena opakovani
      if Form1.Zprava('Program je pravdpodobn ji putn!! Opakovat ?',2) then raise; // jestlize chce skncit
      // pokud ne cyklus se opakuje
  	end;
	until False;
	Table3.EmptyTable;

	Table3.Filtered := True;
	//zde se skontroluje zda je co nahravat a pripadne vypne tlacitko obnovit
  if Form1.Table5.IsEmpty then Obnoveni.Enabled := False
		else Obnoveni.Enabled := True;
end;

procedure TForm1.FormActivate(Sender: TObject);
var Uvod : TUvodForm;
begin
	// Tato procedura spusti uvodn stranu
 	uvod := TuvodForm.Create(self);
  uvod.ShowModal;
  uvod.destroy;
end;

function TForm1.Zprava(obsah : string ;stav : integer) : Boolean;
var Oznameni : TZpravaForm;
begin
 	Oznameni := TZpravaForm.Create(self);
	if stav = 1 then
		with OZnameni do begin
	    text := obsah;
	    Budiz.Visible := True;
	    OkButton.Visible := False;
	    Zrusit.Visible := False;
	  end;
	if stav = 2 then
  	with Oznameni do begin
	    Text := obsah;
	    Budiz.Visible := False;
	    OkButton.Visible := True;
	    Zrusit.Visible := True;
	  end;
  OZnameni.ShowModal;
  Zprava := Oznameni.Kod_navrat;
  OZnameni.Destroy;
end;

function TForm1.Vlozit(obsah : string ;var promena_f : string) : boolean;
var Vklad : TVkladForm;
begin
 	Vklad := TVkladForm.Create(self);
 	with Vklad do begin
    Text := obsah;
    promena := promena_f;
  end;
  Vklad.ShowModal;
  promena_f := Vklad.promena;
  Vlozit := Vklad.Kod_navrat;
  Vklad.Destroy;
end;

end.
