unit Operace;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, DB, DBGrids;

type
  TOperaceForm = class(TForm)
    DBGrid1: TDBGrid;
    DBGrid2: TDBGrid;
    DBGrid3: TDBGrid;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Novy: TButton;
    Zmenit_jme: TButton;
    Zmenit_cas: TButton;
    Smazat: TButton;
    Konec: TButton;
    procedure FormCreate(Sender: TObject);
    procedure NovyClick(Sender: TObject);
    procedure Zmenit_jmeClick(Sender: TObject);
    procedure Zmenit_casClick(Sender: TObject);
    procedure SmazatClick(Sender: TObject);
    procedure KonecClick(Sender: TObject);
    procedure DBGrid2CellClick(Column: TColumn);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  OperaceForm: TOperaceForm;

implementation

uses hlavni;

{$R *.DFM}

procedure TOperaceForm.FormCreate(Sender: TObject);
begin
// nastaveni filtru na okamzitou nastavenou hodnotu vyrobku atd
  if Form1.Table2.Fields[0].Text <> '' then
		Form1.Table3.Filter:='idv=' + IntToStr(Form1.Table2.Fields[0].AsInteger);
// Zde zjistime zda je databazka prazdna pokud ano vypnem tlacitka
	if Form1.Table3.IsEmpty then begin
    Zmenit_jme.Enabled := False;
    Zmenit_cas.Enabled := False;
    Smazat.Enabled := False;
  end
  else begin
    Zmenit_jme.Enabled := True;
   	Zmenit_cas.Enabled := True;
    Smazat.Enabled := True;
  end;
end;

procedure TOperaceForm.NovyClick(Sender: TObject);
// tato procedura prida jednu operaci
var
	Zalozka  : TBookmark;
  jmeno, cas_str, filter: string;
  pokracuj : boolean;
  cas_int, code , posledni, ido_z_idv : integer;
begin
	pokracuj := True;
  cas_str := '1';
  //jmeno := 'oper';
  if Form1.Vlozit('Zadejte jmno operace : ',jmeno) and
  	Form1.Vlozit('Zadejte vrobn as operace (s): ',cas_str)then begin
  // pokud by nechtel zmenit jmeno InputQuery da False a cyklus konci
	  if (jmeno = '') then begin
    // Kontrola zda jmeno neni prazdne
  	  Form1.Zprava('Zadal jste przdn jmno',1);
      pokracuj := False;
    end;
    if pokracuj then begin
    	// kontrola zda jmeno se jiz neopakuje
      Zalozka := Form1.Table3.GetBookmark;
      // zde se spusti vyhledavani
     	if Form1.Table3.Locate('JMENO', jmeno, [loPartialKey]) then begin
	 	   	pokracuj := False;
		    Form1.Zprava('Zadal jste ji existujc jmno',1);
   		end;
	    // Zde po hledani se ukazatel vety nastavi na zalozku a ta se smaze
			Form1.Table3.GotoBookmark(Zalozka);
 			Form1.Table3.FreeBookmark(Zalozka);
    end;
  	val(cas_str, cas_int, code);
	  if (code <> 0) or (cas_int < 1) then begin
    // Kontrola zda cas je spravne nastaven
  	  Form1.Zprava('Zadal jste neplatn as', 1);
      pokracuj := False;
    end;
    if pokracuj and (cas_int > 9999) then begin
    // Kontrola zda cas je spravne nastaven
    	Form1.Zprava('Zadal jste pli vysok as. Maximln hodnota je 9999 s. ',1);
      pokracuj := False;
    end;
		if pokracuj then begin
			if pokracuj then begin
				//Nejdriv se zjisti cislo operace podle vrobku IDO_Z_IDV
	      // ulozime filter pro pozdejsi pouziti
        filter := Form1.Table3.Filter;
      	Form1.Table3.Filter := 'idv=' + (Form1.Table2.Fields[0].Text);
				Form1.Table3.Last;
    		ido_z_idv := Form1.Table3.Fields[5].AsInteger;
        // natahnenme filter zpet
				Form1.Table3.Filter := filter;
        // zde vypneme filter
 				Form1.Table3.Filtered := False;
        // zjistime cislo posledni operace
				Form1.Table3.Last;
        posledni := Form1.Table3.Fields[0].AsInteger;
				// a zde filter zase zapneme
 				Form1.Table3.Filtered := True;
        Form1.Table3.Last;
        // A zde se cely vysledek ulozi
  			Form1.Table3.Append;
				Form1.Table3.Fields[0].AsInteger := posledni + 1;
 				Form1.Table3.Fields[1].AsInteger := Form1.Table1.Fields[0].AsInteger;
				Form1.Table3.Fields[2].AsInteger := Form1.Table2.Fields[0].AsInteger;
				Form1.Table3.Fields[3].AsInteger := cas_int;
				Form1.Table3.Fields[4].AsString  := jmeno;
        Form1.Table3.Fields[5].AsInteger := ido_z_idv + 1;
			  Form1.Table3.Post;
	 		end;
		end;
  end;
// Zde zjistime zda je databazka prazdna pokud ano vypnem tlacitka
	if Form1.Table3.IsEmpty then begin
    Zmenit_jme.Enabled := False;
  	Zmenit_cas.Enabled := False;
    Smazat.Enabled := False;
  end
  else begin
    Zmenit_jme.Enabled := True;
   	Zmenit_cas.Enabled := True;
    Smazat.Enabled := True;
  end;
end;

procedure TOperaceForm.Zmenit_jmeClick(Sender: TObject);
// Tato procedura zmeni jmeno operace
var
	Zalozka : TBookmark;
  jmeno : string;
  pokracuj : boolean;
begin
	pokracuj := True;
	jmeno	:= Form1.Table3.Fields[4].AsString;
  if Form1.Vlozit('Zmte jmno operace : ',jmeno) then begin
  // pokud by nechtel zmenit jmeno InputQuery da False a cyklus konci
	  if (jmeno = '') then begin
    // Kontrola zda jmeno neni prazdne
  	  Form1.Zprava('Zadal jste przdn jmno, bude ponechno pvodn',1);
      pokracuj := False;
    end;
    if pokracuj then begin
    	// kontrola zda jmeno se jiz neopakuje
      Zalozka := Form1.Table3.GetBookmark;
      // zde se spusti vyhledavani
     	if Form1.Table3.Locate('JMENO', jmeno, [loPartialKey]) then begin
	 	   	pokracuj := False;
		    Form1.Zprava('Zadal jste ji existujc jmno',1);
   		end;
	    // Zde po hledani se ukazatel vety nastavi na zalozku a ta se smaze
			Form1.Table3.GotoBookmark(Zalozka);
 			Form1.Table3.FreeBookmark(Zalozka);
    end;
    // A zde se cely vysledek ulozi
		if pokracuj then begin
 			Form1.Table3.Edit;
			Form1.Table3.Fields[4].AsString := jmeno;
		  Form1.Table3.Post;
 		end;
  end;
end;

procedure TOperaceForm.Zmenit_casClick(Sender: TObject);
// Tato procedura zmeni vyrobni cas operace
var
  cas_str : string;
  pokracuj : boolean;
  cas_int, code : integer;
begin
	pokracuj := True;
	cas_str	:= IntToStr(Form1.Table3.Fields[3].AsInteger);
  if Form1.Vlozit('Zadejte nov vrobn as operace : ',cas_str) then begin
  // pokud by nechtel zmenit jmeno InputQuery da False a cyklus konci
  	val(cas_str, cas_int, code);
	  if (code <> 0) or (cas_int < 1) then begin
    // Kontrola zda cas je spravne nastaven
  	  Form1.Zprava('Zadal jste neplatn as',1);
      pokracuj := False;
    end;
    if pokracuj and (cas_int > 9999) then begin
    // Kontrola zda cas je spravne nastaven
  	  Form1.Zprava('Zadal jste pli vysok as. Maximln hodnota je 9999 s. ',1);
      pokracuj := False;
    end;
		if pokracuj then begin
 			Form1.Table3.Edit;
			Form1.Table3.Fields[3].AsInteger := cas_int;
		  Form1.Table3.Post;
		end;
  end;
end;

procedure TOperaceForm.SmazatClick(Sender: TObject);
// Tato procedura smaze operaci
var
  poradi : integer;
  filter, jme_vyr : string;
begin
	poradi := 0;
  //  zde se naposledy zepta zda to myslis vazne
	if Form1.Zprava('Chcete operaci ' + Form1.Table3.Fields[4].AsString + ' opravdu smazat ?',2) then begin
 		// a ZDE prepiseme poradi operaci na vyrobku tak aby odpovidalo skutecnosti
    // zde ulozime kod operace pro kterou budeme delat toto pretrideni
    jme_vyr := (Form1.Table3.Fields[2].Text);
  	// mezitim muzeme smazat operaci
		Form1.Table3.Delete;
	  // ulozime filter pro pozdejsi pouziti
    filter := Form1.Table3.Filter;
		// nastavime filter na vyrobek z nehoz byla smazana operace
   	Form1.Table3.Filter := 'idv=' + jme_vyr;
		// pak projedeme vsechny zbivajici operace a prepiseme umisteni
		while not(Form1.Table3.Eof) do begin
			// zde zvetsujeme poradi postupne po jedne
    	poradi := poradi + 1;
		 	Form1.Table3.Edit;
	   	Form1.Table3.Fields[5].AsInteger := poradi;
     	Form1.Table3.Post;
			Form1.Table3.Next;
    end;
    // natahnenme filter zpet
		Form1.Table3.Filter := filter;
	end;
// Zde zjistime zda je databazka prazdna pokud ano vypnem tlacitka
	if Form1.Table3.IsEmpty then begin
    Zmenit_jme.Enabled := False;
  	Zmenit_cas.Enabled := False;
    Smazat.Enabled := False;
  end
  else begin
    Zmenit_jme.Enabled := True;
   	Zmenit_cas.Enabled := True;
    Smazat.Enabled := True;
  end;
end;

procedure TOperaceForm.KonecClick(Sender: TObject);
begin
	Close;
end;

procedure TOperaceForm.DBGrid2CellClick(Column: TColumn);
begin
	// nastaveni filtru na okamzitou nastavenou hodnotu vyrobku atd
  if Form1.Table2.Fields[0].Text <> '' then
		Form1.Table3.Filter:='idv=' + IntToStr(Form1.Table2.Fields[0].AsInteger);
end;

end.
