unit Stroje;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, DB, DBGrids, StdCtrls;

type
  TStrojeForm = class(TForm)
    DBGrid1: TDBGrid;
    Label1: TLabel;
    Novy: TButton;
    Zmenit_jme: TButton;
    Zmenit_ser: TButton;
    Smazat: TButton;
    Konec: TButton;
    procedure NovyClick(Sender: TObject);
    procedure Zmenit_jmeClick(Sender: TObject);
    procedure Zmenit_serClick(Sender: TObject);
    procedure SmazatClick(Sender: TObject);
    procedure KonecClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  StrojeForm: TStrojeForm;

implementation

uses hlavni;

{$R *.DFM}

procedure TStrojeForm.NovyClick(Sender: TObject);
// Tato procedura prida stroj
var
	Zalozka  : TBookmark;
  jmeno, cas_str : string;
  pokracuj : boolean;
  cas_int, code , posledni: integer;
begin
	pokracuj := True;
  cas_str := '0';
  if Form1.Vlozit('Zadejte jmno stroje : ',jmeno) and
  	Form1.Vlozit('Zadejte seizovac as (s): ',cas_str)then begin
  // pokud by nechtel zmenit jmeno InputQuery da False a cyklus konci
	  if (jmeno = '') then begin
    // Kontrola zda jmeno neni prazdne
  	  Form1.Zprava('Zadal jste przdn jmno',1);
      pokracuj := False;
    end;
  	val(cas_str, cas_int, code);
	  if (code <> 0) or (cas_int < 0) then begin
    // Kontrola zda cas je spravne nastaven
  	  Form1.Zprava('Zadal jste neplatn as', 1);
      pokracuj := False;
    end;
    if pokracuj and (cas_int > 9999) then begin
    // Kontrola zda cas je spravne nastaven
  	  Form1.Zprava('Zadal jste pli vysok seizovac as. Maximln hodnota je 9999 s. ',1);
      pokracuj := False;
    end;
		if pokracuj then begin
    	// kontrola zda jmeno se jiz neopakuje
      Zalozka := Form1.Table1.GetBookmark;
     	if Form1.Table1.Locate('JMENO', jmeno, [loPartialKey]) then begin
	 	   	pokracuj := False;
		    Form1.Zprava('Zadal jste existujc jmno',1);
   		end;
      // A zde se cely vysledek ulozi
			if pokracuj then begin
				Form1.Table1.Last;
        posledni := Form1.Table1.Fields[0].AsInteger;
  			Form1.Table1.Append;
				Form1.Table1.Fields[0].AsInteger := posledni + 1;
				Form1.Table1.Fields[1].AsString := jmeno;
				Form1.Table1.Fields[2].AsInteger := cas_int;
			  Form1.Table1.Post;
	 		end;
	    // Zde se po hledani ukazatel vety nastavi zpatky na zalozku a ta se smaze
			Form1.Table1.GotoBookmark(Zalozka);
 			Form1.Table1.FreeBookmark(Zalozka);
		end;
  end;
// Zde zjistime zda je databazka prazdna pokud ano vypnem tlacitka
	if Form1.Table1.IsEmpty then begin
    Zmenit_jme.Enabled := False;
  	Zmenit_ser.Enabled := False;
    Smazat.Enabled := False;
  end
  else begin
    Zmenit_jme.Enabled := True;
   	Zmenit_ser.Enabled := True;
    Smazat.Enabled := True;
  end;
end;

procedure TStrojeForm.Zmenit_jmeClick(Sender: TObject);
// Tato procedura zmeni jmeno stroje
var
	Zalozka  : TBookmark;
  jmeno : string;
  pokracuj : boolean;
begin
	pokracuj := True;
	jmeno	:= Form1.Table1.Fields[1].AsString;
  if Form1.Vlozit('Zmte jmno stroje : ',jmeno) then begin
  // pokud by nechtel zmenit jmeno InputQuery da False a cyklus konci
	  if (jmeno = '') then begin
    // Kontrola zda jmeno neni prazdne
  	  Form1.Zprava('Zadal jste przdn jmno, bude ponechno pvodn',1);
      pokracuj := False;
    end;
		if pokracuj then begin
    	// kontrola zda jmeno se jiz neopakuje
      Zalozka := Form1.Table1.GetBookmark;
      // zde se spusti vyhledavani
     	if Form1.Table1.Locate('JMENO', jmeno, [loPartialKey]) then begin
	 	   	pokracuj := False;
		    Form1.Zprava('Zadal jste ji existujc jmno, bude ponechn pvodn',1);
   		end;
      // A zde se cely vysledek ulozi
			if pokracuj then begin
  			Form1.Table1.Edit;
				Form1.Table1.Fields[1].AsString := jmeno;
			  Form1.Table1.Post;
	 		end;
	    // Zde po hledani se ukazatel vety nastavi na zalozku a ta se smaze
			Form1.Table1.GotoBookmark(Zalozka);
 			Form1.Table1.FreeBookmark(Zalozka);
		end;
  end;
end;

procedure TStrojeForm.Zmenit_serClick(Sender: TObject);
// Tato procedura zmeni serizovaci cas stroje
var
  cas_str : string;
  pokracuj : boolean;
  cas_int, code : integer;
begin
	pokracuj := True;
	cas_str	:= IntToStr(Form1.Table1.Fields[2].AsInteger);
  if Form1.Vlozit('Zadejte nov seizovac as stroje : ',cas_str) then begin
  // pokud by nechtel zmenit jmeno InputQuery da False a cyklus konci
  	val(cas_str, cas_int, code);
	  if (code <> 0) or (cas_int < 0) then begin
    // Kontrola zda cas je spravne nastaven
  	  Form1.Zprava('Zadal jste neplatn as',1);
      pokracuj := False;
    end;
    if pokracuj and (cas_int > 9999) then begin
    // Kontrola zda cas je spravne nastaven
  	  Form1.Zprava('Zadal jste pli vysok seizovac as. Maximln hodnota je 9999 s. ',1);
      pokracuj := False;
    end;
		if pokracuj then begin
 			Form1.Table1.Edit;
			Form1.Table1.Fields[2].AsInteger := cas_int;
		  Form1.Table1.Post;
		end;
  end;
end;

procedure TStrojeForm.SmazatClick(Sender: TObject);
	// Tato procedura smaze stroj
var
	Zalozka  : TBookmark;
  kod : integer;
  pokracuj : boolean;
begin
	pokracuj := True;
	kod	:= Form1.Table1.Fields[0].AsInteger;
  // kontrola zda neni jeste nejaka operace pro tento stroj
  Zalozka := Form1.Table3.GetBookmark;
  // zde se spusti vyhledavani
 	if Form1.Table3.Locate('IDM', kod, [loPartialKey]) then begin
   	pokracuj := False;
    Form1.Zprava('Na tomto stroji jsou jet njak operace',1);
	end;
  // A zde se naposledy zepta zda to myslis vazne
	if pokracuj and Form1.Zprava('Chcete stroj ' + Form1.Table1.Fields[1].AsString + ' opravdu smazat ?',2) then begin
		Form1.Table1.Delete;
	end;
  // Zde po hledani se ukazatel vety nastavi na zalozku a ta se smaze
	Form1.Table3.GotoBookmark(Zalozka);
	Form1.Table3.FreeBookmark(Zalozka);
// Zde zjistime zda je databazka prazdna pokud ano vypnem tlacitka
	if Form1.Table1.IsEmpty then begin
    Zmenit_jme.Enabled := False;
  	Zmenit_ser.Enabled := False;
    Smazat.Enabled := False;
  end
  else begin
    Zmenit_jme.Enabled := True;
   	Zmenit_ser.Enabled := True;
    Smazat.Enabled := True;
  end;
end;

procedure TStrojeForm.KonecClick(Sender: TObject);
begin
	Close;
end;

procedure TStrojeForm.FormCreate(Sender: TObject);
begin
// Zde zjistime zda je databazka prazdna pokud ano vypnem tlacitka
	if Form1.Table1.IsEmpty then begin
    Zmenit_jme.Enabled := False;
  	Zmenit_ser.Enabled := False;
    Smazat.Enabled := False;
  end
  else begin
    Zmenit_jme.Enabled := True;
   	Zmenit_ser.Enabled := True;
    Smazat.Enabled := True;
  end;
end;

end.
