unit Vypocet;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Mask, DBCtrls, Grids, DBGrids, DB, DBTables, ExtCtrls, Printers;

type
 	Pdvojice = ^TDvojice;
 	TDvojice = record
   	ido1 : integer;
    ido2 : integer;
		pros : integer;
  end;

  PTrojice = ^TTrojice;
 	TTrojice = record
   	ido : integer;
    idv : integer;
    cas : integer;
    misto : integer;
		Cas_zac : integer;
 		Cas_kon : integer;
    Cas_cel : integer;
    Cas_pro : integer;
  end;

	PSeznam = ^TSeznam;
  TSeznam = TList;

  TVypocetForm = class(TForm)
    Zpet: TButton;
    Edit1: TEdit;
    vypocet: TButton;
    Label1: TLabel;
    Edit2: TEdit;
    Zpusob: TRadioGroup;
    Metoda: TRadioGroup;
    GroupBox1: TGroupBox;
    Label4: TLabel;
    Label7: TLabel;
    Edit4: TEdit;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    GroupBox3: TGroupBox;
    Label5: TLabel;
    Label6: TLabel;
    Label8: TLabel;
    Label2: TLabel;
    Label9: TLabel;
    Edit5: TEdit;
    Met_lok: TRadioGroup;
    Label10: TLabel;
    CheckBox1: TCheckBox;
    Edit3: TEdit;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    tisk: TButton;
    Memo1: TMemo;
    Ulozit: TButton;
    SaveDialog1: TSaveDialog;
    Soused: TRadioGroup;
    Zapis_prubehu: TRadioGroup;
    Co_zapisovat: TRadioGroup;
    PrintDialog1: TPrintDialog;
		function Poc_vet_op(masina : integer) : integer;
    procedure	Naplneni_Zaklad;
		procedure	Naplneni_Kontrolni;
    procedure	Zobraz(var Seznam : TSeznam; typ : integer);
    procedure ZpetClick(Sender: TObject);
    procedure vypocetClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MetodaClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure tiskClick(Sender: TObject);
    procedure UlozitClick(Sender: TObject);
		procedure Kopie (var Seznam1, Seznam2 : TSeznam);
    procedure Zapis_prubehuClick(Sender: TObject);
    procedure Co_zapisovatClick(Sender: TObject);
	  private
    { Private declarations }
  	public
			Vypis : TSeznam;
			Kontrolni : TSeznam;
      Zaklad  : TSeznam;
			Vysledny_krok ,vysledny_cas, kroky, typ, n, teplota, cas_zad, cas_trv : integer;
	    cas_zacatek, cas_vypoctu : string;
  	end;

var
  VypocetForm : TVypocetForm;

implementation

uses hlavni, prubeh;

{$R *.DFM}

// zjisti pocet operaci na jednotlivych strojich
function TVypocetForm.Poc_vet_op(masina : integer) : integer;
begin
	Form1.Table3.First;
	Form1.Table3.Filter := 'idm=' + IntToStr(masina);
	Poc_vet_op := Form1.Table3.RecordCount;
end;

// zde prevedeme data z dbf do Seznamu
procedure	TVypocetForm.Naplneni_Zaklad;
var i, j, kusy, ser_cas : integer;
		Masina : Tseznam;
    Trojice : PTrojice;
begin
	Form1.Table1.First;
	//Zde se naplni ZAKLAD - Zakladni varianta usporadani
	for i := 1 to Form1.Table1.RecordCount do begin
  	//Zde se projedou vsechny stroje
    Form1.Table3.Filter := 'idm=' + IntToStr(Form1.Table1.Fields[0].AsInteger);
    Form1.Table3.First;
    Masina := TList.Create;
    // nejdrive zjistime hodnotu serizovacich casu
		Form1.Table1.Locate('IDM', Form1.Table3.Fields[1].AsInteger, [loPartialKey]);
		ser_cas := Form1.Table1.Fields[2].AsInteger;
    //Zde se projedou vsechny operace na stroji
    for j := 1 to Form1.Table3.RecordCount do begin
			// A ZDE ZJISTUJEME pocet kusu jednotlivych vyrobklu
			Form1.Table2.Locate('IDV', Form1.Table3.Fields[2].AsInteger, [loPartialKey]);
			kusy := Form1.Table2.Fields[2].AsInteger;
    	New(Trojice);
      // zde nahrajeme jednotlive udaje do seznamu
 	   	Trojice^.ido := Form1.Table3.Fields[0].AsInteger;
			Trojice^.idv := Form1.Table3.Fields[2].AsInteger;
		 	Trojice^.cas := kusy * Form1.Table3.Fields[3].AsInteger + ser_cas;
		 	Trojice^.misto := Form1.Table3.Fields[5].AsInteger;
      Trojice^.cas_cel := 0;
      Trojice^.cas_pro := 0;
      Masina.Add(Trojice);
	    Form1.Table3.Next;
		end;
    Form1.Table1.Next;
  	Zaklad.Add(Masina);
  end;
end;

// zde vytvotime kontrolni seznam
procedure	TVypocetForm.Naplneni_Kontrolni;
var i, k, j : integer;
		Masina, Masina_z : Tseznam;
    Dvojice : PDvojice;
    Operace_z, Zkuseb : PTrojice;
begin
  {Zde se naplni kontrolni seznam operaci ktere se nesmi predbihat}
	for i := 1 to Zaklad.Count do begin
  {Zde se projedou vsechny stroje}
	  Masina_z := Zaklad.Items[i - 1];
    Masina := TList.Create;
    for j := 1 to Masina_z.Count - 1 do begin
    {Zde se postupne projedou vsechny operace na danem stroji}
    	Operace_z := Masina_z.Items[j - 1];
      for k := j + 1 to Masina_z.Count do begin
      	{Zde se hleda ke kazde operaci operace na stejnem vyrobku}
        Zkuseb := Masina_z.Items[k - 1];
				if Operace_z.idv = Zkuseb.idv then begin
        	New(Dvojice);
    	   	Dvojice^.Ido1 := Operace_z.ido;
				 	Dvojice^.Ido2 := Zkuseb.ido;
          Masina.Add(Dvojice);
          Break;
	      end;
			end;
    end;
    Kontrolni.Add(Masina);
  end;
end;

// zde zobrazime seznam
procedure	TVypocetForm.Zobraz(var Seznam : TSeznam; typ : integer);
var j, i : integer;
		Vys : TextFile;
		Masina : TSeznam;
	  Operace : PTrojice;
begin
	//Tato procedura zobrazi dany seznam jako soubor Vysledek.TXT
  //nejdrive smazeme posledni vysledek
	DeleteFile('vysledek.txt');
  AssignFile(Vys,'vysledek.txt');
  try
  	// zde vytvorime novy vysledek.TXT
		ReWrite(Vys);
		//  zderozhodnem  zda vypisovat hlavicku
    if Ulozit.Enabled then begin
	    // A zde postupne vypisujeme hodnoty
			Writeln(Vys);
  		Write(Vys,'                                          Vsledek hledn ');
	    if Zpusob.ItemIndex = 0 then Writeln(Vys,'nejkratho vrobnho asu')
	    else Writeln(Vys,'nejmench prostuj');
			Writeln(Vys);
	   	Write(Vys,'       Pouit metoda : ');
	    case Metoda.ItemIndex of
	    	0 : Writeln(Vys,'een se prochzela postupn');
	      1 : if Met_Lok.ItemIndex = 0 then Writeln(Vys,'Lokln minimum nejstrmjho spdu')
	          else Writeln(Vys,'Lokln minimum nhodnho spdu');
	      2 : begin
	      			Writeln(Vys,' Simulovan hn');
							Writeln(Vys,'         Teplota : ', Edit2.Text);
	 						Writeln(Vys,'         Poet interac : ', Edit1.Text);
  	    		end;
	      3 : Writeln(Vys,'Standartn Tabu Search metoda');
	    end;
	    Writeln(Vys,'       Datum vpotu : ', DateToStr(Date));
			Writeln(Vys,'       ', Label10.Caption);
	    Writeln(Vys,'       Poet krok : ', Label8.Caption);
	    Writeln(Vys,'       Dosaen as : ',vysledny_cas);
    end;
			Writeln(Vys);
    // a zde postupne za pisuju skutecne hodnoty z Seznamu Vysledek
    for i := 1 to Seznam.Count do begin
    	Masina := Seznam.Items[i - 1];
			Form1.Table1.Locate('IDM', i, [loPartialKey]);
      Writeln(Vys,'       Jmno stroje : ',Form1.Table1.Fields[1].AsString);
			Writeln(Vys,'       Seizovac as stroje : ', Form1.Table1.Fields[2].AsInteger);
      for j := 1 to Masina.Count do begin
				Form1.Table3.Filtered := False;
      	Operace := Masina.Items[j -1];
				Form1.Table2.Locate('IDV', Operace^.Idv, [loPartialKey]);
				Form1.Table3.Locate('IDO', Operace^.Ido, [loPartialKey]);
				Write(Vys, '            ','Vrobek .',Operace^.Idv,' : ',Form1.Table2.Fields[1].AsString,'   -   ');
				Write(Vys,'Operace .',Operace^.Ido,' : ',Form1.Table3.Fields[4].AsString,'   -   ');
        Write(Vys, 'as : ', Operace^.cas);
 				if Ulozit.Enabled then Write(Vys,'  -  zane ',Operace^.cas_zac,'s a skon ',Operace^.cas_kon,'s');
				Writeln(Vys);
				Form1.Table3.Filtered := True;        
      end;
      if Ulozit.Enabled then begin
	      Writeln(Vys,'       Celkov as stroje : ', PTrojice(Masina.Items[0]).cas_cel);
				Writeln(Vys,'       Celkov prostoje stroje : ', PTrojice(Masina.Items[0]).cas_pro);
      end;
    	Writeln(Vys);
    end;
  finally
	  CloseFile(Vys);
  end;
	Memo1.Lines.LoadFromFile('vysledek.txt');
end;

procedure TVypocetForm.ZpetClick(Sender: TObject);
begin
	Close;
end;

{Zde zacne samotny vypocet}
procedure TVypocetForm.vypocetClick(Sender: TObject);
var code : integer;
		zacni : boolean;
		Prubeh : TPrubehForm;
begin
  Label1.Caption := 'Nejlep vsledek : ';
  // ulozime cas vypoctu
	cas_zacatek := TimeToStr(Time);
	// nastavi do casu 0
	Label8.Caption := '0' ;
	zacni := true;
  // zde se postupne kontroluji zadane hodnoty
	Val(Edit1.Text,n,Code);
	if (code <> 0) or (n < 1) then begin
		Form1.Zprava('patn zadan poet interac',1);
    zacni := false;
  end;
	Val(Edit2.Text,teplota,Code);
	if zacni and ((code <> 0) or (teplota < 1)) then begin
		Form1.Zprava('patn zadan teplota',1);
    zacni := false;
  end;
	Val(Edit3.Text,cas_zad,Code);
	if zacni and ((code <> 0) or (cas_zad < 1)) then begin
		Form1.Zprava('patn zadan hledan as',1);
    zacni := false;
  end;
 	Val(Edit4.Text,cas_trv,Code);
	if zacni and ((code <> 0) or (cas_trv < 1)) then begin
		Form1.Zprava('patn zadan doba hledn',1);
    zacni := false;
  end;
 	Val(Edit5.Text,kroky,Code);
	if zacni and ((code <> 0) or (kroky < 1)) then begin
		Form1.Zprava('patn zadan poet krok',1);
    zacni := false;
  end;
  if  Zpusob.ItemIndex = 0 then  typ := 1
  else typ := 2;
  // zde se  rozhodne jakou metodu pouzijeme
	if zacni then begin
    // vymaze memo1
  	Memo1.Lines.Text := ('');
  	// Tato procedura spusti vypocet
	 	Prubeh := TPrubehForm.Create(self);
    // pretahneme hodnoty do PrubehForm
		Prubeh.kroky := kroky;
	  Prubeh.typ := Typ;
	  Prubeh.n := n;
	  Prubeh.teplota := teplota;
	  Prubeh.cas_zad := cas_zad;
	  Prubeh.cas_trv := cas_trv;
	  Prubeh.cas_zacatek := cas_zacatek;
    Prubeh.Label8.Caption := cas_zacatek;
		// Nastaveni metod
		Prubeh.Metoda := Metoda.ItemIndex;
		Prubeh.Met_Lok := Met_Lok.ItemIndex;
		Prubeh.Zapis_prubehu := Zapis_prubehu.ItemIndex;
   	Prubeh.Co_zapisovat := Co_zapisovat.ItemIndex;
 		Prubeh.soused := Soused.ItemIndex;
		Prubeh.CheckBox1 := CheckBox1.Checked;
    Prubeh.CheckBox2 := CheckBox2.Checked;
    Prubeh.CheckBox3 := CheckBox3.Checked;
    Kopie(Prubeh.Zaklad, Zaklad);
    Kopie(Prubeh.Kontrolni, Kontrolni);
	 	Prubeh.ShowModal;
	  // skopirujeme vysledek do VYPIS
	 	Kopie(Vypis,Prubeh.Vysledek);
	  // nahrajeme vypoctene hodnoty do VypocetForm
	  Vysledny_krok := StrToInt(Prubeh.Label6.Caption);
	 	Vysledny_cas := StrToInt(Prubeh.Label5.Caption);
	  Cas_vypoctu := Prubeh.Label7.Caption;
	  Prubeh.destroy;
    // zapiseme kroky a casy do tabulky
    Label5.Caption := Label5.Caption + IntToStr(Vysledny_cas);
    Label8.Caption := IntToStr(Vysledny_krok);
		Label10.Caption := 'as vpotu : ' + Cas_vypoctu;
		// Zkontroluje zda metoda neco nasla a pokud ano vypise obsah
    if typ = 1 then Label5.Caption := 'Nalezen as : '
    else Label5.Caption := 'Nalezen prostoj : ';
		// zde kontrolujeme zda bylo nalezeno reseni a podle toho upravujeme vypis
	  if vysledny_cas > 0 then begin
			// pokud bylo nalezeno reseni uvolnime tlacitka tisk, ulozit
      Tisk.Enabled := True;
      Ulozit.Enabled := True;
		  Zobraz(Vypis,typ);
			// vypiseme cas
		  Label5.Caption := Label5.Caption + IntToStr(Vysledny_cas) + ' s';
      // popripade hlasku jestli jsme dosahli zadaneho casu
			if (Vysledny_cas > cas_zad) and CheckBox1.Checked then
  			Form1.Zprava('een bylo nalezeno, bohuel je vt ne zadan as !!!',1);
	 	end
 		else begin
    	// pokud nebylo nalezeno reseni zmenime vypis
 			Form1.Zprava('Nepodailo se najit dn een !!!',1);
			Label5.Caption := Label5.Caption + 'NENALEZEN';
    	// pokud nebylo nalezeno reseni zakazeme tlacitka tisk, ulozit
      Tisk.Enabled := False;
      Ulozit.Enabled := False;
 	 	end;
  end;
end;

// Ukoncujici procedura formulare
procedure TVypocetForm.FormDestroy(Sender: TObject);
var i, j : integer;
begin
  //Vynulovani Kontrolni
  for i := Kontrolni.Count - 1 downto 0 do
    Dispose (Kontrolni.Items[i]);
  Kontrolni.Free;

  //Vynulovani Zaklad
  for i := Zaklad.Count - 1 downto 0 do begin
    for j := Tseznam(Zaklad.Items[i]).Count - 1 downto 0 do
       Dispose (TSeznam(Zaklad.Items[i]).Items[j]);
    TSeznam (Zaklad.Items[i]).Free;
  end;
  Zaklad.Free;

  //Vynulovani Vypisu
  for i := Vypis.Count - 1 downto 0 do begin
    for j := Tseznam(Vypis.Items[i]).Count - 1 downto 0 do
       Dispose (TSeznam(Vypis.Items[i]).Items[j]);
    TSeznam (Vypis.Items[i]).Free;
  end;
  Vypis.Free;
end;

// vytvarejici procedura formulare
procedure TVypocetForm.FormCreate(Sender: TObject);
begin
	//Vymazani tabulky vysledku
 	Memo1.Clear;
  // vypnuti tlacitek TISK, ULOZIT
  Tisk.Enabled := False;
  Ulozit.Enabled := False;
  //Nastaveni defoultnich hodnot do vsech parametru
  //vysledny cas
  Label8.Caption := '0' ;
	// pocet interaci pro simul zihani
	Edit1.Text := '10';
	// teplota pro simul zihani
	Edit2.Text := '100';
  // pozadovany cas pro ukonceni
	Edit3.Text := '1000';
  // doba vypoctu  pro ukonceni
	Edit4.Text := '10';
  // pocet interaci pro ukonceni
	Edit5.Text := '5000';
  // Nastaveni Radio buttonu na prvni hodnotu
  // Heldat Cas, Prostoj
	Zpusob.ItemIndex := 0;
  //Jakou metodou hledat
	Metoda.ItemIndex := 0;
  // kterou metodou lokalniho minima
	Met_Lok.ItemIndex := 0;
  // zda chci zapisovat
	Zapis_prubehu.ItemIndex := 0;
	// a co chci zapisovat
	Co_zapisovat.ItemIndex := 0;
  // kterou metodou vyberu souseda
	Soused.ItemIndex := 0;
  // zapnuti ukoncujicich podminek
  // Hledany cas
	CheckBox1.Checked := True;
  // doba behu
 	CheckBox2.Checked := True;
  // pocet interaci
	CheckBox3.Checked := True;
  // a somotne nastaveni pro prvni vybranou metodu
  // kterou je projet vsechno
	Edit1.Enabled := False;
	Edit2.Enabled := False;
  Label2.Enabled := False;
	Label3.Enabled := False;
  GroupBox2.Enabled := False;
 	Met_Lok.Enabled := False;
	Co_zapisovat.Enabled := False;
  //zde se vytvori seznamy pro vypocet ktere se nebudou menit
	Kontrolni := TList.Create;
  Zaklad := TList.Create;
  Vypis := TList.Create;
	// ZDE SE TYTO SEZNAMY NAPLNI
  Naplneni_Zaklad;
	Naplneni_Kontrolni;
  Zobraz(Zaklad,typ);
end;

// Tato metoda postupne vypina a zapina jednotlive prvky
// podle vybrane metody
procedure TVypocetForm.MetodaClick(Sender: TObject);
begin
  // Metoda projit vsechno
	if Metoda.ItemIndex = 0 then begin
		Label2.Enabled := False;
	  Label3.Enabled := False;
    Edit1.Enabled := False;
		Edit2.Enabled := False;
	  GroupBox2.Enabled := False;
   	Met_Lok.Enabled := False;
 		Soused.Enabled := False;
	end;
  // Metoda Lokalniho minima
	if Metoda.ItemIndex = 1 then begin
		Label2.Enabled := False;
	  Label3.Enabled := False;
    Edit1.Enabled := False;
		Edit2.Enabled := False;
	 	Edit3.Enabled := True;
	 	Edit4.Enabled := True;
   	Met_Lok.Enabled := True;
    GroupBox2.Enabled := False;
 		Soused.Enabled := True;
	end;
  // Metoda simulovaneho zihani
	if Metoda.ItemIndex = 2 then begin
		Label2.Enabled := True;
	  Label3.Enabled := True;
    Edit1.Enabled := True;
		Edit2.Enabled := True;
    GroupBox2.Enabled := True;
   	Met_Lok.Enabled := False;
 		Soused.Enabled := True;
	end;
  // Metoda Tabu search
	if Metoda.ItemIndex = 3 then begin
		Label2.Enabled := False;
	  Label3.Enabled := False;
    Edit1.Enabled := False;
		Edit2.Enabled := False;
    GroupBox2.Enabled := False;
   	Met_Lok.Enabled := False;
 		Soused.Enabled := True;
	end;
end;

// nasledujici tri procedury prepinaji vyditelnosti
// jednotlivych ukoncujicich podminek podle sepnuti
procedure TVypocetForm.CheckBox1Click(Sender: TObject);
// Hledany cas
begin
	if 	CheckBox1.Checked = False then begin
  	Label4.Enabled := False;
    Edit3.Enabled := False;
  end
  else begin
  	Label4.Enabled := True;
    Edit3.Enabled := True;
  end
end;

procedure TVypocetForm.CheckBox2Click(Sender: TObject);
// doba behu vypoctu
begin
	if 	CheckBox2.Checked = False then begin
  	Label7.Enabled := False;
    Edit4.Enabled := False;
  end
  else begin
  	Label7.Enabled := True;
    Edit4.Enabled := True;
  end
end;

procedure TVypocetForm.CheckBox3Click(Sender: TObject);
// pocet kroku
begin
	if 	CheckBox3.Checked = False then begin
  	Label9.Enabled := False;
    Edit5.Enabled := False;
  end
  else begin
  	Label9.Enabled := True;
    Edit5.Enabled := True;
  end
end;


procedure TVypocetForm.tiskClick(Sender: TObject);
var
	PrintFile: TextFile;
	i, LinesPerPage: integer;
begin
	if PrintDialog1.Execute then
	begin
		AssignPrn (PrintFile);
		Rewrite (PrintFile);
		Printer.Canvas.Font := Memo1.Font;
		for i := 0 to Memo1.Lines.Count - 1 do
			Writeln (PrintFile, Memo1.Lines [i]);
		System.CloseFile (PrintFile);
	end;
end;

procedure TVypocetForm.UlozitClick(Sender: TObject);
begin
 	if SaveDialog1.Execute then  begin
		if (FileSearch(SaveDialog1.FileName,GetCurrentDir) <> '') then begin
    	//zde se zkontroluje zda soubor jiz neexistuje
      if Form1.Zprava('Soubor tohoto jmna ji existuje. Pepsat soubor ?',2) then
      // pokud ano pozada se o moznost prepsani
				Memo1.Lines.SaveToFile(SaveDialog1.FileName);
    end
    else
    	Memo1.Lines.SaveToFile(SaveDialog1.FileName);
	end;
end;

// zkopiruje jeden seznam do druheho
procedure TVypocetForm.Kopie (var Seznam1, Seznam2 : TSeznam);
var	Masina1, Masina2 : TSeznam;
		Trojice1, Trojice2 : PTrojice;
    i, j : integer;
begin
	//Zde se vymaze puvodni seznam
  if seznam1 <> nil then begin
		for i := (seznam1.Count - 1) downto 0 do begin
	    for j := Tseznam(seznam1.Items[i]).Count - 1 downto 0 do
	       Dispose (TSeznam(seznam1.Items[i]).Items[j]);
	    TSeznam (seznam1.Items[i]).Free;
	  end;
		Seznam1.Free;
  end;
	//Zde konci mazani seznamu
	Seznam1 := TList.Create;
	for i := 1 to Seznam2.Count do begin
  	Masina1 := Seznam2.Items[i - 1];
    Masina2 := TList.Create;
    for j := 1 to Masina1.Count do begin
      New(Trojice2);
      Trojice1 := Masina1.Items[j - 1];
      Trojice2^.Ido := Trojice1^.Ido;
      Trojice2^.Idv := Trojice1^.Idv;
      Trojice2^.Cas := Trojice1^.Cas;
      Trojice2^.Misto := Trojice1^.Misto;
      Trojice2^.Cas_cel := Trojice1^.Cas_cel;
      Trojice2^.Cas_pro := Trojice1^.Cas_pro;
      Trojice2^.Cas_zac := Trojice1^.Cas_zac;
      Trojice2^.Cas_kon := Trojice1^.Cas_kon;
			Masina2.Add(Trojice2);
	  end;
    Seznam1.Add(Masina2);
  end;
end;

procedure TVypocetForm.Zapis_prubehuClick(Sender: TObject);
begin
	if 	Zapis_prubehu.ItemIndex = 0 then begin
   	Co_zapisovat.Enabled := False;
  end
  else begin
		Co_zapisovat.Enabled := True;
    Form1.Zprava(' Prubh vypotu se ulo po 500 krocch do souboru prubeh.txt. Pi ptm vpotu se smae !!!',1);
  end;
end;

procedure TVypocetForm.Co_zapisovatClick(Sender: TObject);
begin
	if 	Co_zapisovat.ItemIndex = 1 then begin
    if not(Form1.Zprava(' Pi vypotu se vyzkou vechny metody, vpoet bude trvat del chvli !!  Pokraovat ?',2)) then Co_zapisovat.ItemIndex := 0;
  end;
end;

end.
