unit Vyrobky;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, DB, DBGrids;

type
  TVyrobkyForm = class(TForm)
    Label1: TLabel;
    DBGrid1: TDBGrid;
    Novy: TButton;
    Zmenit_jme: TButton;
    Zmenit_kus: TButton;
    Smazat: TButton;
    Konec: TButton;
    procedure NovyClick(Sender: TObject);
    procedure Zmenit_jmeClick(Sender: TObject);
    procedure Zmenit_kusClick(Sender: TObject);
    procedure SmazatClick(Sender: TObject);
    procedure KonecClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  VyrobkyForm: TVyrobkyForm;

implementation

uses hlavni;

{$R *.DFM}

procedure TVyrobkyForm.NovyClick(Sender: TObject);
// Tato procedura prida vyrobek
var
	Zalozka  : TBookmark;
  jmeno, kus_str : string;
  pokracuj : boolean;
  kus_int, code , posledni: integer;
begin
	pokracuj := True;
	kus_str := '1';
  if Form1.Vlozit('Zadejte jmno vrobku : ',jmeno) and
  	Form1.Vlozit('Zadejte poet kus : ',kus_str)then begin
  // pokud by nechtel zmenit jmeno InputQuery da False a cyklus konci
	  if (jmeno = '') then begin
    // Kontrola zda jmeno neni prazdne
  	  Form1.Zprava('Zadal jste przdn jmno',1);
      pokracuj := False;
    end;
  	val(kus_str, kus_int, code);
	  if (code <> 0) or (kus_int < 1) then begin
    // Kontrola zda pocet kusu je spravne nastaven
  	  Form1.Zprava('Zadal jste neplatn poet kus',1);
      pokracuj := False;
    end;
    if pokracuj and (kus_int > 9999) then begin
    // Kontrola zda cas je spravne nastaven
  	  Form1.Zprava('Zadal jste pli vysok poet kus. Maximln hodnota je 9999 s. ',1);
      pokracuj := False;
    end;
		if pokracuj then begin
    	// kontrola zda jmeno se jiz neopakuje
      Zalozka := Form1.Table2.GetBookmark;
		 	if Form1.Table2.Locate('JMENO', jmeno, [loPartialKey]) then begin
	 	   	pokracuj := False;
		    Form1.Zprava('Zadal jste existujc jmno',1);
   		end;
      // A zde se cely vysledek ulozi
			if pokracuj then begin
				Form1.Table2.Last;
        posledni := Form1.Table2.Fields[0].AsInteger;
  			Form1.Table2.Append;
				Form1.Table2.Fields[0].AsInteger := posledni + 1;
				Form1.Table2.Fields[1].AsString := jmeno;
				Form1.Table2.Fields[2].AsInteger := kus_int;
			  Form1.Table2.Post;
	 		end;
	    // Zde se po hledani ukazatel vety nastavi zpatky na zalozku a ta se smaze
			Form1.Table2.GotoBookmark(Zalozka);
 			Form1.Table2.FreeBookmark(Zalozka);
		end;
  end;
// Zde zjistime zda je databazka prazdna pokud ano vypnem tlacitka
	if Form1.Table2.IsEmpty then begin
    Zmenit_jme.Enabled := False;
  	Zmenit_kus.Enabled := False;
    Smazat.Enabled := False;
  end
  else begin
    Zmenit_jme.Enabled := True;
   	Zmenit_kus.Enabled := True;
    Smazat.Enabled := True;
  end;
end;

procedure TVyrobkyForm.Zmenit_jmeClick(Sender: TObject);
// Tato procedura zmeni jmeno vyrobku
var
	Zalozka  : TBookmark;
  jmeno : string;
  pokracuj : boolean;
begin
	pokracuj := True;
	jmeno	:= Form1.Table2.Fields[1].AsString;
  if Form1.Vlozit('Zmte jmno vrobku : ',jmeno) then begin
  // pokud by nechtel zmenit jmeno InputQuery da False a cyklus konci
	  if (jmeno = '') then begin
    // Kontrola zda jmeno neni prazdne
  	  Form1.Zprava('Zadal jste przdn jmno, bude ponechno pvodn',1);
      pokracuj := False;
    end;
		if pokracuj then begin
    	// kontrola zda jmeno se jiz neopakuje
      Zalozka := Form1.Table2.GetBookmark;
      // zde se spusti vyhledavani
		 	if Form1.Table2.Locate('JMENO', jmeno, [loPartialKey]) then begin
	 	   	pokracuj := False;
		    Form1.Zprava('Zadal jste ji existujc jmno, bude ponechn pvodn',1);
   		end;
      // A zde se cely vysledek ulozi
			if pokracuj then begin
  			Form1.Table2.Edit;
				Form1.Table2.Fields[1].AsString := jmeno;
			  Form1.Table2.Post;
	 		end;
	    // Zde po hledani se ukazatel vety nastavi na zalozku a ta se smaze
			Form1.Table2.GotoBookmark(Zalozka);
 			Form1.Table2.FreeBookmark(Zalozka);
		end;
  end;
end;

procedure TVyrobkyForm.Zmenit_kusClick(Sender: TObject);
// Tato procedura zmeni pocet kusu vyrobku
var
  kus_str : string;
  pokracuj : boolean;
  kus_int, code : integer;
begin
	pokracuj := True;
	kus_str	:= IntToStr(Form1.Table2.Fields[2].AsInteger);
  if Form1.Vlozit('Zadejte nov poet kus vrobku : ',kus_str) then begin
	  // pokud by nechtel zmenit jmeno InputQuery da False a cyklus konci
  	val(kus_str, kus_int, code);
	  if (code <> 0)  or (kus_int < 1) then begin
    // Kontrola zda pocet kusu je spravne nastaven
  	  Form1.Zprava('Zadal jste neplatn poet kus',1);
      pokracuj := False;
    end;
    if pokracuj and (kus_int > 9999) then begin
    // Kontrola zda cas je spravne nastaven
  	  Form1.Zprava('Zadal jste pli vysok poet kus. Maximln hodnota je 9999 s. ',1);
      pokracuj := False;
    end;
		if pokracuj then begin
 			Form1.Table2.Edit;
			Form1.Table2.Fields[2].AsInteger := kus_int;
		  Form1.Table2.Post;
		end;
  end;
end;

procedure TVyrobkyForm.SmazatClick(Sender: TObject);
	// Tato procedura smaze stroj
var
	Zalozka  : TBookmark;
  kod : integer;
  pokracuj : boolean;
begin
	pokracuj := True;
	kod	:= Form1.Table2.Fields[0].AsInteger;
  // kontrola zda neini nejaka operace  pro tento vyrobek
  Zalozka := Form1.Table3.GetBookmark;
  // zde se spusti vyhledavani
	if Form1.Table3.Locate('IDV', kod, [loPartialKey]) then begin
   	pokracuj := False;
    Form1.Zprava('Tento vyrobek obsahuje jet njak operace',1);
	end;
  // A zde se naposledy zepta zda to myslis vazne
	if pokracuj and Form1.Zprava('Chcete vrobek ' + Form1.Table2.Fields[1].AsString + ' opravdu smazat ?',2) then begin
		Form1.Table2.Delete;
	end;
  // Zde po hledani se ukazatel vety nastavi na zalozku a ta se smaze
	Form1.Table3.GotoBookmark(Zalozka);
	Form1.Table3.FreeBookmark(Zalozka);
// Zde zjistime zda je databazka prazdna pokud ano vypnem tlacitka
	if Form1.Table2.IsEmpty then begin
    Zmenit_jme.Enabled := False;
  	Zmenit_kus.Enabled := False;
    Smazat.Enabled := False;
  end
  else begin
    Zmenit_jme.Enabled := True;
   	Zmenit_kus.Enabled := True;
    Smazat.Enabled := True;
  end;
end;

procedure TVyrobkyForm.KonecClick(Sender: TObject);
begin
	Close;
end;

procedure TVyrobkyForm.FormCreate(Sender: TObject);
begin
// Zde zjistime zda je databazka prazdna pokud ano vypnem tlacitka
	if Form1.Table2.IsEmpty then begin
    Zmenit_jme.Enabled := False;
  	Zmenit_kus.Enabled := False;
    Smazat.Enabled := False;
  end
  else begin
    Zmenit_jme.Enabled := True;
   	Zmenit_kus.Enabled := True;
    Smazat.Enabled := True;
  end;
end;

end.
