unit Zaloha;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, DB, DBGrids;

type
  TZalohaForm = class(TForm)
    DBGrid1: TDBGrid;
    Ulozit: TButton;
    Smazat: TButton;
    Konec: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    procedure UlozitClick(Sender: TObject);
    procedure SmazatClick(Sender: TObject);
    procedure KonecClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure DBGrid1KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure DBGrid1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  public
  	hodnota_zmacknuti : boolean
    { Public declarations }
  end;

var
  ZalohaForm: TZalohaForm;

implementation

uses hlavni;

{$R *.DFM}

procedure TZalohaForm.UlozitClick(Sender: TObject);
//Zde se ulozi puvodni zadani
var
		Zalozka  : TBookmark;
		kod : integer;
		adresar : String;
    hod : boolean;
begin
  Zalozka := Form1.Table5.GetBookmark;
 	Form1.Table5.Last;
	kod := Form1.Table5.Fields[1].AsInteger + 1;
  adresar := Form1.Cesta + '\ZADANI_' + IntToStr(kod);
  // vytvori adresar napriklad zadani_1
  if not(CreateDir(adresar)) then begin;
	  SetCurrentDir(adresar);
	 	// zde se smazou soubory *.dbf do hlavniho adresare
	  DeleteFile('mashiny.dbf');
    DeleteFile('operace.dbf');
    DeleteFile('vyrobky.dbf');
	  // zmeni adresar zpet
	  SetCurrentDir(Form1.Cesta);
	end;
  // Vratise zpatky do hlavniho adresare
  SetCurrentdir(Form1.Cesta);
 	// zde se nakopiruji soubory *.dbf do hlavniho adresare
  hod := true;
  Form1.Table1.Active := False;
  Form1.Table2.Active := False;
  Form1.Table3.Active := False;
  CopyFile('mashiny.dbf', PChar(adresar + '\mashiny.dbf'), hod);
	CopyFile('vyrobky.dbf', PChar(adresar + '\vyrobky.dbf'),hod);
  CopyFile('operace.dbf', PChar(adresar + '\operace.dbf'),hod);
  Form1.Table1.Active := True;
  Form1.Table2.Active := True;
  Form1.Table3.Active := True;
  // Zde po hledani se ukazatel vety nastavi na zalozku a ta se smaze
	Form1.Table5.GotoBookmark(Zalozka);
	Form1.Table5.FreeBookmark(Zalozka);
  // a nakonec se pridaji do adresar.dbf
	Form1.Table5.Append;
	Form1.Table5.Fields[0].AsString := Edit1.Text;
  Form1.Table5.Fields[1].AsInteger := kod;
	Form1.Table5.Post;
  // jako posledni vymaze Edit1.Text a vypne tlacitko Ulozit
	Edit1.Text := '';
	Ulozit.Enabled := False;
  // zkontroluje se Tlacitko Smazat
  if Form1.Table5.IsEmpty then Smazat.Enabled := False
  else Smazat.Enabled := True;
end;

procedure TZalohaForm.SmazatClick(Sender: TObject);
var kod : integer;
		adresar : string;
begin
  // A zde se naposledy zepta zda to myslis vazne
	if Form1.Zprava('Chcete zalohu ' + Form1.Table5.Fields[0].AsString + ' opravdu smazat ?',2) then begin
		kod := Form1.Table5.Fields[1].AsInteger;
	  adresar := Form1.Cesta + '\ZADANI_' + IntToStr(kod);
	  // zmeni adresar napriklad zadani_1
	  if not(SetCurrentDir(adresar)) then begin
	    Form1.Zprava('Nkdo se vrtal v adresi, ve kterm je umstn tento program a podailo se mu smazat adres s va zlohou, cel zlohou bude smazna  !!', 1);
		  // a nakonec se smazou z adresar.dbf
		 	Form1.Table5.Delete;
		end
    else begin
		 	// zde se smazou soubory *.dbf do hlavniho adresare
		  DeleteFile('mashiny.dbf');
	    DeleteFile('operace.dbf');
	    DeleteFile('vyrobky.dbf');
		  // zmeni adresar zpet
		  SetCurrentDir(Form1.Cesta);
		  // smaze adresar napriklad zadani_1
		  if not(RemoveDir(adresar))then
      	Form1.Zprava('Nepodailo se smazat adres ' + adresar + '. Bude te ho muset smazat sm !!!', 1);
		  // a nakonec se smazou z adresar.dbf
		 	Form1.Table5.Delete;
  	  if Form1.Table5.IsEmpty then Smazat.Enabled := False
			else Smazat.Enabled := True;
    end;
  end;
end;

procedure TZalohaForm.KonecClick(Sender: TObject);
begin
	Close;
end;

procedure TZalohaForm.FormCreate(Sender: TObject);
begin
	// toto ma zabranovat zbytecnym machinacim okolo mackani klavesy enter
	hodnota_zmacknuti := true;
	// Zde nastavi Tlacitka Ulozit, Smazat podle obsahu databaze
	Ulozit.Enabled := False;
  if Form1.Table5.IsEmpty then Smazat.Enabled := False
  else Smazat.Enabled := True;
  // zmeni adresar zpet
end;

procedure TZalohaForm.Edit1Change(Sender: TObject);
begin
	// Zde zamazuje ulozeni prazdne hodnoty
	if Edit1.Text ='' then Ulozit.Enabled := False
  else Ulozit.Enabled := True;
end;

procedure TZalohaForm.DBGrid1KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var jmeno, adresar : string;
		kod : word;
    hod, projit : boolean;
begin
	jmeno := Form1.Table5.Fields[0].AsString;
  projit := True;
	if hodnota_zmacknuti and (Key = 13) and InputQuery('Jmno zlohy, po pepsn : ','',jmeno) Then begin
  	kod := Form1.Table5.Fields[1].AsInteger;
	  adresar := Form1.Cesta + '\ZADANI_' + IntToStr(kod);
	  // zmeni adresar napriklad na zadani_1
	 	if not(SetCurrentDir(adresar)) then begin;
	  	// kdyz zjisti smazany adresar smaze zaznam v databazi
      Form1.Zprava('Zloha ' + Form1.Table5.Fields[0].AsString + ' nen kompletn. Bude smazna !!!', 1);
		  Form1.Table5.Delete;
      projit := False;
		end;
    if projit and (jmeno = '') then begin
  		Form1.Zprava('Nelze zadat przdn jmno !!!', 1);
      projit := False;
	  end;
    if projit then begin
		  // Vratise zpatky do hlavniho adresare
		  SetCurrentdir(Form1.Cesta);
		 	// zde se nakopiruji soubory *.dbf do hlavniho adresare
		  DeleteFile(adresar + '\mashiny.dbf');
	    DeleteFile(adresar + '\operace.dbf');
	    DeleteFile(adresar + '\vyrobky.dbf');
		  Form1.Table1.Active := False;
		  Form1.Table2.Active := False;
		  Form1.Table3.Active := False;
		  CopyFile('mashiny.dbf', PChar(adresar + '\mashiny.dbf'), hod);
			CopyFile('vyrobky.dbf', PChar(adresar + '\vyrobky.dbf'),hod);
		  CopyFile('operace.dbf', PChar(adresar + '\operace.dbf'),hod);
		  Form1.Table1.Active := True;
		  Form1.Table2.Active := True;
		  Form1.Table3.Active := True;
		  // a nakonec se pridaji do adresar.dbf
			Form1.Table5.Edit;
			Form1.Table5.Fields[0].AsString := jmeno;
			Form1.Table5.Post;
    end;
		// zkontroluje se Tlacitko Smazat
		if Form1.Table5.IsEmpty then Smazat.Enabled := False
		else Smazat.Enabled := True;
  end;
 	hodnota_zmacknuti := false;
end;

procedure TZalohaForm.DBGrid1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
	if key = 13 then hodnota_zmacknuti := true;
end;

end.
