unit prubeh;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
 	PPozice = ^TPozice;
 	TPozice = record
   	operace : integer;
  end;

 	PBod = ^TBod;
 	TBod = record
   	nejvet : integer;
    soucas : integer;
  end;

 	PDvojice = ^TDvojice;
 	TDvojice = record
   	ido1 : integer;
    ido2 : integer;
		pros : integer;
  end;

  PTrojice = ^TTrojice;
 	TTrojice = record
   	ido : integer;
    idv : integer;
    cas : integer;
    misto : integer;
		Cas_zac : integer;
 		Cas_kon : integer;
    Cas_cel : integer;
    Cas_pro : integer;
  end;

	PSeznam = ^TSeznam;
  TSeznam = TList;

  TPrubehForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Stavove_tlacitko: TButton;
    Stav_graf: TCheckBox;
    Label9: TLabel;
		procedure Zacatek;
    procedure ukonceni;
    function Kontrola_Casu : boolean;
		function Kon_ko : boolean ;
    procedure Graf_ukaz(cas_nov, kroky : integer);
    procedure Prohod_Nahodne(var Seznam : TSeznam);
	  procedure Prohod(var Seznam : TSeznam; Prvni,Druhy : integer);
    procedure Najdi_Okoli_Tabu(var Seznam : TSeznam; typ : integer);
    procedure Najdi_Okoli_Simul(var Seznam : TSeznam; typ : integer);
		procedure Kopie (var Seznam1, Seznam2 : TSeznam);
		function Kontrola_Tabu(var Seznam : TList; typ : integer) : boolean;
 		function Kontrola_Simul(var Seznam : TList; typ : integer) : boolean;
		function Konec (Seznam : Tseznam) : boolean;
    function Cas(var Seznam : TSeznam; typ  : integer) : integer;
 		procedure Tabu;
    procedure Simul;
		procedure Vsechny;
    procedure Lokal;
    procedure FormDestroy(Sender: TObject);
    procedure Stavove_tlacitkoClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Stav_grafClick(Sender: TObject);
		procedure Zapis_do_souboru;
  private
    { Private declarations }
  public
		  Vysledek : TSeznam;
  	  Novy : TSeznam;
      Stary : TSeznam;
      Zaklad : TSeznam;
    	Zakaz :  TSeznam;
      Kontrolni : TSeznam;
			kroky, typ, n, teplota, cas_zad, cas_trv : integer;
			// pro vypocet
			cas_vys : integer;
		  cas_vypoctu, cas_zacatek : string;
 			Metoda, Met_lok, Soused, Zapis_prubehu, Co_zapisovat : integer;
      Beh, zauzleni, preruseni, CheckBox1, CheckBox2, CheckBox3 : boolean;
		// promene por graf
			Graf : Tseznam;
	  	Pomer : Integer;
			Bod_min_poc : TBod;
    	dosavad_kroky : integer;
      Stav_prubehu : array [1..25] of integer;
    { Public declarations }
  end;

var
  PrubehForm: TPrubehForm;

implementation

uses Vypocet, hlavni;

{$R *.DFM}

//vraci True pokud je cas koncit, ulozi do Label7 jak dlouho to zatim trva
function TPrubehForm.Kontrola_Casu : boolean;
var konec : string;
		kon_int1, zac_int1, kon_int2, zac_int2, kon_int3, zac_int3: integer;
		kon_str1, kon_str2, kon_str3 : string;
    kon_rea, zac_rea : real;
begin
	konec := TimeToStr(Time);
  // Nejdriv pretransformujeme retezec do integeru
	if konec[2] = ':' then begin
  	kon_int1 := StrToInt(konec[1]);
  	kon_int2 := StrToInt(konec[3])*10 + StrToInt(konec[4]);
 	 	kon_int3 := StrToInt(konec[6])*10 + StrToInt(konec[7]);
  end
  else begin
	  kon_int1 := StrToInt(konec[1])*10 + StrToInt(konec[2]);
		kon_int2 := StrToInt(konec[4])*10 + StrToInt(konec[5]);
  	kon_int3 := StrToInt(konec[7])*10 + StrToInt(konec[8]);
  end;
  if cas_zacatek[2] = ':' then begin
	  zac_int1 := StrToInt(cas_zacatek[1]);
  	zac_int2 := StrToInt(cas_zacatek[3])*10 + StrToInt(cas_zacatek[4]);
 		zac_int3 := StrToInt(cas_zacatek[6])*10 + StrToInt(cas_zacatek[7]);
  end
  else begin
		zac_int1 := StrToInt(cas_zacatek[1])*10 + StrToInt(cas_zacatek[2]);
 		zac_int2 := StrToInt(cas_zacatek[4])*10 + StrToInt(cas_zacatek[5]);
 		zac_int3 := StrToInt(cas_zacatek[7])*10 + StrToInt(cas_zacatek[8]);
  end;
  // zjistime zda vypocet nahodou nebezi dele ja 24 hod
	if kon_int1 < zac_int1 then begin
  	Label7.Caption := ' dle ne 24 hodin';
		kontrola_Casu := True;
  end
  else begin
		// ulozime soucasnou velikost doby behu vypoctu do Label7
   	kon_int3 := kon_int3 - zac_int3;
    if kon_int3 < 0 then begin
	   	zac_int2 := zac_int2 + 1;
			kon_int3 := 60 + kon_int3;
	  end;
	  kon_int2 := kon_int2 - zac_int2;
	  if kon_int2 < 0 then begin
	  	zac_int1 := zac_int1 + 1;
			kon_int2 := 60 + kon_int2;
	  end;
	  kon_int1 := kon_int1 - zac_int1;
		if kon_int1/10 < 1 then kon_str1 := '0' + IntToStr(kon_int1)
	  else kon_str1 := IntToStr(kon_int1);
		if kon_int2/10 < 1 then kon_str2 := '0' + IntToStr(kon_int2)
	  else kon_str2 := IntToStr(kon_int2);
	  if kon_int3/10 < 1 then kon_str3 := '0' + IntToStr(kon_int3)
	  else kon_str3 := IntToStr(kon_int3);
	  Label7.Caption := kon_str1 + ':' + kon_str2 + ':' + kon_str3;
    // a zjistime zda se jiz nema koncit
	  // Nejdriv pretransformujeme retezec do integeru
		if konec[2] = ':' then begin
	  	kon_int1 := StrToInt(konec[1]);
	  	kon_int2 := StrToInt(konec[3])*10 + StrToInt(konec[4]);
	 	 	kon_int3 := StrToInt(konec[6])*10 + StrToInt(konec[7]);
	  end
	  else begin
		  kon_int1 := StrToInt(konec[1])*10 + StrToInt(konec[2]);
			kon_int2 := StrToInt(konec[4])*10 + StrToInt(konec[5]);
	  	kon_int3 := StrToInt(konec[7])*10 + StrToInt(konec[8]);
	  end;
	  if cas_zacatek[2] = ':' then begin
		  zac_int1 := StrToInt(cas_zacatek[1]);
	  	zac_int2 := StrToInt(cas_zacatek[3])*10 + StrToInt(cas_zacatek[4]);
	 		zac_int3 := StrToInt(cas_zacatek[6])*10 + StrToInt(cas_zacatek[7]);
	  end
	  else begin
			zac_int1 := StrToInt(cas_zacatek[1])*10 + StrToInt(cas_zacatek[2]);
 			zac_int2 := StrToInt(cas_zacatek[4])*10 + StrToInt(cas_zacatek[5]);
	 		zac_int3 := StrToInt(cas_zacatek[7])*10 + StrToInt(cas_zacatek[8]);
	  end;
    // pak pricteme zadanou dobu hledani
		zac_int2 := zac_int2 + cas_trv;
		zac_int1 := zac_int1 + zac_int2 div 60;
	 	zac_int2 := zac_int2 mod 60;
		kon_rea := kon_int1 + kon_int2/100 + kon_int3/10000;
		zac_rea := zac_int1 + zac_int2/100 + zac_int3/10000;
	  if zac_rea > kon_rea  then
			kontrola_Casu := False
		else kontrola_Casu := True;
  end;
end;

{Vraci True pokud je cas a podminky pro skonceni vypoctu}
function TPrubehForm.Kon_ko : boolean;
var konec : boolean;
begin
	konec := False;
	// Zde kontroluje zda jsme jiz nedosahli hledany cas
	if (((cas_vys <= cas_zad) and (cas_vys <> -1)) and CheckBox1) then konec := True;
  // Zde kontroluje pocet kroku
	if not(konec) and ((kroky = StrToInt(Label6.Caption)) and CheckBox3) then konec := True;
  // Zde se kontroluje zda se nezmacklo ukonceni
  if not(konec) and preruseni then konec := True;
  // Zde se kontroluje zda nedoslo k zauzleni
  if not(konec) and zauzleni then begin
  	konec := True;
    if (Co_zapisovat = 1) and (zapis_prubehu = 1)then
    else
			Form1.Zprava('Dolo k zauzlen. Vpoet bude ukonen !!',1);
  end;
  // Zde kontroluje zda jsme jiz neprekrocili danou dobu vypoctu
	if not(konec) and (kontrola_casu and CheckBox2) then konec := True;
	if konec then begin
  	Kon_ko := True;
  end
  else Kon_ko := False ;
end;

// Kontrola pro Tabu Search
function	TPrubehForm.Kontrola_Tabu(var Seznam : TList; typ : integer) : boolean;
var Varianta, Masina1, Masina2 : TSeznam;
		Trojice : PTrojice;
    Dvojice : PDvojice;
    Pozice : PPozice;
    stav, stav2 : boolean;
    i, j, k : integer;
begin
	stav := false;
	stav2 := true;
	{Kontrola na TABU SEARCH}
	for i := 1 to Zakaz.Count do begin
    Varianta := zakaz.Items[i - 1];
	  stav := true;
    for j := 1 to Varianta.Count do begin
      Masina1 := Varianta.Items[j - 1];
      Masina2 := Seznam.Items[j - 1];
      for k := 1 to Masina1.Count do begin
				Pozice := Masina1.Items[k - 1];
				Trojice := Masina2.Items[k - 1];
				if Trojice^.Ido <> Pozice^.Operace then begin
        	stav := false;
          break;
        end;
      end;
			if not(stav) then break;
    end;
    if stav then break;
  end;
  if not(stav) then begin
	  {Kontrola pripustnost posloupnosti operaci}
    stav2 := true;
  	for i := 1 to Kontrolni.Count do begin
      Masina1 := Kontrolni.Items[i - 1];
      Masina2 := Seznam.Items[i - 1];
	    for j := 1 to Masina1.Count do begin
        Dvojice := Masina1.Items[j -1];
		    for k := 1 to Masina2.Count do begin
          Trojice := Masina2.Items[k - 1];
	        if Dvojice^.Ido1 = Trojice^.Ido then break;
					if (Dvojice^.Ido2 = Trojice^.Ido) then begin
          	stav2 := false;
            break;
					end;
		    end;
        if not(stav2) then break;
	    end;
      if not(stav2) then break;
  	end;
  end;
  if not(stav) and stav2 then Kontrola_Tabu := True
	else Kontrola_Tabu := False;
end;

// zkontroluje zda se operace na stroji nepredbihaji
function	TPrubehForm.Kontrola_Simul(var Seznam : TList; typ:integer):boolean;
var Masina1, Masina2 : TSeznam;
		Trojice1 : PTrojice;
    Dvojice : PDvojice;
    stav2 : boolean;
    i, j, k : integer;
begin
  stav2 := true;
 	for i := 1 to Kontrolni.Count do begin
    Masina1 := Kontrolni.Items[i - 1];
    Masina2 := Seznam.Items[i - 1];
	  for j := 1 to Masina1.Count do begin
      Dvojice := Masina1.Items[j -1];
		  for k := 1 to Masina2.Count do begin
        Trojice1 := Masina2.Items[k - 1];
	      if Dvojice^.Ido1 = Trojice1^.Ido then break;
				if (Dvojice^.Ido2 = Trojice1^.Ido) then begin
        	stav2 := false;
          break;
				end;
      end;
    	if not(stav2) then break;
	  end;
    if not(stav2) then break;
	end;
  if stav2 then Kontrola_Simul := True
	else Kontrola_Simul := False;
end;

// prohodi nahodne operace v seznamu
procedure TPrubehForm.Prohod_Nahodne(var Seznam : TSeznam);
var Pomocny : PTrojice;
		i, j : integer;
begin
	Randomize;
  if soused = 0 then begin
		i := random(Seznam.Count);
	  repeat
	    j := random(Seznam.Count);
		until i <> j;
		Pomocny := Seznam.Items[i];
	  Seznam.Items[i] := Seznam.Items[j];
	  Seznam.Items[j] := Pomocny;
  end
  else begin
		i := random(Seznam.Count - 1) + 1;
    Pomocny := Seznam.Items[0];
    for j := 2 to i do
      Seznam.Items[j - 2] := Seznam.Items[j - 1];
    Seznam.Items[i - 1] := pomocny;
  end;
end;

// prohodi dve operace v seznamu
procedure TPrubehForm.Prohod(var Seznam : TSeznam; Prvni,Druhy : integer);
var Pomocny : PTrojice;
begin
	Pomocny := Seznam.Items[Prvni - 1];
  Seznam.Items[Prvni - 1] := Seznam.Items[Druhy - 1];
  Seznam.Items[Druhy - 1] := Pomocny;
end;

// zkopiruje jeden seznam do druheho
procedure TPrubehForm.Kopie (var Seznam1, Seznam2 : TSeznam);
var	Masina1, Masina2 : TSeznam;
		Trojice1, Trojice2 : PTrojice;
    i, j : integer;
begin
	{Zde se vymaze puvodni seznam}
	if seznam1 <> nil then begin
		for i := (seznam1.Count - 1) downto 0 do begin
  	  for j := Tseznam(seznam1.Items[i]).Count - 1 downto 0 do
	       Dispose (TSeznam(seznam1.Items[i]).Items[j]);
	    TSeznam (seznam1.Items[i]).Free;
	  end;
  	Seznam1.Free;
  end;
	{Zde konci mazani seznamu}
	Seznam1 := TList.Create;
	for i := 1 to Seznam2.Count do begin
  	Masina1 := Seznam2.Items[i - 1];
    Masina2 := TList.Create;
    for j := 1 to Masina1.Count do begin
      New(Trojice2);
      Trojice1 := Masina1.Items[j - 1];
      Trojice2^.Ido := Trojice1^.Ido;
      Trojice2^.Idv := Trojice1^.Idv;
      Trojice2^.Cas := Trojice1^.Cas;
      Trojice2^.Misto := Trojice1^.Misto;
      Trojice2^.Cas_cel := Trojice1^.Cas_cel;
      Trojice2^.Cas_pro := Trojice1^.Cas_pro;
      Trojice2^.Cas_zac := Trojice1^.Cas_zac;
      Trojice2^.Cas_kon := Trojice1^.Cas_kon;
			Masina2.Add(Trojice2);
	  end;
    Seznam1.Add(Masina2);
  end;
end;

// najde okoli pro Tabu search
procedure TPrubehForm.Najdi_Okoli_Tabu(var Seznam : TSeznam; typ : integer);
var Masina : TSeznam;
		Masina1, Masina2, Pridej : TSeznam;
		Trojice : PTrojice;
		Pomocny : PTrojice;
    Pozice : PPozice;
    cas_nov, cas_star, i, j, k : integer;
begin
  cas_star := -1;
  for i := 1 to Seznam.Count do begin
  	Masina := Seznam.Items[i - 1];
    // vybereme podle sousedstvi
    if Soused = 0 then begin
	  	for j := 1 to Masina.Count - 1  do begin
  	  	for k := 1 to Masina.Count - j do begin
    			Pomocny := Masina.Items[j - 1];
					Masina.Items[j - 1] := Masina.Items[j + k - 1];
	        Masina.Items[j + k - 1] := Pomocny;
	        if Kontrola_Tabu(Seznam, typ) then begin
	    	   	Label6.Caption := IntToStr(StrToInt(Label6.Caption) + 1 );
		        cas_nov := cas(Seznam,typ);
            if (Zapis_prubehu = 1) and ((StrToInt(Label6.Caption) mod 500 = 0) or (Label6.Caption = '1')) and
            	(StrToInt(Label6.Caption) div 500 < 21)then
            	Stav_prubehu[StrToInt(Label6.Caption) div 500 + 1] := cas_vys;
            if Stav_graf.Checked then graf_ukaz(cas_nov,StrToInt(Label6.Caption));
            if (cas_star = -1) or ((cas_nov <> - 1) and (cas_star > cas_nov)) then begin
	          	Kopie(Novy,Seznam);
	            cas_star := cas_nov;
	          end;
          end;
	        Pomocny := Masina.Items[j - 1];
					Masina.Items[j - 1] := Masina.Items[j + k - 1];
	        Masina.Items[j + k - 1] := Pomocny;
					if Kon_ko then exit;
	      end;
        if Kon_ko then exit;
      end;
    end
    else begin
	    // vezme se postupne kazda
			for j := 2 to Masina.Count  do begin
      	// a prohodise se vsemi vyssimi
        // prohodime operace
		  	Pomocny := Masina.Items[0];
				for k := 2 to j do
			   	Masina.Items[k - 2] := Masina.Items[k - 1];
				Masina.Items[j - 1] := pomocny;
        if Kontrola_Tabu(Seznam, typ) then begin
	       	// zapise se pocet kroku
			   	Label6.Caption := IntToStr(StrToInt(Label6.Caption) + 1 );
       	  cas_nov := cas(Seznam,typ);
          if (Zapis_prubehu = 1) and ((StrToInt(Label6.Caption) mod 500 = 0) or (Label6.Caption = '1')) and
          	(StrToInt(Label6.Caption) div 500 < 21)then
           	Stav_prubehu[StrToInt(Label6.Caption) div 500 + 1] := cas_vys;
					if Stav_graf.Checked then graf_ukaz(cas_nov,StrToInt(Label6.Caption));
	     		if (cas_star = -1) or
  	       	((cas_nov <> -1) and (cas_star > cas_nov)) then begin
    	     	Kopie(Novy, Seznam);
      	    cas_star := cas_nov;
          end;
        end;
    	  // prohodime operace zpatky
		    Pomocny := Masina.Items[j - 1];
		    for k := j downto 2 do
	  	  	Masina.Items[k - 1] := Masina.Items[k - 2];
		    Masina.Items[0] := pomocny;
	      if Kon_ko then exit;
      end;
		end;
   	if Kon_ko then exit;
  end;
  // zjisti se zda pamet neni naplnena tzn. pocet kroku nepresahl 100
	if Zakaz.Count >= 100 then begin
    //Vynulovani Zakaz
    for j := Tseznam(Zakaz.Items[0]).Count - 1 downto 0 do begin
	   	for k := TSeznam(Tseznam(Zakaz.Items[0]).Items[j]).Count - 1 downto 0 do
	      Dispose (TSeznam(TSeznam(Zakaz.Items[0]).Items[j]).Items[k]);
	    TSeznam(TSeznam(Zakaz.Items[0]).Items[j]).Free;
    end;
	  TSeznam(Zakaz.Items[0]).Free;
    Zakaz.Delete(0);
  end;
 	//Zde se prida nova polozka do seznamu zakazanych kroku
  Pridej := TList.Create;
  for i := 1 to Novy.Count do begin
  	Masina1 := Novy.Items[i - 1];
    Masina2 := TList.Create;
		for j := 1 to Masina1.Count do begin
    	Trojice := Masina1.Items[j - 1];
     	New(Pozice);
      Pozice^.Operace := Trojice^.Ido;
      Masina2.Add(pozice);
    end;
    Pridej.Add(Masina2);
  end;
  Zakaz.Add(Pridej);
end;

// najde okoli pro simulovane zihani
procedure TPrubehForm.Najdi_Okoli_Simul(var Seznam : TSeznam; typ : integer);
var Masina : TSeznam;
    Pomocny : PTrojice;
    cas_novy : integer;
begin
  repeat
   	Label6.Caption := IntToStr(StrToInt(Label6.Caption) + 1 );
    Kopie(Novy, Seznam);
 	  Masina := Novy.Items[random(Novy.Count)];
 		if Masina.Count = 2 then begin
			Pomocny := Masina.Items[0];
		  Masina.Items[0] := Masina.Items[1];
		  Masina.Items[1] := Pomocny;
		end;
 	  if Masina.Count > 2 then begin
       Prohod_Nahodne(Masina);
    end;
    cas_novy := cas(Novy,typ);
    if (Zapis_prubehu = 1) and ((StrToInt(Label6.Caption) mod 500 = 0) or (Label6.Caption = '1')) and
	   	(StrToInt(Label6.Caption) div 500 < 21)then
     	Stav_prubehu[StrToInt(Label6.Caption) div 500 + 1] := cas_vys;
  	if Stav_graf.Checked then graf_ukaz(cas_novy,StrToInt(Label6.Caption));
  until Kontrola_Simul(Novy, typ);
end;

// zjisti jestli vsechny operace jsou jiz zadany
function TPrubehForm.Konec(Seznam: Tseznam) : boolean;{vraci True pokud CASY jsou hotove}
var i : integer;
		Pomocny : PDvojice;
    stav : boolean;
begin
	stav := True;
  for i := 1 to Seznam.Count do begin
    Pomocny := Seznam.Items[i - 1];
    if Pomocny^.Ido2 <>0 then begin
    	stav := False;
      break;
    end
  end;
  if stav then konec := true
  else konec := false;
end;

// Spocita cas varianty
function TPrubehForm.Cas(var Seznam : TSeznam; typ : integer) : integer;
var Masina, KMasina, Casy : TSeznam;
		Operace, KOperace : PTrojice;
    Dvojice, KDvojice : PDvojice;
    i, j, k, Dodatek, nejvetsi : integer;
    stav, zapis : boolean;
begin
  {Vynuluj polozku cas_cel a cas_pro u seznamu}
  for i := 1 to Seznam.Count do begin
  	Masina := Seznam.Items[i-1];
    for j := 1 to Masina.Count do begin
			Operace := Masina.Items[j-1];
      Operace^.Cas_Cel := 0;
			Operace^.Cas_Pro := 0;
    end;
  end;
	Casy := TList.Create;
  {Zde se naplni casy}
	for i := 1 to Seznam.Count do begin
  	Masina := Seznam.Items[i - 1];
    New(Dvojice);
  // zde se do jednotlivych polozek vlozi do casu 0 a do poctu operaci plny pocet
    Dvojice^.Ido1 := 0;
    Dvojice^.Ido2 := Masina.Count;
		Dvojice^.Pros := 0;
    Casy.Add(Dvojice);
	end;
  stav := true;
  zapis := False;
	dodatek := 0;
	{Zde probiha vlastni vypocet}
  while stav do begin
// opakuje se dokud se po celem tahu nepolozi alespon jedna operace
  	stav := false;
    for i := 1 to Seznam.Count do begin
// projedou se vsechny stroje, a zkusi se zapsat operace do rady
      Masina := Seznam.Items[i - 1];
      Dvojice := Casy.Items[i - 1];
// zde se kontroluje zda na tomto stroji jiz nebyli vlozeny vsachny operace
// pokud ano jde se na dalsi stroj
      if Dvojice^.Ido2 <> 0 then begin
// zde se vybere zatim nevlozena operace
	      Operace := Masina.Items[Masina.Count - Dvojice^.Ido2];
// pokud je to operace na prvnim miste vyrobku, automaticky se zapise
  	    if Operace^.Misto = 1 then begin
    	  	zapis := true;
// v promene dodatek je ulozena velikost casu pro pripad pokud dojde k navaznosti
// na jiny stroj a vyrobek musi cekat
	        Dodatek := Dvojice^.Ido1;
  	    end;
    	  if not(zapis) then
// Zde se postupne projedou stroje a nalezne se predchozi operace
// pro zjisteni zda operac ebude cekat nebo ne.
      		for j := 1 to Seznam.Count do begin
      	    KDvojice := Casy.Items[j - 1];
  	        KMasina := Seznam.Items[j - 1];
            dodatek := KDvojice.Ido1;
// zde se postupne projedou vsechny jiz vlozene operace na jednotlivych masinach
    	      for k := (KMasina.Count - KDvojice^.Ido2) downto 1 do begin
     	       	KOperace := KMasina.Items[k - 1];
// pokud dojde k nalezeni operave n astejnem vyrobku o jedno nizsim poradim
// dojde k okamzitemu vyskoceni z cyklu a v dodatku se momentalne nachazi
// cas ukonceni posledni operace tohoto vyrobku
              if (Operace^.Idv = KOperace^.Idv) and
              	(Operace^.Misto = KOperace^.Misto + 1) Then begin
    	          zapis := True;
                break;
           		end;
// zde se postupne z celkoveho casu jiz umistenych operaci odecitaji operace
// na jinych vyrobcich
              dodatek := dodatek - KOperace^.Cas;
          	end;
          	if zapis then break;
        	end;
// a zde dojde k zapsani operace do fronty zvyseni casu a snizeni poctu
// operaci, ktere mohou byt vlozeny do rady
    		if zapis then begin
// zde se rozhodne zda se cas pripocita k aktualnimu casu stroje nebo
// zda operace musi cekat na operaci predeslou
        	if Dvojice^.Ido1 > dodatek then begin
          // operace nemusi cekat
          	Dvojice^.Ido1 := Dvojice^.Ido1 + Operace^.Cas;
            Operace^.Cas_zac := Dvojice^.Ido1 - Operace^.Cas;
						Operace^.Cas_kon := Dvojice^.Ido1;
          end
          else begin
          // operace musi cekat
						Dvojice^.Pros := dodatek - Dvojice^.Ido1 + Dvojice^.Pros;
          	Dvojice^.Ido1 := dodatek + Operace^.Cas;
            Operace^.Cas_zac := Dvojice^.Ido1 - Operace^.Cas;
						Operace^.Cas_kon := Dvojice^.Ido1;
          end;
					Dvojice^.Ido2 := Dvojice^.Ido2 - 1;
	       	Stav := True;
      	 	zapis := False;
        end;
      end;
    end;
  end;
  nejvetsi := 0;
// a jestli jsme vypotrebovali vsechny operace muzeme ulozit
  if konec(Casy) then begin
	  for i := 1 to Casy.Count do begin
  		Dvojice := Casy.Items[i - 1];
      Masina := Seznam.Items[i - 1];
      Operace := Masina.Items[0];
      Operace^.Cas_cel := Dvojice^.Ido1;
			Operace^.Cas_pro := Dvojice^.pros;
// zde se urci co se pocita zda prostoje nebo celkove casy
      if typ = 1 then begin
				// a najde se bud nejvetsi cas
			  if nejvetsi < Dvojice^.Ido1 then nejvetsi := Dvojice^.Ido1;
        end
      // nebo soucet vsech prostoju
		  else nejvetsi := nejvetsi + Dvojice^.Pros;
		end;
    Cas := nejvetsi
  end
	else Cas := -1;
  // zde jeste zastavime proces pro obnoveni obrazovky
  Application.ProcessMessages;
  //Vynulovani Casy
  for i := Casy.Count - 1 downto 0 do
    Dispose (Casy.Items[i]);
	Casy.Free;
end;

procedure TPrubehForm.Vsechny;
var ukaz_m, cel_m  : integer;

procedure Rotuj_masiny; forward;

procedure Rotuj_operace(var ukaz_o, cel_o : integer;Masina : TSeznam);
var Operace, Prepsat : PTrojice;
		pokracuj : boolean;
    i, j, cas_nov : integer;
begin
	ukaz_o := ukaz_o + 1;
  New(Operace);
 	Masina.Add(Operace);
	for i := 1 to cel_o do begin
// zde se na toto misto v rozvrhu umistuji postupne vsechny operace
  	pokracuj := true;
  	for j := ukaz_o - 1 downto 1 do
			if PTrojice(TSeznam(Stary.Items[ukaz_m - 1]).Items[i - 1]).Ido =
      	PTrojice(Masina.Items[j - 1]).Ido then begin
// Zde se zjistuje zda IDO nektere operace pred touto operaci neni stejne
      	pokracuj := false;
        break;
			end;
  	if pokracuj	then begin
	  	Prepsat := TSeznam(Stary.Items[ukaz_m - 1]).Items[i - 1];
      Operace^.Ido := Prepsat^.Ido;
      Operace^.Idv := Prepsat^.Idv;
      Operace^.Cas := Prepsat^.Cas;
      Operace^.Misto := Prepsat^.Misto;
      Operace^.Cas_cel := Prepsat^.Cas_cel;
      Operace^.Cas_pro := Prepsat^.Cas_pro;
      // zde se prida nova operace do masiny a pokud to neni posledni operace
      // Znovu se pusti rotace operaci
	 		if ukaz_o <> cel_o then begin
     		Rotuj_operace(ukaz_o, cel_o,Masina);
	      if Kon_ko then exit;
        end
			else begin
      // pokud je to posledni operace zjisti se zda to neni na posledni masine
   		// pokud to neni posledni masina pusti se znovu rotace
		  	if ukaz_m <> cel_m then begin
        	Rotuj_masiny;
          if Kon_ko then exit;
      	end
      	else begin
        	// zvetsime pocet kroku o jeden
 					Label6.Caption := IntToStr(StrToInt(Label6.Caption) + 1 );
          cas_nov := Cas(Novy,typ);
					// zapiseme do rubehu
          if (Zapis_prubehu = 1) and ((StrToInt(Label6.Caption) mod 500 = 0) or (Label6.Caption = '1')) and
          	(StrToInt(Label6.Caption) div 500 < 21)then
           	Stav_prubehu[StrToInt(Label6.Caption) div 500 + 1] := cas_vys;
					// Zobrazime graf
          if Stav_graf.Checked then graf_ukaz(cas_nov, StrToInt(Label6.Caption));
					// pokud je to posledni masina dojde k vypoctu casu a kontrole zda je posledni
	       	if  ((cas_vys = -1) and (cas_nov > 0)) or
          	((cas_nov <> -1 )and (cas_nov < cas_vys)) then begin
            // Toto probehne pokud nalezneme kepsi cas
    				cas_vys := cas_nov;
            // zmenime hodnotu v Label5
            Label5.Caption := IntToStr(cas_vys);
  	       	Kopie(Vysledek, Novy);
          end;
					// Kontrola zda se jiz nedosahlo ukoncujicich parametru
					if Kon_ko then exit;
  			end;
      end;
    end;
  end;
  Dispose(Operace);
	Masina.Delete(ukaz_o - 1);
  // ukazatel operaci se posune zpet
  ukaz_o := ukaz_o - 1;
end;

// rotuje jednotlive masiny
procedure Rotuj_masiny;
var ukaz_o, cel_o : integer;
		Masina : TSeznam;
begin
  //ukazatel na masinu se posune dopredu
	ukaz_m := ukaz_m + 1;
  // ukazatal na operaci vynuluje
  ukaz_o := 0;
  Masina := TList.Create;
	Novy.Add(Masina);
	// pocet operaci na jednotlivem stroji
  cel_o := TSeznam(Stary.Items[ukaz_m - 1]).Count;
  Rotuj_operace(ukaz_o, cel_o,Masina);
 	// Kontrola zda se jiz nedosahlo ukoncujicich parametru
	if Kon_ko then exit;
	// po skonceni rotace se masina smaze
 	Masina.Free;
 	Novy.Delete(ukaz_m - 1);
  // ukazatel na masinu se posune zpatky
  ukaz_m := ukaz_m - 1;
end;

begin
  // nahraje se nazev metody
	Label9.Caption := 'Hledn metodou prochzen vech prvk';
  // ulozi se zacatek vypoctu
	cas_zacatek := TimeToStr(Time);
  // vytvorise vysledek
	Kopie(Vysledek, Stary);
	Novy := TList.Create;
  // vytvori se prvni vysledek
	cas_vys := Cas(Vysledek,typ);
  if cas_vys <> -1 then Label5.Caption := IntToStr(cas_vys)
  else Label5.Caption := ' Nenalezen ';
	// zde je ukazatel na masinu
  ukaz_m := 0;
  // pocet masin
  cel_m := Stary.Count;
  // sposti se vypocet
	Rotuj_masiny;
end;

procedure TPrubehForm.Tabu;
var cas_nov : integer;
begin
 	Label9.Caption := 'Hledn metodou Tabu search';
	cas_zacatek := TimeToStr(Time);
	Kopie(Vysledek, Stary);
  cas_vys := cas(Vysledek,typ);
  if cas_vys <> -1 then Label5.Caption := IntToStr(cas_vys)
  else Label5.Caption := ' Nenalezen ';
  Kopie(Novy, Stary);
	repeat
  	Najdi_Okoli_Tabu(Stary,typ);
    cas_nov := cas(Novy,typ);
    if ((cas_vys = -1) and (cas_nov > 0)) or
    	((cas_nov <> - 1) and (cas_nov < cas_vys)) then begin
			Kopie(Vysledek, Novy);
      cas_vys := cas_nov;
      // zmenime hodnotu v Label5
	    Label5.Caption := IntToStr(cas_vys);
    end;
		Kopie(Stary, Novy);
    if Kon_ko then exit;
	until false;
end;

procedure TPrubehForm.Simul;
var delta, i, cas_nov, cas_star: integer;
		teplota1 : real;
    cas_zacatek : string;
begin
	Label9.Caption := 'Hledn metodou simulovanho hn';
	cas_zacatek := TimeToStr(Time);
	Kopie(Vysledek, Stary);
	cas_star := cas(Stary,typ);
  cas_vys := cas(Vysledek,typ);
  if cas_vys <> -1 then Label5.Caption := IntToStr(cas_vys)
  else Label5.Caption := ' Nenalezen ';
  Kopie(Novy, Stary);
  teplota1 := teplota;
	repeat
	  for i := 1 to n do begin
  		Najdi_Okoli_Simul(Stary,typ);
      cas_nov := cas(Novy,typ);
      if	cas_nov <> -1 then begin
				delta := cas_nov - cas_star;
		    if delta < 0 then begin
		    	Kopie(Stary,Novy);
          cas_star := cas_nov;
			    if ((cas_vys = -1) and (cas_nov > 0)) or
          	((cas_nov <> -1) and (cas_nov < cas_vys)) then begin
						Kopie(Vysledek, Novy);
            cas_vys := cas_nov;
            // zmenime hodnotu v Label5
            Label5.Caption := IntToStr(cas_vys);
          end;
			  end
		    else
		    	if exp(-delta/teplota) > random(1000)/1000 then begin
						cas_star := cas_nov;
		      	Kopie(Stary,Novy);
          end;
      end;
      if Kon_ko then exit;
	  end;
	  teplota1 := teplota1*0.95;
	  n := n + 50;
    if Kon_ko then exit;
	until false;
end;

// zde se provadi metoda lokaniho minima
procedure TPrubehForm.Lokal;
var Masina : TSeznam;
		Pomocny : PTrojice;
		cas_nov, i, j, k : integer;
    cas_zacatek : string;
    zauzleni_lokal : boolean;
begin
	PrubehForm.Caption := ' Prbh vpotu metodou loklnho minima';
  // zapiseme aktualni cas
	cas_zacatek := TimeToStr(Time);
	Kopie(Vysledek, Stary);
  // nahrajeme hodnotu casu prvniho reseni
  cas_vys := Cas(Vysledek,typ);
  if cas_vys <> -1 then Label5.Caption := IntToStr(cas_vys)
  else Label5.Caption := ' Nenalezen ';
  Kopie(Novy, Stary);
	// a zacneme pocitat podle toho jakou metodu lokalni minima jsme vybrali
  if Met_Lok = 0 then begin
 		Label9.Caption := 'Hledn metodou loklnho minima nejstrmjho spdu';
  	// toto je metoda nestrmejsiho spadu
		repeat
    	// zde se postupne prochazeji jednotilive sousedstvi
      // projde se kazdy stroj
      zauzleni_lokal := true;
 	 		for i := 1 to Novy.Count do begin
  			Masina := Novy.Items[i - 1];
        // a zacnou se prohazovat jednotlive operace
        // zde se vyresi sousedstvi
        if soused = 0 then begin
	        // vezme se postupne kazda
	  			for j := 1 to Masina.Count - 1  do begin
  	      	// a prohodise se vsemi vyssimi
	  	 	 		for k := 1 to Masina.Count - j do begin
	          	// zapise se pocet kroku
					   	Label6.Caption := IntToStr(StrToInt(Label6.Caption) + 1 );
							Pomocny := Masina.Items[j - 1];
							Masina.Items[j - 1] := Masina.Items[j + k - 1];
	     	    	Masina.Items[j + k - 1] := Pomocny;
	     	    	cas_nov := cas(Novy,typ);
              // zapiseme prubeh
	            if (Zapis_prubehu = 1) and ((StrToInt(Label6.Caption) mod 500 = 0) or (Label6.Caption = '1')) and
  		         	(StrToInt(Label6.Caption) div 500 < 21)then
      		     	Stav_prubehu[StrToInt(Label6.Caption) div 500 + 1] := cas_vys;
          		if Stav_graf.Checked then graf_ukaz(cas_nov,StrToInt(Label6.Caption));
	   	     		if ((cas_vys = -1) and (cas_nov > 0)) or
	            	((cas_nov <> -1) and (cas_vys > cas_nov)) then begin
	            	Kopie(Vysledek,Novy);
	              cas_vys := cas_nov;
	              zauzleni_lokal := false;
		            // zmenime hodnotu v Label5
	  	          Label5.Caption := IntToStr(cas_vys);
	            end;
	     	    	Pomocny := Masina.Items[j - 1];
							Masina.Items[j - 1] := Masina.Items[j + k - 1];
	     	    	Masina.Items[j + k - 1] := Pomocny;
	            if Kon_ko then exit;
	     	  	end;
  	        if Kon_ko then exit;
	    		end;
       		if Kon_ko then exit;
        end
        else begin
	        // vezme se postupne kazda
	  			for j := 2 to Masina.Count  do begin
  	      	// a prohodise se vsemi vyssimi
            // pro ladeni PTrojice(TSeznam(Novy.Items[0]).Items[0])^.Ido
          	// zapise se pocet kroku
				   	Label6.Caption := IntToStr(StrToInt(Label6.Caption) + 1 );
            // prohodime operace
				    Pomocny := Masina.Items[0];
				    for k := 2 to j do
			   	  	Masina.Items[k - 2] := Masina.Items[k - 1];
				    Masina.Items[j - 1] := pomocny;
     	    	cas_nov := cas(Novy,typ);
            // zapiseme prubeh
            if (Zapis_prubehu = 1) and ((StrToInt(Label6.Caption) mod 500 = 0) or (Label6.Caption = '1')) and
 		         	(StrToInt(Label6.Caption) div 500 < 21)then
     		     	Stav_prubehu[StrToInt(Label6.Caption) div 500 + 1] := cas_vys;
						if Stav_graf.Checked then graf_ukaz(cas_nov,StrToInt(Label6.Caption));
   	     		if ((cas_vys = -1) and (cas_nov > 0)) or
            	((cas_nov <> -1) and (cas_vys > cas_nov)) then begin
	           	Kopie(Vysledek,Novy);
	            cas_vys := cas_nov;
	            zauzleni_lokal := false;
		          // zmenime hodnotu v Label5
	            Label5.Caption := IntToStr(cas_vys);
	          end;
            // prohodime operace zpatky
				    Pomocny := Masina.Items[j - 1];
				    for k := j downto 2 do
			   	  	Masina.Items[k - 1] := Masina.Items[k - 2];
				    Masina.Items[0] := pomocny;
	          if Kon_ko then exit;
	      	end;
      		if Kon_ko then exit;
       	end;
  		end;
      Kopie(Novy,Vysledek);
      zauzleni := zauzleni_lokal;
      if Kon_ko then exit;
		until false
  end
  else begin
   	Label9.Caption := 'Hledn metodou loklnho minima nhodnho spdu';
  	// toto je metoda nahodneho spadu
		repeat
	 		Najdi_Okoli_Simul(Stary,typ);
  	  cas_nov := Cas(Novy,typ);
	    if ((cas_nov <> -1) and (cas_nov < cas_vys)) or
      	((cas_vys = -1) and (cas_nov > 0))then begin
				Kopie(Vysledek, Novy);
        Kopie(Stary, Novy);
        cas_vys := cas_nov;
        // zmenime hodnotu v Label5
        Label5.Caption := IntToStr(cas_vys);
	    end;
      if Kon_ko then exit;
		until Kon_ko
  end;
end;

procedure TPrubehForm.FormDestroy(Sender: TObject);
var i, j: integer;
begin
  //Vynulujeme seznamy
	ukonceni;

   //Vynulovani Zaklad
  for i := Zaklad.Count - 1 downto 0 do begin
    for j := Tseznam(Zaklad.Items[i]).Count - 1 downto 0 do
       Dispose (TSeznam(Zaklad.Items[i]).Items[j]);
    TSeznam (Zaklad.Items[i]).Free;
  end;
  Zaklad.Free;
end;

//toto je procedura ktera se pousti pri zahajeni kazdeho vypoctu
procedure TPrubehForm.zacatek;
var i : integer;
begin
	//vytvorime nove seznamy
  Graf := TList.Create;
	Vysledek := TList.Create;
  Novy := TList.Create;
  Stary := TList.Create;
  Zakaz := TList.Create;
  Kopie(Stary,Zaklad);
	// smazeme pole prubehu
  for i := 1 to 20 do
	  Stav_prubehu[i] := 0;
	// a minuly bod automaticky nastavime na podle toho
  //vynulujeme hodnoty
  cas_vys := cas(Stary,typ);
	Label5.Caption := '0';
 	Label6.Caption := '0';
	Bod_min_poc.Nejvet := -1;
	Bod_min_poc.Soucas := -1;
 	dosavad_kroky := 0;
  zauzleni := false;
end;

//toto je procedura ktera se pousti pri ukonceni jednoho vypoctu
procedure TPrubehForm.Ukonceni;
var
  i, j, k: integer;
begin
   // vynulujeme seznamy a smazeme
  //Vynulovani Graf
  for i := Graf.Count - 1 downto 0 do
    Dispose (Graf.Items[i]);
	Graf.Free;

  //Vynulovani Vysledek
  for i := Vysledek.Count - 1 downto 0 do begin
    for j := Tseznam(Vysledek.Items[i]).Count - 1 downto 0 do
       Dispose (TSeznam(Vysledek.Items[i]).Items[j]);
    TSeznam (Vysledek.Items[i]).Free;
  end;
	Vysledek.Free;

     //Vynulovani Stary
  for i := Stary.Count - 1 downto 0 do begin
    for j := Tseznam(Stary.Items[i]).Count - 1 downto 0 do
       Dispose (TSeznam(Stary.Items[i]).Items[j]);
    TSeznam (Stary.Items[i]).Free;
  end;
  Stary.Free;


  //Vynulovani Novy
  for i := Novy.Count - 1 downto 0 do begin
    for j := Tseznam(Novy.Items[i]).Count - 1 downto 0 do
       Dispose (TSeznam(Novy.Items[i]).Items[j]);
    TSeznam (Novy.Items[i]).Free;
  end;
	Novy.Free;

  //Vynulovani Zakaz
  for i := Zakaz.Count - 1 downto 0 do begin
    for j := Tseznam(Zakaz.Items[i]).Count - 1 downto 0 do begin
    	for k := TSeznam(Tseznam(Zakaz.Items[i]).Items[j]).Count - 1 downto 0 do
	      Dispose (TSeznam(TSeznam(Zakaz.Items[i]).Items[j]).Items[k]);
      TSeznam(TSeznam(Zakaz.Items[i]).Items[j]).Free;
    end;
    TSeznam(Zakaz.Items[i]).Free;
  end;
  Zakaz.Free;
end;

procedure TPrubehForm.Stavove_tlacitkoClick(Sender: TObject);
begin
	if not(beh) then begin
    // zapnu beh programu
    beh := true;
		// prepiseme talcitko
		Stavove_tlacitko.Caption := 'Zastavit vpoet';
		// vytvorime seznamy
		zacatek;
    // zjistime zda nemame projizdet vsechny varianty
    if (Co_zapisovat = 1) and (zapis_prubehu = 1)then begin
    	// Projedem vsechny metody
			// metoda lokalniho minima  nejstrmejsi Vetsi sousede
      Metoda := 1;
      Met_lok := 0;
      Soused := 0;
      Lokal;
      Zapis_do_souboru;
      ukonceni;zacatek;
			// metoda lokalniho minima  nejstrmejsi Shift sousede
      Soused := 1;
      Lokal;
      Zapis_do_souboru;
      ukonceni;zacatek;
			// metoda lokalniho minima  nahodny Vetsi sousede
   		zacatek;
      Metoda := 1;
      Met_lok := 1;
      Soused := 0;
      Lokal;
      Zapis_do_souboru;
      ukonceni;zacatek;
			// metoda lokalniho minima  nahodny Shift sousede
      Soused := 1;
      Lokal;
      Zapis_do_souboru;
      ukonceni;zacatek;
			// metoda simul zihani Vetsi sousede
      Metoda := 2;
      Soused := 0;
      Simul;
      Zapis_do_souboru;
      ukonceni;zacatek;
			// metoda simul zihani Shift sousede
      Soused := 1;
      Simul;
      Zapis_do_souboru;
      ukonceni;zacatek;
			// metoda Tabu Vetsi sousede
      Metoda := 3;
      Soused := 0;
      Tabu;
      Zapis_do_souboru;
      ukonceni;zacatek;
			// metoda Tabu Shift sousede
      Soused := 1;
      Tabu;
      Zapis_do_souboru;
 		  Close;
    end
    else begin
		  // a spustime vypocet
		  if Metoda = 0 then Vsechny;
		  if Metoda = 1 then Lokal;
		  if Metoda = 2 then Simul;
		  if Metoda = 3 then Tabu;
	    if (Zapis_prubehu = 1) then Zapis_do_souboru;
		  Close;
		end;
	end
	else
  	if Form1.Zprava('Opravdu chcete peruit vpoet ??',2) then begin
    	// Vypneme tlacitko
    	Stavove_tlacitko.Enabled := false;
			preruseni := true;
		end;
end;

procedure TPrubehForm.FormCreate(Sender: TObject);
var Soubor : TextFile;
begin
	// vymazeme puvodni soubor
  AssignFile(Soubor,'Prubeh.txt');
  Rewrite(Soubor);
  CloseFile(Soubor);
	// nastavit promenou beh ktera signalizuje zda vypocet bezi nebo ne
  beh := false;
	preruseni := false;
  Stavove_tlacitko.Enabled := true;
end;

// tato funkce postupne vykresluje graf
procedure TPrubehForm.Graf_ukaz(cas_nov, kroky : integer);
const
	mezera: Integer = 20; // mezeramezi jednotlivimi primkami
	Vys_graf: Integer = 200; // vyska grafu v bodech
	Sir_graf: Integer = 500; // sirka grafu v bodech
	Poc_krok: Integer = 100; // pocet kroku mezi jednotlivimi primkami
	Zac_x: Integer = 20; // zacatek grafu
	Zac_y: Integer = 30; // zacatek grafu
var Bod : PBod;
		Bod_min : TBod;
		pomocna : integer;
    i :integer;

// tato procedurka zmeni meritko podle potreby
procedure Nastav_graf(cas_akt : integer);
var Bod_pom : PBod;  // pomocne body pro postupne vykreslovani
		Bod_min_pom : TBod;
    j, kroky_kres : integer;
begin
	// zmenime barvu pozadi
  Canvas.Brush.Color := clBtnFace;
	// Zmenime barvu
  Canvas.Pen.Color := clBlack;
	// smaze se obrazek
	Canvas.Rectangle(Zac_x,Zac_y - 10,Sir_graf + Zac_x,Vys_graf + Zac_y);
	// nastavovat kurzor nemusime pred kreslenim se nastavi sam
  // zmeni pomer
	pomer := (((cas_akt div 1000) + 1 ) * 1000) div Vys_graf;
  // a zjisti od kud to ma pocitat
  //if graf.count = 0 then
		kroky_kres := dosavad_kroky;
	//  else
	//  	kroky_kres := kroky;
  // zmeni se popisky
  // osa x
	Canvas.TextOut(Zac_x, Zac_y + vys_graf, '        ');
  Canvas.TextOut(Zac_x, Zac_y + vys_graf, IntToStr(kroky_kres));
	Canvas.TextOut(Zac_x + (sir_graf div 5)* 1, Zac_y + vys_graf + 3, '      ');
  Canvas.TextOut(Zac_x + (sir_graf div 5)* 1, Zac_y + vys_graf + 3, IntToStr(kroky_kres + (((sir_graf div 5) * 1) div mezera) * poc_krok ));
  Canvas.TextOut(Zac_x + (sir_graf div 5)* 2, Zac_y + vys_graf + 3, IntToStr(kroky_kres + (((sir_graf div 5) * 2) div mezera) * poc_krok ));
  Canvas.TextOut(Zac_x + (sir_graf div 5)* 3, Zac_y + vys_graf + 3, IntToStr(kroky_kres + (((sir_graf div 5) * 3) div mezera) * poc_krok ));
  Canvas.TextOut(Zac_x + (sir_graf div 5)* 4, Zac_y + vys_graf + 3, IntToStr(kroky_kres + (((sir_graf div 5) * 4) div mezera) * poc_krok ));
  Canvas.TextOut(Zac_x + (sir_graf div 5)* 5, Zac_y + vys_graf + 3, IntToStr(kroky_kres + (((sir_graf div 5) * 5) div mezera) * poc_krok ));
 	// osa y
  Canvas.TextOut(Zac_x + sir_graf + 10, Zac_y + vys_graf  - (vys_graf div 4 * 1) - 5, '         ');
  Canvas.TextOut(Zac_x + sir_graf + 10, Zac_y + vys_graf  - (vys_graf div 4 * 2) - 5, '         ');
  Canvas.TextOut(Zac_x + sir_graf + 10, Zac_y + vys_graf  - (vys_graf div 4 * 3) - 5, '         ');
  Canvas.TextOut(Zac_x + sir_graf + 10, Zac_y + vys_graf  - (vys_graf div 4 * 4) - 5, '         ');
  Canvas.TextOut(Zac_x + sir_graf + 10, Zac_y - 20 - 5, 'Nenalezeno');
  Canvas.TextOut(Zac_x + sir_graf + 10, Zac_y + vys_graf  - (vys_graf div 4 * 1) - 5, IntToStr(pomer * (vys_graf div 4 * 1)));
  Canvas.TextOut(Zac_x + sir_graf + 10, Zac_y + vys_graf  - (vys_graf div 4 * 2) - 5, IntToStr(pomer * (vys_graf div 4 * 2)));
  Canvas.TextOut(Zac_x + sir_graf + 10, Zac_y + vys_graf  - (vys_graf div 4 * 3) - 5, IntToStr(pomer * (vys_graf div 4 * 3)));
  Canvas.TextOut(Zac_x + sir_graf + 10, Zac_y + vys_graf  - (vys_graf div 4 * 4) - 5, IntToStr(pomer * (vys_graf div 4 * 4)));
  Canvas.TextOut(Zac_x + sir_graf + 10, Zac_y - 20 - 5, 'Nenalezeno');
	// popiseme osy
 	Canvas.TextOut(Zac_x + sir_graf + 50, Zac_y + vys_graf div 2 - 30, '');
 	Canvas.TextOut(Zac_x + sir_graf + 50, Zac_y + vys_graf div 2 - 15, 'a');
 	Canvas.TextOut(Zac_x + sir_graf + 50, Zac_y + vys_graf div 2 + 0, 's');
  Canvas.TextOut(Zac_x + sir_graf div 2 - 50, Zac_y + vys_graf + 20, 'Poet krok --->');
  // vypiseme legendu
  // div sveta Bod_min^.Nejvet,Bod_min^.Soucas
	Canvas.Pen.Color := clRed;
  Canvas.MoveTo(Zac_x, Zac_y + vys_graf + 45);
  Canvas.LineTo(Zac_x + 20, Zac_y + vys_graf + 45);
  Canvas.TextOut(Zac_x + 25, Zac_y + vys_graf + 40, 'Nejlep hodnota');
  Canvas.Pen.Color := clNavy;
  Canvas.MoveTo(Zac_x + (sir_graf div 3)* 1, Zac_y + vys_graf + 45);
  Canvas.LineTo(Zac_x + (sir_graf div 3)* 1 + 20, Zac_y + vys_graf + 45);
  Canvas.TextOut(Zac_x + 25 + (sir_graf div 3)* 1, Zac_y + vys_graf + 40, 'Souasn hodnota');
  Canvas.Pen.Color := clOlive	;
  Canvas.MoveTo(Zac_x + (sir_graf div 3)* 2, Zac_y + vys_graf + 45);
  Canvas.LineTo(Zac_x + (sir_graf div 3)* 2 + 20, Zac_y + vys_graf + 45);
  Canvas.TextOut(Zac_x + 25 + (sir_graf div 3)* 2, Zac_y + vys_graf + 40, 'Hledan hodnota');
  // nakreslime caru hledaneho casu
  Canvas.MoveTo(Zac_x, Zac_y + vys_graf - cas_zad div pomer);
  Canvas.LineTo(Zac_x + sir_graf, Zac_y + vys_graf - cas_zad div pomer);
  // a prekresli cely graf
	for j := 1 to Graf.Count - 1 do begin
    Bod_pom := Graf.Items[j - 1];
    if j = 1 then begin
    	Bod_min_pom.Nejvet := Bod_min_poc.Nejvet;
			Bod_min_pom.Soucas := Bod_min_poc.Soucas;
    end
    else begin
     	Bod_min_pom.Nejvet := PBod(Graf.Items[j - 2])^.Nejvet;
			Bod_min_pom.Soucas := PBod(Graf.Items[j - 2])^.Soucas;
    end;
    // a nakreslime caru nejlepsi hodnoty casu
    // pokud je hodnota -1 tzn cas nebyl nalezen, nastavime y = 20 tzn na horni okraj
    if Bod_min_pom.Nejvet = - 1  then
     	pomocna := Zac_y - 8
 		else
     	// pokud ne prevedeme ho na bod v meritku
     	pomocna := Vys_graf - (Bod_min_pom.Nejvet div pomer) + zac_y;
 		// pak presuneme kurzor
    Canvas.MoveTo(j*mezera + zac_x - mezera, pomocna);
    // ToTez pro nakresleni cary
    if Bod_pom^.Nejvet = -1  then
     	pomocna := Zac_y - 8
		else
     	pomocna := Vys_graf - (Bod_pom^.Nejvet div pomer) + zac_y;
		// Zmenime barvu
	  Canvas.Pen.Color := clRed;
    // a nakreslime caru
    Canvas.LineTo((j + 1)*mezera + zac_x - mezera, pomocna);
    // a nakreslime caru soucane hodnoty casu
    // pokud je hodnota -1 tzn cas nebyl nalezen, nastavime y = 20 tzn na horni okraj
    if Bod_min_pom.Soucas = -1  then
     	pomocna := Zac_y - 8
 		else
    	// pokud ne prevedeme ho na bod v meritku
     	pomocna := Vys_graf - (Bod_min_pom.Soucas div pomer) + zac_y;
		// pak presuneme kurzor
    Canvas.MoveTo(j*mezera + zac_x - mezera, pomocna);
    // ToTez pro nakresleni cary
    if Bod_pom^.Soucas = -1  then
     	pomocna := Zac_y - 8
		else
    	pomocna := Vys_graf - (Bod_pom^.Soucas div pomer) + zac_y;
		// Zmenime barvu
	  Canvas.Pen.Color := clNavy;
    Canvas.LineTo((j + 1)*mezera + zac_x - mezera, pomocna);
  end;
end;

begin
	// pokud je toto prvni zaznam prihodi se automaticky
	if Graf.Count = 0 then begin
    Bod_min.Nejvet := Bod_min_poc.Nejvet;
    Bod_min.Soucas := Bod_min_poc.Soucas;
		if Bod_min.soucas = -1 then
			if Bod_min.Nejvet = -1 then Nastav_Graf(4000)
      else Nastav_Graf(Bod_min.Nejvet)
    else Nastav_Graf(Bod_min.Soucas);
  	New(Bod);
    if Bod_min.Nejvet <> -1 then Bod^.Nejvet := Bod_min.Nejvet
    else Bod^.Nejvet := cas_nov;
		Bod^.Soucas := cas_nov;
    Graf.Add(Bod);
		// a pripravi se graf
  end;
  // nahrajeme aktualni bod
  Bod := Graf.Items[Graf.Count - 1];
  // a posledni zobrazeny bod pokud existuje
  if Graf.Count <> 1 then begin
		Bod_min.Nejvet := PBod(Graf.Items[Graf.Count - 2])^.Nejvet;
 		Bod_min.Soucas := PBod(Graf.Items[Graf.Count - 2])^.Soucas;
  end
  else begin
  	Bod_min.Nejvet := Bod_min_poc.Nejvet;
    Bod_min.Soucas := Bod_min_poc.Soucas;
  end;
 	// a zkontrolujeme zda novy vysledek neni vetsi
  if ((cas_nov < Bod^.Soucas) and (cas_nov <> -1)) or (Bod^.Soucas = -1) then Bod^.Soucas := cas_nov;
  if ((cas_nov < Bod^.Nejvet) and (cas_nov <> -1)) or (Bod^.Nejvet = -1) then Bod^.Nejvet := cas_nov;
  // nyni budeme zjistovat je to prvek 100 nebo ne tzn zda se bude vypisovat nebo ne
	if (Kroky mod Poc_krok) = 0 then begin
    // a nyni to vykreslime
    // zjistime zda pomer odpovida
    if (Bod^.Soucas div pomer) > Vys_graf then begin
    	// pokud neodpovida musime prekreslit cely graf
     	Nastav_Graf(Bod^.Soucas);
    end;
    // a nakreslime caru nejlepsi hodnoty casu
    // pokud je hodnota -1 tzn cas nebyl nalezen, nastavime y = 20 tzn na horni okraj
    if Bod_min.Nejvet = -1  then
     	pomocna := Zac_y - 8
 		else
     	// pokud ne prevedeme ho na bod v meritku
     	pomocna := Vys_graf - (Bod_min.Nejvet div pomer) + zac_y;
 		// pak presuneme kurzor
    Canvas.MoveTo(Graf.Count*mezera + zac_x - mezera, pomocna);
    // ToTez pro nakresleni cary
    if Bod^.Nejvet = -1  then
     	pomocna := Zac_y - 8
		else
     	pomocna := Vys_graf - (Bod^.Nejvet div pomer) + zac_y;
		// Zmenime barvu
	  Canvas.Pen.Color := clRed;
    // a nakreslime caru
    Canvas.LineTo((Graf.Count + 1)*mezera + zac_x - mezera, pomocna);
    // a nakreslime caru soucane hodnoty casu
    // pokud je hodnota -1 tzn cas nebyl nalezen, nastavime y = 20 tzn na horni okraj
    if Bod_min.Soucas = -1  then
     	pomocna := Zac_y - 8
 		else
    	// pokud ne prevedeme ho na bod v meritku
     	pomocna := Vys_graf - (Bod_min.Soucas div pomer) + zac_y;
		// pak presuneme kurzor
    Canvas.MoveTo(Graf.Count*mezera + zac_x - mezera, pomocna);
    // ToTez pro nakresleni cary
    if Bod^.Soucas = -1  then
     	pomocna := Zac_y - 8
		else
    	pomocna := Vys_graf - (Bod^.Soucas div pomer) + zac_y;
		// Zmenime barvu
	  Canvas.Pen.Color := clNavy;
    Canvas.LineTo((Graf.Count + 1)*mezera + zac_x - mezera, pomocna);
    // prepiseme minuly bod
    Bod_min.Nejvet := Bod^.Nejvet;
    Bod_min.Soucas := Bod^.Soucas;
  	// vytvorime novou polozku TList
	 	New(Bod);
    // pridame dosud nejvetsi hodnotu
	  Bod^.Nejvet := PBod(Graf.Items[Graf.Count - 1]).Nejvet;
		//  nejhorsi hodnotu aby bylo v dalsim kole s cim zacit
    Bod^.Soucas := -1;
	  Graf.Add(Bod);
    // a pokud dosahneme kraje grafu cely ho smazeme a zacnem znova
    if (Graf.Count - 1)*mezera = sir_graf then begin
      Bod_min_poc.Nejvet := Bod_min.Nejvet;
      Bod_min_poc.Soucas := Bod_min.Soucas;
      dosavad_kroky := kroky;
      for i := Graf.Count - 1 downto 0 do
		    Dispose(Graf.Items[i]);
      Graf.Free;
      Graf := TList.Create
    end;
  end;
end;

procedure TPrubehForm.Stav_grafClick(Sender: TObject);
var i : integer;
begin
	if Stav_graf.Checked = True then begin
		// a minuly bod automaticky nastavime na podle toho
		Bod_min_poc.Nejvet := -1;
		Bod_min_poc.Soucas := -1;
	 	dosavad_kroky := StrToInt(Label6.Caption);
  end
  else
  	if beh then begin
  	  for i := Graf.Count - 1 downto 0 do
	    Dispose(Graf.Items[i]);
    	Graf.Free;
    	Graf := TList.Create;
	  end;
end;

procedure TPrubehForm.Zapis_do_souboru;
var Soubor : TextFile;
		i : integer;
begin
  AssignFile(Soubor,'Prubeh.txt');
  Append(Soubor);
  Writeln(Soubor);
  Writeln(Soubor);
  if Metoda = 0 then Write(Soubor, ' VSECHNY ');
  if (Metoda = 1) and (Met_lok = 0) then Write(Soubor, ' LOK_S ');
  if (Metoda = 1) and (Met_lok = 1) then Write(Soubor, ' LOK_N ');
  if Metoda = 2 then Write(Soubor, ' SIMUL ');
  if Metoda = 3 then Write(Soubor, ' TABU ');
  if Soused = 0 then Write(Soubor, ' V ');
  if Soused = 1 then Write(Soubor, ' S ');
  i := 1;
  repeat
	  Write(Soubor, Stav_prubehu[i]);
		Write(Soubor, ' ');
    i := i + 1;
  until (i = 21) or (Stav_prubehu[i] = 0);
  CloseFile(Soubor);
end;

end.
