unit zobrazeni;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type

	PPrvek = ^TPrvek;
 	TPrvek = record
   	cis : integer;
		x : integer;
    y : integer;
    typ : integer;
  end;

	TPrvek_pom = record
  	cis : integer;
    pole : array [1..6, 1..10] of integer;
    rot : integer;
  end;

  PDilek = ^TDilek;
 	TDilek = record
   	cis : integer;
		x : integer;
    y : integer;
    rot : integer;
  end;

	PPrvky = ^TPrvky;
  TPrvky = TList;

	TVysledky = class(TForm)
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Nacti_prvky;
		procedure Nacti_reseni;
		function Napln_prvek (cis, rot : integer): TPrvek_pom;
		procedure Vykresli(x,y,typ : integer; barva : TColor);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    Prvky : TPrvky;
    Reseni : TPrvky;
    { Public declarations }
  end;

var
  Vysledky: TVysledky;

implementation

{$R *.DFM}

procedure TVysledky.FormDestroy(Sender: TObject);
var i : integer;
begin
	//Vynulovani prvku
  for i := Prvky.Count - 1 downto 0 do
    Dispose (Prvky.Items[i]);
  Prvky.Free;
  //Vynulovani reseni
  for i := Reseni.Count - 1 downto 0 do
    Dispose (Reseni.Items[i]);
  Reseni.Free;
end;

procedure TVysledky.FormCreate(Sender: TObject);
begin
  //Zde se vytvori Prvky
  Prvky := TList.Create;
	//Zde se vytvori seznam reseni
  Reseni := TList.Create;
  Nacti_prvky;
end;

procedure TVysledky.Nacti_prvky;
var
	zdroj : TextFile;
	radek, cislo, cislo_pom, cislo_pred : string;
  i, stupen, x, y, typ : integer;
  Prvek : PPrvek;
  konec : boolean;
begin
  // jenom proto aby me to neotravovalo pri compilaci tak
  // inicializuji
  x := 0;
  y := 0;
  typ := 0;
  // A otevru soubor s prvky pro nahrani do pameti
	AssignFile(zdroj,'zdroj.txt');
	Reset(zdroj);
  cislo_pred := '1';
  // A NACTEM VSECHNY prvky
	Readln(Zdroj,radek);
	konec := false;
  i := 1;
  cislo := '';
	// zde nacteme prvni cislo
 	while not(radek[i] = ' ') do begin
    cislo := cislo + radek[i];
  	i := i + 1;
  end;
  while not(Eof(Zdroj)) or not(konec) do begin
    cislo_pred := cislo;
    // a najdeme vsechny prvky se stejnym cislem
    while (cislo = cislo_pred) and (not(Eof(Zdroj)) or not(konec))do begin
      stupen := 1;
      cislo_pom := '';
      // rozebereme reteyec na jednotliv8 cisla
			for i := 1 to Length(radek) do begin
				if radek[i] <> ' ' then cislo_pom := cislo_pom + radek[i];
			  if i = Length(radek) then begin
			    typ := StrToInt(cislo_pom);
			   	cislo_pom :='';
			  end;
				if (radek[i]=' ') and (stupen = 3) then begin
			    y := StrToInt(cislo_pom);
			   	cislo_pom :='';
				  stupen := 4;
			  end;
				if (radek[i]=' ') and (stupen = 2) then begin
			    x := StrToInt(cislo_pom);
			   	cislo_pom :='';
				  stupen := 3;
			  end;
				if (radek[i]=' ') and (stupen = 1) then begin
			   	cislo_pom := '';
			    stupen := 2;
			  end;
			end;
			// zde vytvorime novy prvek a vynululeme
			New(Prvek);
			// a ulozime do PRVEK
			Prvek^.cis := StrToInt(cislo_pred);
			Prvek^.x := x;
			Prvek^.y := y;
			Prvek^.typ := typ;
			// pak cele uloyime do PRVKY
			Prvky.Add(Prvek);
      // kontrola zda jsme na konci souboru (je potreba to projet jeste jednou
	    // kvuli poslednimu prvku
  	  if Eof(zdroj) then
	    	konec := true;
      // pokud to neni posledni radek nacte dalsi
		  if not(Eof(zdroj)) then begin
  	    i := 1;
			  cislo := '';
				Readln(zdroj,radek);
		   	while not(radek[i] = ' ') do begin
			    cislo := cislo + radek[i];
			   	i := i + 1;
		    end;
      end;
    end;
  end;
 	CloseFile(zdroj);
end;

procedure TVysledky.Nacti_reseni;
var
	zdroj : TextFile;
	radek, cislo, cislo_pom, cislo_pred : string;
  i, stupen, x, y, rot : integer;
  Dilek : PDilek;
  konec : boolean;
begin
  // nejdriv to cele smazu
  for i := Reseni.Count - 1 downto 0 do
  	Reseni.Delete(i);
  // jenom proto aby me to neotravovalo pri compilaci tak
  // inicializuji
  x := 0;
  y := 0;
  rot := 0;
  AssignFile(Zdroj,OpenDialog1.FileName);
	Reset(zdroj);
  cislo_pred := '1';
  // A NACTEM VSECHNY prvky
	Readln(Zdroj,radek);
	konec := false;
  i := 1;
  cislo := '';
	// zde nacteme prvni cislo
 	while not(radek[i] = ' ') do begin
    cislo := cislo + radek[i];
  	i := i + 1;
  end;
  while not(Eof(Zdroj)) or not(konec) do begin
    cislo_pred := cislo;
    // a najdeme vsechny prvky se stejnym cislem
    while (cislo = cislo_pred) and (not(Eof(Zdroj)) or not(konec))do begin
      stupen := 1;
      cislo_pom := '';
      // rozebereme reteyec na jednotliv8 cisla
			for i := 1 to Length(radek) do begin
				if radek[i] <> ' ' then cislo_pom := cislo_pom + radek[i];
			  if i = Length(radek) then begin
			    rot := StrToInt(cislo_pom);
			   	cislo_pom :='';
			  end;
				if (radek[i]=' ') and (stupen = 3) then begin
			    y := StrToInt(cislo_pom);
			   	cislo_pom :='';
				  stupen := 4;
			  end;
				if (radek[i]=' ') and (stupen = 2) then begin
			    x := StrToInt(cislo_pom);
			   	cislo_pom :='';
				  stupen := 3;
			  end;
				if (radek[i]=' ') and (stupen = 1) then begin
			   	cislo_pom := '';
			    stupen := 2;
			  end;
			end;
			// zde vytvorime novy prvek a vynululeme
			New(Dilek);
			// a ulozime do PRVEK
			Dilek^.cis := StrToInt(cislo_pred);
			Dilek^.x := x;
			Dilek^.y := y;
			Dilek^.rot := rot;
			// pak cele uloyime do PRVKY
			Reseni.Add(Dilek);
      // kontrola zda jsme na konci souboru (je potreba to projet jeste jednou
	    // kvuli poslednimu prvku
  	  if Eof(zdroj) then
	    	konec := true;
      // pokud to neni posledni radek nacte dalsi
		  if not(Eof(zdroj)) then begin
  	    i := 1;
			  cislo := '';
				Readln(zdroj,radek);
		   	while not(radek[i] = ' ') do begin
			    cislo := cislo + radek[i];
			   	i := i + 1;
		    end;
      end;
    end;
  end;
 	CloseFile(zdroj);
end;

function TVysledky.Napln_prvek (cis, rot : integer): TPrvek_pom;
var i, j : integer;
    prvek_pom, prvek_vys : TPrvek_pom;
begin
	// vynulujeme prvek a prvek_pom
  for i := 1 to 6 do
  	for j := 1 to 10 do
    	prvek_vys.pole[i,j] := 0;
  for i := 1 to 6 do
   	for j := 1 to 10 do
    	prvek_pom.pole[i,j] := 0;
 //najcteme vsechny prvky
  for i := 0 to Prvky.Count - 1 do
    if PPrvek(Prvky.Items[i]).cis = cis then begin
			Prvek_pom.cis := PPrvek(Prvky.Items[i])^.cis;
      Prvek_pom.pole[PPrvek(Prvky.Items[i])^.x, PPrvek(Prvky.Items[i])^.y] := PPrvek(Prvky.Items[i])^.typ;
	  end;
  prvek_vys.cis := prvek_pom.cis;
  prvek_vys.rot := rot;
  // pred otocenim zmenime u roseknutych hodnoty
  for i := 1 to 6 do
    for j := 1 to 10 do
			if (prvek_pom.pole[i,j] <> 0) and (prvek_pom.pole[i,j] <> 100) then
	      if prvek_pom.pole[i,j] < 50 then begin
		  		prvek_pom.pole[i,j] := (rot-1)*5 + prvek_pom.pole[i,j];
  	      if prvek_pom.pole[i,j] > 30 then prvek_pom.pole[i,j] := prvek_pom.pole[i,j] - 30;
	      end
	      else begin
				  prvek_pom.pole[i,j] := - (rot-1)*5 + prvek_pom.pole[i,j];
	        if prvek_pom.pole[i,j] < 70 then prvek_pom.pole[i,j] := prvek_pom.pole[i,j] + 30;
		    end;
  // ted to rozdelime podle rotaci
  case rot of
  	1 : begin
          for i := 1 to 6 do
            for j := 1 to 10 do
							prvek_vys.pole[i,j] := prvek_pom.pole[i,j];
    		end;
  	2 : begin
          //a jeste to otocime
					prvek_vys.pole[5,2] := prvek_pom.pole[1,1];
					prvek_vys.pole[4,2] := prvek_pom.pole[1,2];
          prvek_vys.pole[4,3] := prvek_pom.pole[1,3];
 					prvek_vys.pole[3,3] := prvek_pom.pole[1,4];
					prvek_vys.pole[3,4] := prvek_pom.pole[1,5];
 					prvek_vys.pole[2,4] := prvek_pom.pole[1,6];
 					prvek_vys.pole[2,5] := prvek_pom.pole[1,7];
 					prvek_vys.pole[1,5] := prvek_pom.pole[1,8];
          //druha rada
					prvek_vys.pole[5,3] := prvek_pom.pole[2,1];
					prvek_vys.pole[5,4] := prvek_pom.pole[2,2];
          prvek_vys.pole[4,4] := prvek_pom.pole[2,3];
 					prvek_vys.pole[4,5] := prvek_pom.pole[2,4];
					prvek_vys.pole[3,5] := prvek_pom.pole[2,5];
 					prvek_vys.pole[3,6] := prvek_pom.pole[2,6];
 					prvek_vys.pole[2,6] := prvek_pom.pole[2,7];
 					prvek_vys.pole[2,7] := prvek_pom.pole[2,8];
          //treti rada
					prvek_vys.pole[6,5] := prvek_pom.pole[3,1];
					prvek_vys.pole[5,5] := prvek_pom.pole[3,2];
          prvek_vys.pole[5,6] := prvek_pom.pole[3,3];
 					prvek_vys.pole[4,6] := prvek_pom.pole[3,4];
					prvek_vys.pole[4,7] := prvek_pom.pole[3,5];
 					prvek_vys.pole[3,7] := prvek_pom.pole[3,6];
 					prvek_vys.pole[3,8] := prvek_pom.pole[3,7];
 					prvek_vys.pole[2,8] := prvek_pom.pole[3,8];
          //ctvrta rada
					prvek_vys.pole[6,6] := prvek_pom.pole[4,1];
					prvek_vys.pole[6,7] := prvek_pom.pole[4,2];
          prvek_vys.pole[5,7] := prvek_pom.pole[4,3];
 					prvek_vys.pole[5,8] := prvek_pom.pole[4,4];
					prvek_vys.pole[4,8] := prvek_pom.pole[4,5];
 					prvek_vys.pole[4,9] := prvek_pom.pole[4,6];
 					prvek_vys.pole[3,9] := prvek_pom.pole[4,7];
 					prvek_vys.pole[3,10] := prvek_pom.pole[4,8];
    		end;
  	3 : begin
          //a jeste to otocime
					prvek_vys.pole[6,6] := prvek_pom.pole[1,1];
					prvek_vys.pole[6,5] := prvek_pom.pole[1,2];
          prvek_vys.pole[5,5] := prvek_pom.pole[1,3];
 					prvek_vys.pole[5,4] := prvek_pom.pole[1,4];
					prvek_vys.pole[4,4] := prvek_pom.pole[1,5];
 					prvek_vys.pole[4,3] := prvek_pom.pole[1,6];
 					prvek_vys.pole[3,3] := prvek_pom.pole[1,7];
 					prvek_vys.pole[3,2] := prvek_pom.pole[1,8];
          //druha rada
					prvek_vys.pole[6,7] := prvek_pom.pole[2,1];
					prvek_vys.pole[5,7] := prvek_pom.pole[2,2];
          prvek_vys.pole[5,6] := prvek_pom.pole[2,3];
 					prvek_vys.pole[4,6] := prvek_pom.pole[2,4];
					prvek_vys.pole[4,5] := prvek_pom.pole[2,5];
 					prvek_vys.pole[3,5] := prvek_pom.pole[2,6];
 					prvek_vys.pole[3,4] := prvek_pom.pole[2,7];
 					prvek_vys.pole[2,4] := prvek_pom.pole[2,8];
          //treti rada
					prvek_vys.pole[5,9] := prvek_pom.pole[3,1];
					prvek_vys.pole[5,8] := prvek_pom.pole[3,2];
          prvek_vys.pole[4,8] := prvek_pom.pole[3,3];
 					prvek_vys.pole[4,7] := prvek_pom.pole[3,4];
					prvek_vys.pole[3,7] := prvek_pom.pole[3,5];
 					prvek_vys.pole[3,6] := prvek_pom.pole[3,6];
 					prvek_vys.pole[2,6] := prvek_pom.pole[3,7];
 					prvek_vys.pole[2,5] := prvek_pom.pole[3,8];
          //ctvrta rada
					prvek_vys.pole[5,10] := prvek_pom.pole[4,1];
					prvek_vys.pole[4,10] := prvek_pom.pole[4,2];
          prvek_vys.pole[4,9] := prvek_pom.pole[4,3];
 					prvek_vys.pole[3,9] := prvek_pom.pole[4,4];
					prvek_vys.pole[3,8] := prvek_pom.pole[4,5];
 					prvek_vys.pole[2,8] := prvek_pom.pole[4,6];
 					prvek_vys.pole[2,7] := prvek_pom.pole[4,7];
 					prvek_vys.pole[1,7] := prvek_pom.pole[4,8];
    		end;
  	4 : begin
          //a jeste to otocime
					prvek_vys.pole[4,9] := prvek_pom.pole[1,1];
					prvek_vys.pole[4,8] := prvek_pom.pole[1,2];
          prvek_vys.pole[4,7] := prvek_pom.pole[1,3];
 					prvek_vys.pole[4,6] := prvek_pom.pole[1,4];
					prvek_vys.pole[4,5] := prvek_pom.pole[1,5];
 					prvek_vys.pole[4,4] := prvek_pom.pole[1,6];
 					prvek_vys.pole[4,3] := prvek_pom.pole[1,7];
 					prvek_vys.pole[4,2] := prvek_pom.pole[1,8];
          //druha rada
					prvek_vys.pole[3,9] := prvek_pom.pole[2,1];
					prvek_vys.pole[3,8] := prvek_pom.pole[2,2];
          prvek_vys.pole[3,7] := prvek_pom.pole[2,3];
 					prvek_vys.pole[3,6] := prvek_pom.pole[2,4];
					prvek_vys.pole[3,5] := prvek_pom.pole[2,5];
 					prvek_vys.pole[3,4] := prvek_pom.pole[2,6];
 					prvek_vys.pole[3,3] := prvek_pom.pole[2,7];
 					prvek_vys.pole[3,2] := prvek_pom.pole[2,8];
          //treti rada
					prvek_vys.pole[2,9] := prvek_pom.pole[3,1];
					prvek_vys.pole[2,8] := prvek_pom.pole[3,2];
          prvek_vys.pole[2,7] := prvek_pom.pole[3,3];
 					prvek_vys.pole[2,6] := prvek_pom.pole[3,4];
					prvek_vys.pole[2,5] := prvek_pom.pole[3,5];
 					prvek_vys.pole[2,4] := prvek_pom.pole[3,6];
 					prvek_vys.pole[2,3] := prvek_pom.pole[3,7];
 					prvek_vys.pole[2,2] := prvek_pom.pole[3,8];
          //ctvrta rada
					prvek_vys.pole[1,9] := prvek_pom.pole[4,1];
					prvek_vys.pole[1,8] := prvek_pom.pole[4,2];
          prvek_vys.pole[1,7] := prvek_pom.pole[4,3];
 					prvek_vys.pole[1,6] := prvek_pom.pole[4,4];
					prvek_vys.pole[1,5] := prvek_pom.pole[4,5];
 					prvek_vys.pole[1,4] := prvek_pom.pole[4,6];
 					prvek_vys.pole[1,3] := prvek_pom.pole[4,7];
 					prvek_vys.pole[1,2] := prvek_pom.pole[4,8];
    		end;
    5 : begin
          //a jeste to otocime
					prvek_vys.pole[2,10] := prvek_pom.pole[1,1];
					prvek_vys.pole[3,10] := prvek_pom.pole[1,2];
          prvek_vys.pole[3,9] := prvek_pom.pole[1,3];
 					prvek_vys.pole[4,9] := prvek_pom.pole[1,4];
					prvek_vys.pole[4,8] := prvek_pom.pole[1,5];
 					prvek_vys.pole[5,8] := prvek_pom.pole[1,6];
 					prvek_vys.pole[5,7] := prvek_pom.pole[1,7];
 					prvek_vys.pole[6,7] := prvek_pom.pole[1,8];
          //druha rada
					prvek_vys.pole[2,9] := prvek_pom.pole[2,1];
					prvek_vys.pole[2,8] := prvek_pom.pole[2,2];
          prvek_vys.pole[3,8] := prvek_pom.pole[2,3];
 					prvek_vys.pole[3,7] := prvek_pom.pole[2,4];
					prvek_vys.pole[4,7] := prvek_pom.pole[2,5];
 					prvek_vys.pole[4,6] := prvek_pom.pole[2,6];
 					prvek_vys.pole[5,6] := prvek_pom.pole[2,7];
 					prvek_vys.pole[5,5] := prvek_pom.pole[2,8];
          //treti rada
					prvek_vys.pole[1,7] := prvek_pom.pole[3,1];
					prvek_vys.pole[2,7] := prvek_pom.pole[3,2];
          prvek_vys.pole[2,6] := prvek_pom.pole[3,3];
 					prvek_vys.pole[3,6] := prvek_pom.pole[3,4];
					prvek_vys.pole[3,5] := prvek_pom.pole[3,5];
 					prvek_vys.pole[4,5] := prvek_pom.pole[3,6];
 					prvek_vys.pole[4,4] := prvek_pom.pole[3,7];
 					prvek_vys.pole[5,4] := prvek_pom.pole[3,8];
          //ctvrta rada
					prvek_vys.pole[1,6] := prvek_pom.pole[4,1];
					prvek_vys.pole[1,5] := prvek_pom.pole[4,2];
          prvek_vys.pole[2,5] := prvek_pom.pole[4,3];
 					prvek_vys.pole[2,4] := prvek_pom.pole[4,4];
					prvek_vys.pole[3,4] := prvek_pom.pole[4,5];
 					prvek_vys.pole[3,3] := prvek_pom.pole[4,6];
 					prvek_vys.pole[4,3] := prvek_pom.pole[4,7];
 					prvek_vys.pole[4,2] := prvek_pom.pole[4,8];
    		end;
  	6 : begin
          //a jeste to otocime
					prvek_vys.pole[1,6] := prvek_pom.pole[1,1];
					prvek_vys.pole[1,7] := prvek_pom.pole[1,2];
          prvek_vys.pole[2,7] := prvek_pom.pole[1,3];
 					prvek_vys.pole[2,8] := prvek_pom.pole[1,4];
					prvek_vys.pole[3,8] := prvek_pom.pole[1,5];
 					prvek_vys.pole[3,9] := prvek_pom.pole[1,6];
 					prvek_vys.pole[4,9] := prvek_pom.pole[1,7];
 					prvek_vys.pole[4,10] := prvek_pom.pole[1,8];
          //druha rada
					prvek_vys.pole[1,5] := prvek_pom.pole[2,1];
					prvek_vys.pole[2,5] := prvek_pom.pole[2,2];
          prvek_vys.pole[2,6] := prvek_pom.pole[2,3];
 					prvek_vys.pole[3,6] := prvek_pom.pole[2,4];
					prvek_vys.pole[3,7] := prvek_pom.pole[2,5];
 					prvek_vys.pole[4,7] := prvek_pom.pole[2,6];
 					prvek_vys.pole[4,8] := prvek_pom.pole[2,7];
 					prvek_vys.pole[5,8] := prvek_pom.pole[2,8];
          //treti rada
					prvek_vys.pole[2,3] := prvek_pom.pole[3,1];
					prvek_vys.pole[2,4] := prvek_pom.pole[3,2];
          prvek_vys.pole[3,4] := prvek_pom.pole[3,3];
 					prvek_vys.pole[3,5] := prvek_pom.pole[3,4];
					prvek_vys.pole[4,5] := prvek_pom.pole[3,5];
 					prvek_vys.pole[4,6] := prvek_pom.pole[3,6];
 					prvek_vys.pole[5,6] := prvek_pom.pole[3,7];
 					prvek_vys.pole[5,7] := prvek_pom.pole[3,8];
          //ctvrta rada
					prvek_vys.pole[2,2] := prvek_pom.pole[4,1];
					prvek_vys.pole[3,2] := prvek_pom.pole[4,2];
          prvek_vys.pole[3,3] := prvek_pom.pole[4,3];
 					prvek_vys.pole[4,3] := prvek_pom.pole[4,4];
					prvek_vys.pole[4,4] := prvek_pom.pole[4,5];
 					prvek_vys.pole[5,4] := prvek_pom.pole[4,6];
 					prvek_vys.pole[5,5] := prvek_pom.pole[4,7];
 					prvek_vys.pole[6,5] := prvek_pom.pole[4,8];
    		end;
  end;
	Napln_prvek := prvek_vys;
end;

procedure TVysledky.Vykresli(x,y,typ : integer; barva : TColor);
var sit : array [0..2] of TPoint;
begin
	if (x + y) mod 2 = 1 then begin
  	sit[0] := Point(39 + (y div 2)*18,10 + (x - 1)*16);
		sit[1] := Point(48 + (y div 2)*18,26 + (x - 1)*16);
    sit[2] := Point(30 + (y div 2)*18,26 + (x - 1)*16);
		// posun pro sude radky
    if x mod 2 = 0 then begin
	  	sit[0] := Point(sit[0].x + 9, sit[0].y);
	  	sit[1] := Point(sit[1].x + 9, sit[1].y);
	  	sit[2] := Point(sit[2].x + 9, sit[2].y);
    end;
   	Canvas.Brush.Color := barva;
    case typ of
   	  5 : sit[1] := Point(sit[1].x - 9, sit[1].y);
      15 : sit[0] := Point(sit[0].x + 4, sit[0].y + 8);
	   	25 : sit[2] := Point(sit[2].x + 4, sit[2].y - 8);
      75 : sit[0] := Point(sit[0].x - 4, sit[0].y + 8);
      85 : sit[1] := Point(sit[1].x - 4, sit[1].y - 8 );
      95 : sit[2] := Point(sit[2].x + 9, sit[2].y);
    end;
    Canvas.Polygon(sit);
  end
  else begin
 		sit[0] := Point(21 + (y div 2 + 1)*18, 10 + (x - 1)*16);
		sit[1] := Point(39 + (y div 2 + 1)*18, 10 + (x - 1)*16);
    sit[2] := Point(30 + (y div 2 + 1)*18, 26 + (x - 1)*16);
		// posun pro sude radky
    if x mod 2 = 0 then begin
	  	sit[0] := Point(sit[0].x - 9, sit[0].y);
	  	sit[1] := Point(sit[1].x - 9, sit[1].y);
	  	sit[2] := Point(sit[2].x - 9, sit[2].y);
  	end;
   	Canvas.Brush.Color := barva;
    case Typ of
      10 : sit[1] := Point(sit[1].x - 4, sit[1].y + 8);
    	20 : sit[0] := Point(sit[0].x + 9, sit[0].y);
    	30 : sit[2] := Point(sit[2].x - 4, sit[2].y - 8);
     	70 : sit[0] := Point(sit[0].x + 4, sit[0].y + 8);
     	80 : sit[1] := Point(sit[1].x - 9, sit[1].y);
      90 : sit[2] := Point(sit[2].x + 4, sit[2].y - 8);
    end;
    Canvas.Polygon(sit);
  end;
end;

procedure TVysledky.Button1Click(Sender: TObject);
var i, j, x, y, k : integer;
    Prvek : TPrvek_pom;
    barva : TColor;
    konec : boolean;
    sit_velka : array [1..12] of TPoint;
begin
  // A otevru soubor s prvky pro nahrani do pameti
	if OpenDialog1.Execute then
	  Nacti_reseni;
	// toz nejdriv nastavime barvy
 	Canvas.Brush.Color := clBtnFace;
  Canvas.Pen.Color := clBlack;
  // pak nacrtneme obrys
  x := 47;
  sit_velka[1] := Point(171 + x, 10);
  sit_velka[2] := Point(63 + x, 74);
  sit_velka[3] := Point(0 + x, 186);
  sit_velka[4] := Point(0 + x, 314);
  sit_velka[5] := Point(63 + x, 426);
  sit_velka[6] := Point(171 + x, 490);
  sit_velka[7] := Point(297 + x, 490);
  sit_velka[8] := Point(405 + x, 426);
  sit_velka[9] := Point(468 + x, 314);
  sit_velka[10] := Point(468 + x, 186);
  sit_velka[11] := Point(405 + x, 74);
  sit_velka[12] := Point(297 + x, 10);
	// a vykreslime
	Canvas.Polygon(sit_velka);
  // ted postupne vykreslime vsechny prvky
  for k := 0 to Reseni.Count - 1 do begin
	  Prvek := Napln_prvek(PDilek(Reseni.Items[k])^.cis,PDilek(Reseni.Items[k])^.rot);
    // najdeme prvy nenulovy prvek
    konec := false;
    for i := 1 to 6 do begin
    	for j := 1 to 10 do
				if Prvek.pole[i,j] <> 0 then begin
          konec := true;
         	break;
        end;
      if konec then break;
    end;
    // vytvorime barvu
    if k mod 2 = 0 then barva := k*80000 + 80000
    else barva := 16700000 - k*80000;
    // a prvek vykreslime
    x := i; y := j;
		for i := x to 6 do
	  	for j := 1 to 10 do
				if Prvek.pole[i,j] <> 0 then
	      	vykresli(PDilek(Reseni.Items[k])^.x + i - x, PDilek(Reseni.Items[k])^.y + j - y, Prvek.pole[i,j],barva);
  end;
end;

end.
