//---------------------------------------------------------------------------
#ifndef Unit1H
#define Unit1H
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <stdio.h>
#include <conio.h>

// ----------------------Moje sracky-----------------------------------------
#define TRUE 1
#define FALSE 0

#define ZDROJ "zdroj.txt"             // jmeno zdrojoveho souboru
#define CIL   "tuton.txt"             // jmeno vystupniho souboru
#define POCET_PRVKU 209               // pocet dilku
#define MAX_X 6                       // velikost pole do ktereho zapisujeme dilek x souradnice
#define MAX_Y 10                      // velikost pole do ktereho zapisujeme dilek y souradnice
#define MAX_MX 30                     // velikost matice x souradnice
#define MAX_MY 53                     // velikost matice y souradnice
#define ROTACE 6                      // pocet rotaci prvku
#define MAX_HROTY 300                 // max pocet hrotu jednoh
#define POCET_VOLNY 300               // pocet polozek v G_VOLNY
#define TYP_HROT 36                   // pocet typu hrotu

#define SKOK   100                    //krok po kterem se vypisuji hodnoty na obrazovku
#define SKOK_ULOZIT 1000000          //krok po kterem se zalohuje

typedef struct sHrot    // Struktura popisujici jednotlive hroty prvku
{                       // typ hrotu je naznacen umistenim do prislusneho pole
	int cis;              // cislo prvku
	int rot;              // rotace prvku
	int x, y;             // relativni souradnice hrotu
}tHrot;

typedef struct sDira    // Struktura popisujici jednotlive diry na prvku
{                       // cislo a rotace prvku vypliva z prvku ve kterem je
                        // ulozena jako matice dir
  int cis;              // cislo prvku na kterem je dira
	int typ;              // typ diry
	int x, y;             // pro G_VOLNY JSOU TO ASOLUtni souradnice diry
                        // pro ostatni jsou to relativni souradnice diry
  int zalepeno;         // hodnota signaliyujici zda tato dira je jiz obsazena
  int cislo;            // a cim
}tDira;

typedef struct sPrvek   // struktura popisujici kazdy prvek
{
	int	cis;              // cislo prvku
	int	pole[MAX_X+1][MAX_Y+1]; // pole popisujici prvek pomoci hodnot 0,100 atd.
	tDira diry[4+1];        // pole obsahujici seznam der prvku
	int x, y;             // relat. souradnice prvni casti prvku od vrchu a zleva
	int	rot;              // cislo rotace prvku
}tPrvek;

typedef struct sDilek   // struktura pro ukaldani vysledku
{
	int	cis;              // cislo vkladaneho prvku
	int	x,y;              // abs. souradnice prvni casti prvku od vrchu a zleva
	int	rot;              // rotace prvku
}tDilek;

typedef struct sNej     // strukruta obsahujici prapocitany vkladaci bod
                        // z G_VOLNY na prvni cast prvku z vrchu a zleva
{
	int	x,y;              // absolutni souradnice vkladaciho bodu
	int	typ;              //  a jeho typ (moyna nebudu potrebovat)
}tNej;
// ----------------------Konec mojich sracek---------------------------------
//---------------------------------------------------------------------------
class TForm1 : public TForm
{
__published:	// IDE-managed Components
  TButton *Button1;
  TEdit *Edit1;
  TLabel *Label1;
  TLabel *Label2;
  TLabel *Label3;
  TLabel *Label4;
  TLabel *Label5;
  TEdit *Edit2;
  TEdit *Edit3;
  TEdit *Edit4;
  TEdit *Edit5;
  TLabel *Label6;
  TLabel *Label7;
  TLabel *Label8;
  TLabel *Label9;
  TLabel *Label10;
  TLabel *Label11;
  TEdit *Edit6;
  TEdit *Edit7;
  TEdit *Edit8;
  TEdit *Edit9;
  TLabel *Label16;
  TLabel *Label12;
  TLabel *Label13;
  TLabel *Label14;
  TEdit *Edit10;
  TEdit *Edit11;
  TCheckBox *CheckBox1;
  void __fastcall Button1Click(TObject *Sender);
 	void __fastcall smaz(int k);
 	void __fastcall napln_matici(void);
 	tPrvek __fastcall napln_prvek ( int cis, int rot );
 	int __fastcall kontrola( tPrvek prvek );
 	void __fastcall pridej_prvek ( tPrvek prvek );
 	void __fastcall odeber_prvek(void);
  void __fastcall pridej_diru(int typ, int cis, int rot,int x,int y);
  void __fastcall pridej_hrot(int typ,int cis,int rot,int x,int y);
  void __fastcall nacti_hroty(void);
  void __fastcall nacti_diry(void);
  int __fastcall nacti_prvky(void);
 	int __fastcall ulozit(char res[]);
 	int __fastcall hledej(void);
 	void __fastcall nacti_reseni( char res[] );
  void __fastcall FormCreate(TObject *Sender);
  void __fastcall zapis_matici ( void );
  void __fastcall zapis_volny ( void );
  int __fastcall plocha_naplnena(int a,int b,int x,int y);
private:	// User declarations
public:		// User declarations
  tPrvek g_prvky[POCET_PRVKU+1][ROTACE+1];// pole vsech prvku
  tDilek g_reseni[POCET_PRVKU+1];         // pole reseni
  tDira  g_volny[POCET_VOLNY + 1];            // pole volnych der
  tHrot  g_hroty[TYP_HROT+1][MAX_HROTY];  // pole vsech hrotu tridenych podle typu
  tDilek g_nula_d;                        // nulovy prvek pro mayani v G_RESENI
  tDira  g_nula_volny;                    // nulovy prvek pro mazani G_VOLNY
  int		g_ulozeno[POCET_PRVKU+1];         // pole nastaveni zda je prvek ulozen
  int		g_stupen;                         // pocet jiz ulozenych prvku
  int   g_nej_stupen;                     // nejvyssi dosazeny stupen
  int		g_stupen_volny;                   // pocet volnych der
  int   g_program_bezi;                   // signaliyuje zda hledani bezi
  int		g_cislo_posledniho_prvku;         // cislo prvku ktery se zkusi ulozit kdyz jsme
                                          // odebrali prvek, bude toto cislo nejblizsi
                                          //  vyssi pokud pridali bude 1
  int   g_prvni_prvek;                    // cislo nejvyssiho prvniho ulozeneho prvku
  tNej	g_nej;                            // jedina hodnota vyuzivajici tuto strukturu
  int		g_matice[MAX_MX+2][MAX_MY+2];     // matice obsahujici celou hraci plochu
  int   g_pocet_kroku;                    // pocet provedenych kroku
  int   pouzivat_omez_pole;                // urcuje zda pouzivat omezujici pole
  int   zacatek_x;                        // poloha a velikost pole mimo ktere nen dovoleno ukladat
  int   zacatek_y;
  int   konec_x;
  int   konec_y;
  int   dis_zac_x;                        //velikost zmenseni na pole ktere musi byt napleno pro ukonceni
  int   dis_zac_y;
  int   dis_kon_x;
  int   dis_kon_y;
  int poz_prv_dil_x;               // pozice prvniho vkladaneho dilku typu
  int poz_prv_dil_y;

  __fastcall TForm1(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
 