/*
 * Decompiled with CFR 0.152.
 */
package cz.luboss.medulla.client.view;

import cz.luboss.lubosslib.LException;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McTableArray;
import cz.luboss.medulla.client.view.TableSorter;
import cz.luboss.medulla.common.MeColumn;
import cz.luboss.medulla.common.MePodminka;
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.data.MeItem;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;

public abstract class McGrid
extends JScrollPane {
    protected MeArray m_arrData;
    protected MePodminka m_iPodminka;
    protected MeColumn[] m_arrColumn;
    public JFrame m_frView = null;
    public JTable m_tabView = null;
    protected McTableArray m_tabModel = null;
    protected int m_nSelectedRow = -1;
    int m_colSort = 0;
    boolean m_bAscending = true;
    TableSorter m_DataSorter = null;
    boolean m_SortedTable = true;

    public MeItem GetSelectedItem() {
        if (this.m_nSelectedRow < 0) {
            return null;
        }
        return this.m_arrData.getItem(this.m_nSelectedRow);
    }

    public int AddItem() {
        throw new LException(this.getClass(), "Pro grid " + this + " neni definovana funkce AddItem");
    }

    public boolean DeleteItem(MeItem iItem) {
        MedullaContext.StartTransaction();
        iItem.delete();
        MedullaContext.Commit();
        return true;
    }

    public void EventTwoClick(int nCol, int nRow) {
        McDialog dlg = McDialog.CreateDlg(this.m_frView, this.m_arrData.getItem(nRow));
        MedullaContext.StartTransaction();
        MedullaContext.Register(this.m_arrData.getItem(nRow));
        dlg.showDialog();
        if (dlg.GetButton() == 1) {
            MedullaContext.Commit();
        } else {
            MedullaContext.RollBack();
        }
    }

    public void EventChangeGrid(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        this.m_nSelectedRow = lsm.isSelectionEmpty() ? -1 : lsm.getMinSelectionIndex();
    }

    public void EventKeyInsert() {
        int nRowNew = this.AddItem();
        this.ReloadTable();
    }

    public void EventKeyDelete() {
        if (this.m_nSelectedRow < 0) {
            return;
        }
        this.DeleteItem(this.m_arrData.getItem(this.m_nSelectedRow));
        int nRow = this.m_nSelectedRow == 0 ? 0 : this.m_nSelectedRow - 1;
        this.m_tabView.setRowSelectionInterval(nRow, nRow);
        this.ReloadTable();
    }

    public void EventKeyP() {
        if (this.m_nSelectedRow < 0) {
            return;
        }
        this.PrintData(true, this.m_nSelectedRow);
    }

    public void EventKeyT() {
        if (this.m_nSelectedRow < 0) {
            return;
        }
        this.PrintData(false, this.m_nSelectedRow);
    }

    public void EventKeyDown(KeyEvent e, int nCol, int nRow) {
        if (e.getKeyCode() == 155) {
            this.EventKeyInsert();
        }
        if (e.getKeyCode() == 127 && nRow >= 0) {
            this.EventKeyDelete();
        }
        if (e.getKeyCode() == 80) {
            this.EventKeyP();
        }
        if (e.getKeyCode() == 79) {
            this.EventKeyT();
        }
    }

    public boolean SetPodminka(MePodminka podminka) {
        this.m_iPodminka = podminka;
        return true;
    }

    public MePodminka GetPodminka() {
        return this.m_iPodminka;
    }

    public boolean Inicialize(JFrame frame) {
        this.m_frView = frame;
        this.m_tabModel = McTableArray.CreateTable(this.m_arrData, this.m_arrColumn);
        if (!this.m_SortedTable) {
            this.m_tabView = new JTable(this.m_tabModel);
        } else {
            this.m_DataSorter = new TableSorter(this.m_tabModel);
            this.m_tabView = new JTable(this.m_DataSorter);
            this.m_DataSorter.addMouseListenerToHeaderInTable(this.m_tabView);
        }
        this.m_tabView.setAutoResizeMode(0);
        GridMouseAdapter listMouseListener = new GridMouseAdapter();
        this.m_tabView.addMouseListener(listMouseListener);
        GridKeyAdapter listKeyListener = new GridKeyAdapter();
        this.m_tabView.addKeyListener(listKeyListener);
        this.m_tabView.setSelectionMode(0);
        ListSelectionModel rowSM = this.m_tabView.getSelectionModel();
        rowSM.addListSelectionListener(new GridChangeListener());
        this.setViewportView(this.m_tabView);
        for (int i = 0; i < this.m_arrColumn.length; ++i) {
            this.m_tabView.getColumnModel().getColumn(i).setPreferredWidth(this.m_arrColumn[i].GetWidth());
        }
        return true;
    }

    public boolean FilterTable(MePodminka iPodminka) {
        if (this.m_SortedTable) {
            this.m_colSort = this.m_DataSorter.m_colSort;
            this.m_bAscending = this.m_DataSorter.m_bAscending;
        }
        this.m_iPodminka = iPodminka;
        this.m_arrData.loadArray(this.m_iPodminka);
        if (this.m_SortedTable) {
            this.m_DataSorter.reallocateIndexes();
            this.m_DataSorter.sortByColumn(this.m_colSort, this.m_bAscending);
        }
        this.m_tabView.revalidate();
        this.updateUI();
        return true;
    }

    public boolean ReloadTable() {
        return this.FilterTable(this.m_iPodminka);
    }

    public boolean PrintData(boolean bAllRows, int nRow) {
        Object[] options = new String[]{MedullaContext.getRes("BUTTON_OK")};
        JOptionPane panel = new JOptionPane(MedullaContext.getRes("ERROR_CHYBI_TISK_SESTAVA"), 0, 0, null, options);
        JDialog dlg = panel.createDialog(null, MedullaContext.getRes("DLG_CHYBI_TISK_SESTAVA_NADPIS"));
        dlg.setModal(true);
        dlg.setVisible(true);
        return true;
    }

    public class GridKeyAdapter
    extends KeyAdapter {
        public void keyReleased(KeyEvent e) {
            McGrid.this.EventKeyDown(e, McGrid.this.m_tabView.getSelectedColumn(), McGrid.this.m_tabView.getSelectedRow());
        }
    }

    public class GridChangeListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            McGrid.this.EventChangeGrid(e);
        }
    }

    public class GridMouseAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel = McGrid.this.m_tabView.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = McGrid.this.m_tabView.convertColumnIndexToModel(viewColumn);
            if (e.getClickCount() == 2 && column != -1) {
                McGrid.this.EventTwoClick(column, McGrid.this.m_nSelectedRow);
            }
        }
    }
}

