/*
 * Decompiled with CFR 0.152.
 */
package cz.luboss.medulla.common;

import cz.luboss.medulla.common.MeConfig;
import cz.luboss.medulla.common.MePodminka;
import cz.luboss.medulla.common.MeTransact;
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.data.MeItem;
import cz.luboss.medulla.data.MeSession;
import cz.luboss.medulla.factory.MeDataMachine;
import java.util.Locale;
import java.util.ResourceBundle;

public class MeContext {
    protected MeConfig m_Config;
    protected MeDataMachine m_DataMachine;
    protected MeSession m_Session;
    protected ResourceBundle m_rResources = null;
    protected MeTransact m_tTransact = MeTransact.CreateInstance();

    public boolean SetConf(MeConfig iConfig) {
        this.m_Config = iConfig;
        return true;
    }

    public boolean SetMachine(MeDataMachine iDataMachine) {
        this.m_DataMachine = iDataMachine;
        return true;
    }

    public boolean SetSession(MeSession iSession) {
        this.m_Session = iSession;
        switch (this.m_Session.getLang()) {
            case 0: {
                this.m_rResources = ResourceBundle.getBundle("cz.luboss.pensum.common.PeResources", new Locale("cs"));
                break;
            }
            case 1: {
                this.m_rResources = ResourceBundle.getBundle("cz.luboss.pensum.common.PeResources", Locale.ENGLISH);
                break;
            }
            case 2: {
                this.m_rResources = ResourceBundle.getBundle("cz.luboss.pensum.common.PeResources", Locale.GERMAN);
            }
        }
        return true;
    }

    public MeConfig GetConf() {
        return this.m_Config;
    }

    public MeDataMachine GetMachine() {
        return this.m_DataMachine;
    }

    public MeSession GetSession() {
        return this.m_Session;
    }

    public String GetRes(String sName) {
        if (this.GetSession() == null) {
            return "Unknow user";
        }
        return this.m_rResources.getString(sName);
    }

    public static MeContext CreateInstance() {
        MeContext context = new MeContext();
        return context;
    }

    public boolean StartTransaction() {
        return this.m_tTransact.StartTransaction();
    }

    public boolean RollBack() {
        return this.m_tTransact.RollBack();
    }

    public boolean Commit() {
        if (this.m_tTransact.TransactionIsLast() && !this.GetMachine().SaveTrans(this.GetSession().getID(), this.m_tTransact.GetTransactionData())) {
            return false;
        }
        return this.m_tTransact.Commit();
    }

    public boolean Register(MeItem item) {
        if (!item.isIDGenerate()) {
            item.addSequenceID();
        }
        return this.m_tTransact.Register(item);
    }

    public boolean UnRegister(MeItem item) {
        return this.m_tTransact.UnRegister(item);
    }

    public boolean LoadData(MeItem item, int nID) {
        if (this.m_tTransact.IsInActual(item.generateKod(nID))) {
            item.setData(this.m_tTransact.GetFromActual(item.generateKod(nID)));
        } else {
            if (!this.GetMachine().LoadData(this.GetSession().getID(), item, nID)) {
                return false;
            }
            this.m_tTransact.SetToActual(item);
            item.setStatus(2);
        }
        return true;
    }

    public boolean LoadArray(MeArray array, MePodminka iPodminka) {
        if (!MedullaContext.GetMachine().LoadArray(MedullaContext.GetSessionID(), array, iPodminka)) {
            return false;
        }
        array.setStatus(2);
        return true;
    }

    public boolean DeleteData(MeItem item, int nID) {
        item.setStatus(3);
        return true;
    }
}

