/*
 * Decompiled with CFR 0.152.
 */
package cz.luboss.medulla.factory;

import cz.luboss.lubosslib.LException;
import cz.luboss.medulla.common.MeDataTest;
import cz.luboss.medulla.common.MePodminka;
import cz.luboss.medulla.common.MeUtils;
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.data.MeItem;
import cz.luboss.medulla.data.MeSession;
import cz.luboss.medulla.factory.MeConnect;
import cz.luboss.medulla.factory.MeConnectRMI;
import cz.luboss.medulla.factory.MeDataMachine;
import cz.luboss.medulla.factory.MedullaRMI;
import java.util.Collection;

public abstract class MeDataMachineRMI
implements MeDataMachine,
MedullaRMI {
    protected MeConnectRMI m_dtConnectRMI;

    public boolean SetConnect(MeConnect dtConnect) {
        this.m_dtConnectRMI = (MeConnectRMI)dtConnect;
        return true;
    }

    public MeConnect GetConnect() {
        return this.m_dtConnectRMI;
    }

    public MeDataTest sendTest(MeDataTest message) {
        try {
            return this.m_dtConnectRMI.GeRMI().sendTest(message);
        }
        catch (Exception e) {
            throw new LException(this.getClass(), "Chyba pri spousteni RMI testu");
        }
    }

    public MeSession LoadSession(String sLogin, String sPassword) {
        MedullaContext.logDebug(this.getClass(), "LoadSession RMI [" + sLogin + "]");
        try {
            return this.m_dtConnectRMI.GeRMI().LoadSession(sLogin, sPassword);
        }
        catch (Exception e) {
            throw new LException(this.getClass(), "LoadSession [" + sLogin + "] Error");
        }
    }

    public boolean IsValidSession(int nSessionID) {
        try {
            return this.m_dtConnectRMI.GeRMI().IsValidSession(nSessionID);
        }
        catch (Exception e) {
            throw new LException(this.getClass(), "IsValidSession [" + nSessionID + "] Error");
        }
    }

    public MeArray GetActualSessions() {
        try {
            return this.m_dtConnectRMI.GeRMI().GetActualSessions();
        }
        catch (Exception e) {
            throw new LException(this.getClass(), "GetActualSessions Error");
        }
    }

    public boolean LoadData(int nSessionID, MeItem item, int nID) {
        MedullaContext.logDebug(this.getClass(), "S[" + nSessionID + "] Load Item " + MeUtils.separeName(item.getClass()) + " pro ID [" + nID + "].");
        MeItem loadRMI = this.LoadDataRMI(nSessionID, item, nID);
        if (loadRMI == null) {
            return false;
        }
        return item.setData(loadRMI);
    }

    public boolean LoadArray(int nSessionID, MeArray arrayItem, MePodminka podminka) {
        MedullaContext.logDebug(this.getClass(), "S[" + nSessionID + "] Load Array " + MeUtils.separeName(arrayItem.getClass()) + " pro podminkou [" + (podminka == null ? "null" : podminka.GetSQLQuery()) + "].");
        MeArray arrayRMI = this.LoadArrayRMI(nSessionID, arrayItem, podminka);
        if (arrayRMI == null) {
            return false;
        }
        arrayItem.clear();
        arrayItem.addAll(arrayRMI);
        return true;
    }

    public boolean SaveTrans(int nSessionID, Collection arrTransData) {
        MedullaContext.logDebug(this.getClass(), "S[" + nSessionID + "] Transakce s poctem " + arrTransData.size() + " bude ulozena.");
        try {
            return this.m_dtConnectRMI.GeRMI().SaveTrans(nSessionID, arrTransData);
        }
        catch (Exception e) {
            throw new LException(this.getClass(), "S[" + nSessionID + "] SaveTrans RMI Error", e);
        }
    }

    public int AddSequenceID(int nSessionID, MeItem item) {
        MedullaContext.logDebug(this.getClass(), "S[" + nSessionID + "] Generovani ID pro " + MeUtils.separeName(item.getClass()));
        try {
            return this.m_dtConnectRMI.GeRMI().AddSequenceID(nSessionID, item);
        }
        catch (Exception e) {
            throw new LException(this.getClass(), "S[" + nSessionID + "] AddSequenceID " + MeUtils.separeName(item.getClass()) + " Error", e);
        }
    }

    public MeItem LoadDataRMI(int nSessionID, MeItem item, int nID) {
        try {
            return this.m_dtConnectRMI.GeRMI().LoadDataRMI(nSessionID, item, nID);
        }
        catch (Exception e) {
            throw new LException(this.getClass(), "S[" + nSessionID + "] LoadDataRMI Error " + MeUtils.separeName(item.getClass()) + ", ID [" + nID + "]", e);
        }
    }

    public MeArray LoadArrayRMI(int nSessionID, MeArray arrayItem, MePodminka podminka) {
        try {
            return this.m_dtConnectRMI.GeRMI().LoadArrayRMI(nSessionID, arrayItem, podminka);
        }
        catch (Exception e) {
            throw new LException(this.getClass(), "S[" + nSessionID + "] Load Array " + MeUtils.separeName(arrayItem.getClass()) + " pro podminkou [" + (podminka == null ? "null" : podminka.GetSQLQuery()) + "].");
        }
    }
}

