/*
 * Decompiled with CFR 0.152.
 */
package cz.luboss.pensum.client;

import cz.luboss.medulla.client.theme.AquaTheme;
import cz.luboss.medulla.client.theme.BigContrastMetalTheme;
import cz.luboss.medulla.client.theme.CharcoalTheme;
import cz.luboss.medulla.client.theme.ContrastMetalTheme;
import cz.luboss.medulla.client.theme.ContrastTheme;
import cz.luboss.medulla.client.theme.DemoMetalTheme;
import cz.luboss.medulla.client.theme.EmeraldTheme;
import cz.luboss.medulla.client.theme.GreenMetalTheme;
import cz.luboss.medulla.client.theme.KhakiMetalTheme;
import cz.luboss.medulla.client.theme.RubyTheme;
import cz.luboss.pensum.client.panel.PcJobsActualPanel;
import cz.luboss.pensum.client.panel.PcMaterialsPanel;
import cz.luboss.pensum.client.panel.PcPartsPanel;
import cz.luboss.pensum.client.panel.PcPlacesPanel;
import cz.luboss.pensum.client.panel.PcProductsPanel;
import cz.luboss.pensum.client.panel.PcSessionPanel;
import cz.luboss.pensum.client.panel.PcWorkersPanel;
import cz.luboss.pensum.common.PensumContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class PeClient
extends JPanel {
    private static final int PREFERRED_WIDTH = 800;
    private static final int PREFERRED_HEIGHT = 550;
    public JFrame m_fFrame = null;
    private JDialog aboutBox = null;
    private JMenuBar menuBar = null;
    private JMenu lafMenu = null;
    private JMenu themesMenu = null;
    private ButtonGroup lafMenuGroup = new ButtonGroup();
    private ButtonGroup themesMenuGroup = new ButtonGroup();
    private static final String mac = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private static final String metal = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String motif = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String windows = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String gtk = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    private static String currentLookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel";

    private void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        PensumContext.CreateInstance("penclient.cfg", 0, "lc", "");
        this.m_fFrame = new JFrame("PenClient 02");
        JPanel top = new JPanel();
        top.setLayout(new BorderLayout());
        this.m_fFrame.getContentPane().add((Component)top, "North");
        this.menuBar = this.createMenus();
        top.add((Component)this.menuBar, "North");
        JTabbedPane m_TabbedPane = new JTabbedPane();
        m_TabbedPane.addTab(PensumContext.getRes("TAB_BEZICI_PRIKAZY"), PcJobsActualPanel.CreateInstance(this.m_fFrame));
        m_TabbedPane.addTab(PensumContext.getRes("TAB_VYROBKY"), PcProductsPanel.CreateInstance(this.m_fFrame));
        m_TabbedPane.addTab(PensumContext.getRes("TAB_DILCE"), PcPartsPanel.CreateInstance(this.m_fFrame));
        m_TabbedPane.addTab(PensumContext.getRes("TAB_MATERIALY"), PcMaterialsPanel.CreateInstance(this.m_fFrame));
        m_TabbedPane.addTab(PensumContext.getRes("TAB_PRACOVISTE"), PcPlacesPanel.CreateInstance(this.m_fFrame));
        m_TabbedPane.addTab(PensumContext.getRes("TAB_PRACOVNICI"), PcWorkersPanel.CreateInstance(this.m_fFrame));
        m_TabbedPane.addTab(PensumContext.getRes("TAB_RELACE"), PcSessionPanel.CreateInstance(this.m_fFrame));
        m_TabbedPane.setPreferredSize(new Dimension(800, 550));
        this.m_fFrame.setDefaultCloseOperation(3);
        this.m_fFrame.getContentPane().add(m_TabbedPane);
        this.m_fFrame.pack();
        this.m_fFrame.setVisible(true);
    }

    public JMenuBar createMenus() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.getAccessibleContext().setAccessibleName("MenuBar.accessible_description");
        JMenu fileMenu = menuBar.add(new JMenu(PensumContext.getRes("MENU_SOUBOR")));
        fileMenu.setMnemonic('S');
        fileMenu.getAccessibleContext().setAccessibleDescription("FileMenu.accessible_description");
        this.createMenuItem(fileMenu, PensumContext.getRes("MENU_KONEC"), "FileMenu.exit_mnemonic", "FileMenu.exit_accessible_description", new ExitAction(this));
        this.lafMenu = menuBar.add(new JMenu(PensumContext.getRes("MENU_TYP_OKEN")));
        this.lafMenu.setMnemonic('T');
        this.lafMenu.getAccessibleContext().setAccessibleDescription("LafMenu.laf_accessible_description");
        JMenuItem mi = this.createLafMenuItem(this.lafMenu, PensumContext.getRes("MENU_TYP_OKEN_JAVA"), "LafMenu.java_mnemonic", "LafMenu.java_accessible_description", metal);
        mi.setSelected(true);
        this.createLafMenuItem(this.lafMenu, PensumContext.getRes("MENU_TYP_OKEN_MAC"), "LafMenu.mac_mnemonic", "LafMenu.mac_accessible_description", mac);
        this.createLafMenuItem(this.lafMenu, PensumContext.getRes("MENU_TYP_OKEN_MOTIF"), "LafMenu.motif_mnemonic", "LafMenu.motif_accessible_description", motif);
        this.createLafMenuItem(this.lafMenu, PensumContext.getRes("MENU_TYP_OKEN_WINDOWS"), "LafMenu.windows_mnemonic", "LafMenu.windows_accessible_description", windows);
        this.createLafMenuItem(this.lafMenu, PensumContext.getRes("MENU_TYP_OKEN_GTK"), "LafMenu.gtk_mnemonic", "LafMenu.gtk_accessible_description", gtk);
        this.themesMenu = menuBar.add(new JMenu(PensumContext.getRes("MENU_THEME")));
        this.themesMenu.setMnemonic('X');
        this.themesMenu.getAccessibleContext().setAccessibleDescription("ThemesMenu.themes_accessible_description");
        mi = this.createThemesMenuItem(this.themesMenu, "Standard", "ThemesMenu.default_mnemonic", "ThemesMenu.default_accessible_description", new DefaultMetalTheme());
        mi.setSelected(true);
        this.createThemesMenuItem(this.themesMenu, "Aqua", "ThemesMenu.aqua_mnemonic", "ThemesMenu.aqua_accessible_description", new AquaTheme());
        this.createThemesMenuItem(this.themesMenu, "Charcoal", "ThemesMenu.charcoal_mnemonic", "ThemesMenu.charcoal_accessible_description", new CharcoalTheme());
        this.createThemesMenuItem(this.themesMenu, "Contrast", "ThemesMenu.contrast_mnemonic", "ThemesMenu.contrast_accessible_description", new ContrastTheme());
        this.createThemesMenuItem(this.themesMenu, "Contrast Metal", "ThemesMenu.misc_mnemonic", "ThemesMenu.misc_description", new ContrastMetalTheme());
        this.createThemesMenuItem(this.themesMenu, "BigContrast Metal", "ThemesMenu.misc_mnemonic", "ThemesMenu.misc_description", new BigContrastMetalTheme());
        this.createThemesMenuItem(this.themesMenu, "Demo Metal", "ThemesMenu.misc_mnemonic", "ThemesMenu.misc_description", new DemoMetalTheme());
        this.createThemesMenuItem(this.themesMenu, "Emerald", "ThemesMenu.emerald_mnemonic", "ThemesMenu.emerald_accessible_description", new EmeraldTheme());
        this.createThemesMenuItem(this.themesMenu, "Green Metal", "ThemesMenu.misc_mnemonic", "ThemesMenu.misc_description", new GreenMetalTheme());
        this.createThemesMenuItem(this.themesMenu, "Khaki Metal", "ThemesMenu.misc_mnemonic", "ThemesMenu.misc_description", new KhakiMetalTheme());
        this.createThemesMenuItem(this.themesMenu, "Ruby", "ThemesMenu.ruby_mnemonic", "ThemesMenu.ruby_accessible_description", new RubyTheme());
        return menuBar;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PeClient app = new PeClient();
                app.createAndShowGUI();
            }
        });
    }

    public JMenuItem createMenuItem(JMenu menu, String label, String mnemonic, String accessibleDescription, Action action) {
        JMenuItem mi = menu.add(new JMenuItem(label));
        mi.setMnemonic('X');
        mi.getAccessibleContext().setAccessibleDescription(accessibleDescription);
        mi.addActionListener(action);
        if (action == null) {
            mi.setEnabled(false);
        }
        return mi;
    }

    public JMenuItem createThemesMenuItem(JMenu menu, String label, String mnemonic, String accessibleDescription, DefaultMetalTheme theme) {
        JRadioButtonMenuItem mi = (JRadioButtonMenuItem)menu.add(new JRadioButtonMenuItem(label));
        this.themesMenuGroup.add(mi);
        mi.setMnemonic('X');
        mi.getAccessibleContext().setAccessibleDescription(accessibleDescription);
        mi.addActionListener(new ChangeThemeAction(this, theme));
        return mi;
    }

    public JMenuItem createLafMenuItem(JMenu menu, String label, String mnemonic, String accessibleDescription, String laf) {
        JRadioButtonMenuItem mi = (JRadioButtonMenuItem)menu.add(new JRadioButtonMenuItem(label));
        this.lafMenuGroup.add(mi);
        mi.setMnemonic('X');
        ((JMenuItem)mi).getAccessibleContext().setAccessibleDescription(accessibleDescription);
        mi.addActionListener(new ChangeLookAndFeelAction(this, laf));
        mi.setEnabled(this.isAvailableLookAndFeel(laf));
        return mi;
    }

    public void setLookAndFeel(String laf) {
        if (currentLookAndFeel != laf) {
            currentLookAndFeel = laf;
            this.themesMenu.setEnabled(laf == metal);
            this.updateLookAndFeel();
        }
    }

    public void updateLookAndFeel() {
        try {
            UIManager.setLookAndFeel(currentLookAndFeel);
            SwingUtilities.updateComponentTreeUI(this.m_fFrame);
        }
        catch (Exception ex) {
            System.out.println("Failed loading L&F: " + currentLookAndFeel);
            System.out.println(ex);
        }
    }

    protected boolean isAvailableLookAndFeel(String laf) {
        try {
            Class<?> lnfClass = Class.forName(laf);
            LookAndFeel newLAF = (LookAndFeel)lnfClass.newInstance();
            return newLAF.isSupportedLookAndFeel();
        }
        catch (Exception e) {
            return false;
        }
    }

    public ImageIcon createImageIcon(String filename) {
        String path = "/resources/images/" + filename;
        return new ImageIcon(this.getClass().getResource(path));
    }

    class ChangeThemeAction
    extends AbstractAction {
        PeClient swingset;
        DefaultMetalTheme theme;

        protected ChangeThemeAction(PeClient swingset, DefaultMetalTheme theme) {
            super("ChangeTheme");
            this.swingset = swingset;
            this.theme = theme;
        }

        public void actionPerformed(ActionEvent e) {
            MetalLookAndFeel.setCurrentTheme(this.theme);
            this.swingset.updateLookAndFeel();
        }
    }

    class ExitAction
    extends AbstractAction {
        PeClient swingset;

        protected ExitAction(PeClient swingset) {
            super("ExitAction");
            this.swingset = swingset;
        }

        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    class OkAction
    extends AbstractAction {
        JDialog aboutBox;

        protected OkAction(JDialog aboutBox) {
            super("OkAction");
            this.aboutBox = aboutBox;
        }

        public void actionPerformed(ActionEvent e) {
            this.aboutBox.setVisible(false);
        }
    }

    class AboutAction
    extends AbstractAction {
        PeClient swingset;

        protected AboutAction(PeClient swingset) {
            super("AboutAction");
            this.swingset = swingset;
        }

        public void actionPerformed(ActionEvent e) {
            if (PeClient.this.aboutBox == null) {
                AboutPanel panel = new AboutPanel(this.swingset);
                panel.setLayout(new BorderLayout());
                PeClient.this.aboutBox = new JDialog(this.swingset.m_fFrame, "AboutBox.title", false);
                PeClient.this.aboutBox.getContentPane().add((Component)panel, "Center");
                JPanel buttonpanel = new JPanel();
                buttonpanel.setOpaque(false);
                JButton button = (JButton)buttonpanel.add(new JButton(PensumContext.getRes("BUTTON_OK")));
                panel.add((Component)buttonpanel, "South");
                button.addActionListener(new OkAction(PeClient.this.aboutBox));
            }
            PeClient.this.aboutBox.pack();
            Point p = this.swingset.getLocationOnScreen();
            PeClient.this.aboutBox.setLocation(p.x + 10, p.y + 10);
            PeClient.this.aboutBox.setVisible(true);
        }
    }

    class AboutPanel
    extends JPanel {
        ImageIcon aboutimage = null;
        PeClient swingset = null;

        public AboutPanel(PeClient swingset) {
            this.swingset = swingset;
            this.aboutimage = swingset.createImageIcon("about.jpg");
            this.setOpaque(false);
        }

        public void paint(Graphics g) {
            this.aboutimage.paintIcon(this, g, 0, 0);
            super.paint(g);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.aboutimage.getIconWidth(), this.aboutimage.getIconHeight());
        }
    }

    class ChangeLookAndFeelAction
    extends AbstractAction {
        PeClient swingset;
        String laf;

        protected ChangeLookAndFeelAction(PeClient swingset, String laf) {
            super("ChangeTheme");
            this.swingset = swingset;
            this.laf = laf;
        }

        public void actionPerformed(ActionEvent e) {
            this.swingset.setLookAndFeel(this.laf);
        }
    }
}

