/*
 * Decompiled with CFR 0.152.
 */
package cz.luboss.pensum.server;

import cz.luboss.medulla.server.MeServerRMI;
import cz.luboss.pensum.common.PensumContext;
import cz.luboss.pensum.factory.PensumRMI;
import cz.luboss.pensum.gener.PeJob;
import cz.luboss.pensum.gener.PeProduct;
import cz.luboss.pensum.gener.PeRunOperation;
import cz.luboss.pensum.gener.PeRunPart;
import cz.luboss.pensum.gener.PeRunProduct;
import cz.luboss.pensum.gener.PeSessionArray;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;

public class PeServerRMI
extends MeServerRMI
implements PensumRMI {
    public PeServerRMI() throws RemoteException {
        this.m_arrSess = PeSessionArray.createInstance();
    }

    public static void main(String[] args) {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        PensumContext.CreateInstance("pensum.cfg", 0);
        try {
            String name = PensumContext.getConfParam("REMOTESERVER") + PensumContext.getConfParam("REMOTECLASS");
            PeServerRMI rmi = new PeServerRMI();
            Naming.rebind(name, rmi);
            System.out.println("Remote Message bound");
        }
        catch (Exception e) {
            System.err.println("RemoteMessage exception: " + e.getMessage());
        }
    }

    public boolean AddProduct(int nSessionID, PeJob job, PeProduct product) {
        if (this.m_bLogClient) {
            String sLog = "AddProduct(PeJob [" + job.getID() + "], PeProduct [" + product.getID() + "]";
            this.SaveLog(nSessionID, sLog);
        }
        PensumContext.StartTransaction();
        return PensumContext.GetRunMachine().AddProduct(nSessionID, job, product) && PensumContext.RollBack();
    }

    public boolean SetStavProduct(int nSessionID, PeRunProduct product, int nStav) {
        if (this.m_bLogClient) {
            String sLog = "SetStavProduct(PeRunProduct [" + product.getID() + "], nStav [" + nStav + "]";
            this.SaveLog(nSessionID, sLog);
        }
        PensumContext.StartTransaction();
        return PensumContext.GetRunMachine().SetStavProduct(nSessionID, product, nStav) && PensumContext.RollBack();
    }

    public boolean SetStavPart(int nSessionID, PeRunPart part, int nStav) {
        if (this.m_bLogClient) {
            String sLog = "SetStavPart(PeRunPart [" + part.getID() + "], nStav [" + nStav + "]";
            this.SaveLog(nSessionID, sLog);
        }
        PensumContext.StartTransaction();
        return PensumContext.GetRunMachine().SetStavPart(nSessionID, part, nStav) && PensumContext.RollBack();
    }

    public boolean SetStavOper(int nSessionID, PeRunOperation operation, int nStav) {
        if (this.m_bLogClient) {
            String sLog = "SetStavOper(PeRunOperation [" + operation.getID() + "], nStav [" + nStav + "]";
            this.SaveLog(nSessionID, sLog);
        }
        PensumContext.StartTransaction();
        return PensumContext.GetRunMachine().SetStavOper(nSessionID, operation, nStav) && PensumContext.RollBack();
    }
}

