package cz.luboss.lubosslib;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder; 
import javax.xml.parsers.DocumentBuilderFactory;  
import javax.xml.parsers.ParserConfigurationException;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;  

/**
 * Konfigurace aplikace pomoci XML konfiguracnich souboru
 * 
 * @author LKC
*/
public class LConfig {
	
	/** Pole hodnot konfigu */
	protected Map m_arrParametr = new HashMap();
	
	/** Konstruktor */
	public LConfig() {
	}

	/** 
	 * Vrati hodnotu parametru konfigurace   
	 * 
	 * @param nazev jmeno parametru
	 * @return viz popis   
	*/
	public String getParam(String nazev) {
		return (String) m_arrParametr.get(nazev);
	}

	/** 
	 * Nastavi hodnotu parametru
	 * 
	 * @param nazev jmeno parametru
   * @param value hodnota parametru
	*/
	public void setParam(String nazev, String sValue) {
		m_arrParametr.put(nazev, sValue);
	}
  
	/** 
	 * Nahraje parametr konfigurace ze souboru web.xml 
	 * 
	 * @parametr servlet s configuraci
	 * @return prubeh metody
	*/
//	public boolean loadCfg(HttpServlet trServlet) {
//		String sValue, sNazev;
//		// projedem cele pole a hledame ho v servletu
//		for (java.util.Iterator iter = m_arrParametr.keySet().iterator(); iter.hasNext();) {
//			sNazev = (String) iter.next();
//			// pokud nektera hodnota je nulova naplnime defaultne
//			sValue = trServlet.getServletConfig().getInitParameter("DATABASE_IP");
//			m_arrParametr.put(sNazev, sValue != null ? sValue : m_arrParametr.get(sNazev));
//		}
//		return true;
//	}

	/** 
	 * Nacteme data z XML souboru
	 * 
	 * @param sFileName jmeno souboru 
	 * @return prubeh metody
	*/
	public boolean loadFromXML(String sFileName) {
		try {
			// rozparsujeme file
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse( new File(sFileName) );
	
			// stahneme data 
			Element elem = document.getDocumentElement();
			NodeList arraNode = elem.getChildNodes(); 
			for (int i = 0; i < arraNode.getLength(); i++) {
				Node node = arraNode.item(i);
				// pokud je jmeno prazdne, konec
				if (node.getNodeType() == Node.TEXT_NODE) {
					continue;
				}
				// pokud tuto hodnotu ma v cfg
				String sNazev = node.getNodeName();
				if (m_arrParametr.containsKey(sNazev)) {
					String sValue = node.getFirstChild() == null ? "" : node.getFirstChild().getNodeValue();
					m_arrParametr.put(sNazev, sValue != null ? sValue : m_arrParametr.get(sNazev));
				}
			}
		} catch (SAXException sxe) {
		   // Error generated during parsing
		   Exception  x = sxe;
		   if (sxe.getException() != null)
			   x = sxe.getException();
       Logger.getLogger(LConfig.class).error("Doslo k SAXException", x);
		} catch (ParserConfigurationException pce) {
		   // Parser with specified options can't be built
       Logger.getLogger(LConfig.class).error("Doslo k ParserConfigurationException", pce);
		} catch (IOException ioe) {
		   // I/O error
       Logger.getLogger(LConfig.class).error("Doslo k IOException", ioe);
		}
	
		return true;
	}

}