
package cz.luboss.lubosslib;

// knihovny
import java.sql.Connection;
import java.sql.DriverManager;

/**
 * Univerzalni databazove pripojeni 
 *  
 * @author LKC
 *
*/ 
public class LConnection {
	
	/** Connector */
	protected Connection m_Connection = null;
	/** Konektovaci parametry */
	protected String m_sDriverName = "org.gjt.mm.mysql.Driver";
	/** Konektovaci parametry */
	protected String m_sConnectString = "jdbc:mysql://localhost/databaze_xxx?useUnicode=true&characterEncoding=windows-1250";
	/** Konektovaci parametry */
	protected String m_sUser = "non fill"; 
	/** Konektovaci parametry */
	protected String m_sPass = "non fill"; 

	/** Konstruktor */
	public LConnection() {
	}

	/** 
	 * Vytvori novy objekt 
	 *
	 * @param sDriverName jmeno databazoveho driveru
	 * @param sConnectString konektovaci string ve formatu jdbc:mysql://localhost/pensum?useUnicode=true&characterEncoding=windows-1250
	 * @param sUser uzivatel 
	 * @param sPass heslo
	 * @return novy objekt   
	*/
	public static LConnection Create(String sDriverName, String sConnectString, String sUser, String sPass) {
		LConnection pDB = new LConnection();  
	  try {
	  	// pokud neni nstaven vezmem default
			if (sDriverName != null && sDriverName.length() > 0) { 
				pDB.m_sDriverName = sDriverName;
			}
			pDB.m_sConnectString = sConnectString;
			pDB.m_sUser = sUser;
			pDB.m_sPass = sPass;
			Class.forName(pDB.m_sDriverName).newInstance();
			pDB.m_Connection = DriverManager.getConnection(pDB.m_sConnectString, pDB.m_sUser, pDB.m_sPass);
	  }
	  catch(Exception e) {
      throw new cz.luboss.lubosslib.LException(LConnection.class, "Connect Error [" + sConnectString + "]", e);
	  }
	  return pDB;
	}
	
	/** 
	 * Vrati connect do databaze
	 * 
	 * @return viz popis
	*/
	public Connection GetConect() {
	  return m_Connection;
	}
 
 	/** 
 	 * Uzavre databazi
 	 * 
 	 * @return prubeh funkce
	*/
	public boolean Close() {
		try {
			if (m_Connection != null && !m_Connection.isClosed())
				m_Connection.close();
			return true; 
		}
		catch(Exception e) {
      throw new cz.luboss.lubosslib.LException(LConnection.class, "Close DB Error.", e);
		}
	}
	
	/** 
	 * Zjisti, zda je database uzavrena
	 * 
	 * @return viz popis
	*/
	public boolean isClosed() {
		try {
			return m_Connection == null || m_Connection.isClosed();
		}
		catch(Exception e) {
      throw new cz.luboss.lubosslib.LException(LConnection.class, "isClosed DB Error.", e);
		}
	}
}
