
package cz.luboss.medulla.client.dlg;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import javax.swing.table.*;

// definice
import cz.luboss.medulla.client.view.TableSorter;
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeItem;

/**
 * Default dialog - zobrazeni pro MeItem
 * 
 * @author LKC
*/
public class McDialog extends JDialog {
	
	/** zobrazovany prvek */
	MeItem m_iTem = null;

  /** Stisknute tlacitko */
  int m_nPressButton = MeDefine.DEF_BUTTON_CANCEL;
  
	/** tabulka parametru */
	private JTable      m_tabParam   = null;
	/** Tridic */
	public  TableSorter m_tabSorter  = null;
	/** Vybrany parametr */
	public 	int 				m_nSelectedParam = 0;

	/** Tlacitko OK */
	private JButton m_okButton = new JButton("OK");
	/** Tlacitko Storno */
	private JButton m_cancelButton = new JButton("Storno");

	/** Udalost na klik mysi */
  public class GridMouseAdapter extends MouseAdapter {
		public void mouseClicked(MouseEvent e) {
		  // najdeme sloupec
		  TableColumnModel columnModel = m_tabParam.getColumnModel();
		  int viewColumn = columnModel.getColumnIndexAtX(e.getX());
		  int column = m_tabParam.convertColumnIndexToModel(viewColumn);
		  if (e.getClickCount() == 2 && column != -1 && m_iTem.getParam(m_nSelectedParam).GetCanEdit()) {
				// Create SwingSet on the default monitor
				McDlgParam dlg = McDlgParam.CreateDlg(null, m_iTem.getParam(m_nSelectedParam)); 
				dlg.showDialog();
		  }
		}
  };
	
	/** Kostruktor */
	public McDialog (Frame frame) {
		super(frame, "Vpis prvku", true);
	}
	 
	/** 
	 * Vytvori dialog
	 * 
	 * @param frame frame do ktereho patri dialog
	 * @param iTem polozka, ktera se zobrazuje
	 * @return novy dialog 
	*/
  public static McDialog CreateDlg(Frame frame, MeItem iTem) {
		McDialog dlg = new McDialog(frame);
    // nahrajeme data
		dlg.m_iTem = iTem;
//    setAlignmentX(CENTER_ALIGNMENT);
//    setAlignmentY(CENTER_ALIGNMENT);
    
    // zakazeme zmenu velikosti
		dlg.setResizable(false);

    // pripravime dialog  
		dlg.Inicialize();
		return dlg;
  }

  /** 
   * Inicializuje dialog 
   *
   * @return prubeh metody  
  */  
  public boolean Inicialize() { 
    ////////////////////////////////////////////////////////////////////////////////
    // nejdriv hlavicku
    JPanel HlavickaPane = new JPanel(); 
    HlavickaPane.setLayout(new BoxLayout(HlavickaPane, BoxLayout.X_AXIS));
    HlavickaPane.setMinimumSize(new Dimension(450, 45));
    HlavickaPane.setMaximumSize(new Dimension(450, 45));
    HlavickaPane.setPreferredSize(new Dimension(450, 45));
    HlavickaPane.setBorder(new TitledBorder(null, "", TitledBorder.LEFT, TitledBorder.TOP));
    
    JPanel PopisHeaderPane = new JPanel(); 
    PopisHeaderPane.setLayout(new BoxLayout(PopisHeaderPane, BoxLayout.Y_AXIS));
    JLabel header_01 = new JLabel("DETAIL PRVKU");
    PopisHeaderPane.add(header_01, BorderLayout.CENTER);

    JPanel CompanyPane = new JPanel(); 
    CompanyPane.setLayout(new BoxLayout(CompanyPane, BoxLayout.Y_AXIS));
    JLabel header_11 = new JLabel("Klient");
    CompanyPane.add(header_11, BorderLayout.EAST);
    JLabel header_12 = new JLabel("Copyright 2004 Luboss s.r.o");
    CompanyPane.add(header_12, BorderLayout.EAST);

	  HlavickaPane.add(Box.createRigidArea(new Dimension(10, 0)));
   	HlavickaPane.add(Box.createRigidArea(new Dimension(105, 0)));
    HlavickaPane.add(PopisHeaderPane, BorderLayout.CENTER);
   	HlavickaPane.add(Box.createRigidArea(new Dimension(67, 0)));
    HlavickaPane.add(CompanyPane, BorderLayout.EAST);
 
    ////////////////////////////////////////////////////////////////////////////////
    // Panel ATTRIBUT ARRAY PropertySheetu
    TableModel dataModel = new AbstractTableModel() {
      public int getColumnCount() { return 2; }
      public String getColumnName(int column) {
        if(column == 0)
          return "Parametr";
        else 
          return "Hodnota";
      }
      public int getRowCount() { return m_iTem.getParamCount(); }
      public Object getValueAt(int row, int col) {
				if(col == 0) 
					return MedullaContext.getRes(m_iTem.getDesc(m_iTem.getParam(row).GetName()));
				else 
					return m_iTem.getParam(row).GetString();
      }
      public boolean isCellEditable(int row, int col) {return false;}
      public Class getColumnClass(int c) {return getValueAt(0, c).getClass();}
      public void setValueAt(Object aValue, int row, int column) {}
    };
    // trideni nam nejak zlobi radsi ho vypneme
//    m_tabSorter = new TableSorter(dataModel);
//    m_tabParam = new JTable(m_tabSorter);
//    m_tabSorter.addMouseListenerToHeaderInTable(m_tabParam);
		m_tabParam = new JTable(dataModel);
		m_tabParam.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
		ListSelectionModel rowSM = m_tabParam.getSelectionModel();
		rowSM.addListSelectionListener(new ListSelectionListener() {
		  public void valueChanged(ListSelectionEvent e) {
				//Ignore extra messages.
				if (e.getValueIsAdjusting()) 
					return;
				ListSelectionModel lsm = (ListSelectionModel)e.getSource();
				if (lsm.isSelectionEmpty()) {
				  m_nSelectedParam = -1;
				} else {
					m_nSelectedParam = lsm.getMinSelectionIndex();
				}
		  }
		});
		// klikani na GRID
		GridMouseAdapter listMouseListener = new GridMouseAdapter();
		m_tabParam.addMouseListener(listMouseListener);

		JScrollPane listScroller = new JScrollPane(m_tabParam);
    listScroller.setPreferredSize(new Dimension(450, 180));
    listScroller.setAlignmentX(LEFT_ALIGNMENT);

 		JPanel PropertyPane = new JPanel(); 
		PropertyPane.add(Box.createRigidArea(new Dimension(0, 10)));
		PropertyPane.add(listScroller, BorderLayout.CENTER);
		PropertyPane.add(Box.createRigidArea(new Dimension(0, 10)));

    ////////////////////////////////////////////////////////////////////////////////
    // Panel s butonkama
    m_okButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        m_nPressButton = MeDefine.DEF_BUTTON_OK;
        setVisible(false);
      }
    });
    m_cancelButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        m_nPressButton = MeDefine.DEF_BUTTON_CANCEL;
        setVisible(false);
      }
    });
    getRootPane().setDefaultButton(m_cancelButton);

    JPanel ButtonPane = new JPanel();
    ButtonPane.setLayout(new BoxLayout(ButtonPane, BoxLayout.X_AXIS));
    ButtonPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    ButtonPane.add(Box.createHorizontalGlue());
    ButtonPane.add(m_okButton);
    ButtonPane.add(Box.createRigidArea(new Dimension(10, 0)));
    ButtonPane.add(m_cancelButton);

    ////////////////////////////////////////////////////////////////////////////////
    // a slozime to
    
    Container contentPane = getContentPane();
    contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
    contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
    contentPane.add(HlavickaPane);
		contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
    contentPane.add(PropertyPane);
    contentPane.add(ButtonPane);

/*  // Listener zatim nefunguje
    addKeyListener(new KeyListener() {
      public void keyTyped(KeyEvent e) {
      	System.out.println("Code : [" + e.getKeyCode() + "]");
      }
      public void keyPressed(KeyEvent e) {
      	System.out.println("Code : [" + e.getKeyCode() + "]");
      }
      public void keyReleased(KeyEvent e) {
      	System.out.println("Code : [" + e.getKeyCode() + "]");
      }
    });
*/
    pack();
    return true;
  }

  /** 
   * Zobrazi dialog 
   *
   * @return prubeh metody  
  */  
  public boolean showDialog() {
    // proste nevim, jak vycentrovat
    Point p = new Point(200, 75);
    setLocation(p);
 
    setVisible(true);
    return true;
  }

  /** 
   * Vrati stisknute tlacitko
   *
   * @return vis popis
  */  
  public int GetButton() {
    return this.m_nPressButton;
  }

}