
package cz.luboss.medulla.client.dlg;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;
import javax.swing.border.*;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MePodminka;
import cz.luboss.medulla.client.view.TableSorter;
import cz.luboss.medulla.client.view.McUniGrid;
import cz.luboss.medulla.factory.MeDataMachineSQL;
import cz.luboss.medulla.types.MeFieldREF;

/**
 * Default select dialog - vyber z ciselniku
 * 
 * @author LKC
*/
public class McDlgSelect extends JDialog {
	
	/** Parametr do ktereho ulozime vysledek */
	MeFieldREF m_iField = null;

	/** Pole vysledku vyberu */
	McUniGrid m_grSelect = null;

	/** Tabulka vyberu */
//	private JTable      m_tabParam   = null;
	/** Tridic */
	public  TableSorter m_tabSorter  = null;
	/** Vybrany radek */
	public 	int 				m_nSelectedRow = 0;

	/** Hodnota filtru */
	private JFormattedTextField m_fldValue = new JFormattedTextField();

	/** Tlacitko Filtruj */
	private JButton m_filterButton = new JButton("Filtruj");
	/** Tlacitko OK */
	private JButton m_okButton = new JButton("OK");
	/** Tlacitko Storno */
	private JButton m_cancelButton = new JButton("Storno");

	/** Udalost na klik mysi */
/*  public class GridMouseAdapter extends MouseAdapter {
	public void mouseClicked(MouseEvent e) {
	  // najdeme sloupec
	  TableColumnModel columnModel = m_tabParam.getColumnModel();
	  int viewColumn = columnModel.getColumnIndexAtX(e.getX());
	  int column = m_tabParam.convertColumnIndexToModel(viewColumn);
	  if (e.getClickCount() == 2 && column != -1) {
			// nastavime vybranou hodnotu
			m_iField.SetRefID(m_grSelect.GetID());
			setVisible(false);
	  }
	}
  };
*/	
	/** Kostruktor */
	public McDlgSelect (Frame frame) {
		super(frame, "Vpis prvku", true);
	}
	 
	/** 
	 * Vytvori dialog
	 * 
	 * @param frame prislusny frame 
	 * @param iField zobrazovany parametr
	 * @return novy dialog 
	*/
  public static McDlgSelect CreateDlg(Frame frame, MeFieldREF iField) {
		McDlgSelect dlg = new McDlgSelect(frame);
    // nahrajeme data
		dlg.m_iField = iField;    
//    setAlignmentX(CENTER_ALIGNMENT);
//    setAlignmentY(CENTER_ALIGNMENT);
    
    // zakazeme zmenu velikosti
		dlg.setResizable(false);

    // pripravime dialog  
		dlg.Inicialize();
		return dlg;
  }

	/** 
	 * Inicializuje dialog 
	 *
	 * @return prubeh metody  
	*/  
  public boolean Inicialize() { 
    ////////////////////////////////////////////////////////////////////////////////
    // nejdriv hlavicku
    JPanel HlavickaPane = new JPanel(); 
    HlavickaPane.setLayout(new BoxLayout(HlavickaPane, BoxLayout.X_AXIS));
    HlavickaPane.setMinimumSize(new Dimension(450, 45));
    HlavickaPane.setMaximumSize(new Dimension(450, 45));
    HlavickaPane.setPreferredSize(new Dimension(450, 45));
    HlavickaPane.setBorder(new TitledBorder(null, "", TitledBorder.LEFT, TitledBorder.TOP));
    
    JPanel PopisHeaderPane = new JPanel(); 
    PopisHeaderPane.setLayout(new BoxLayout(PopisHeaderPane, BoxLayout.Y_AXIS));
    JLabel header_01 = new JLabel("Vyber prvek");
    PopisHeaderPane.add(header_01, BorderLayout.CENTER);

	  HlavickaPane.add(Box.createRigidArea(new Dimension(10, 0)));
   	HlavickaPane.add(Box.createRigidArea(new Dimension(105, 0)));
    HlavickaPane.add(PopisHeaderPane, BorderLayout.CENTER);
 
    ////////////////////////////////////////////////////////////////////////////////
    // Panel ATTRIBUT ARRAY PropertySheetu
		m_grSelect = McUniGrid.CreateGrid(
      ((MeDataMachineSQL) MedullaContext.GetMachine()).getParamSQL().getSelectSQL(m_iField.GetRef()), 
      ((MeDataMachineSQL) MedullaContext.GetMachine()).getParamSQL().getSelectFields(m_iField.GetRef()));
	
/*    TableModel dataModel = new AbstractTableModel() {
      public int getColumnCount() { return 2; }
      public String getColumnName(int column) {
        if(column == 0)
          return "Parametr";
        else 
          return "Hodnota";
      }
      public int getRowCount() { return m_iTem.GetDescArray().length; }
      public Object getValueAt(int row, int col) {
				if(col == 0) 
					return m_iTem.GetDesc(row).GetName();
				else 
					return m_iTem.GetDesc(row).GetString();
      }
      public boolean isCellEditable(int row, int col) {return false;}
      public Class getColumnClass(int c) {return getValueAt(0, c).getClass();}
      public void setValueAt(Object aValue, int row, int column) {}
    };
    
*/    
    // trideni nam nejak zlobi radsi ho vypneme
//    m_tabSorter = new TableSorter(dataModel);
//    m_tabParam = new JTable(m_tabSorter);
//    m_tabSorter.addMouseListenerToHeaderInTable(m_tabParam);
/*		m_tabParam = new JTable(dataModel);
		m_tabParam.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);

		ListSelectionModel rowSM = m_tabParam.getSelectionModel();
		rowSM.addListSelectionListener(new ListSelectionListener() {
		  public void valueChanged(ListSelectionEvent e) {
				//Ignore extra messages.
				if (e.getValueIsAdjusting()) 
					return;
				ListSelectionModel lsm = (ListSelectionModel)e.getSource();
				if (lsm.isSelectionEmpty()) {
					m_nSelectedRow = -1;
				} else {
					m_nSelectedRow = lsm.getMinSelectionIndex();
				}
		  }
		});
		// klikani na GRID
		GridMouseAdapter listMouseListener = new GridMouseAdapter();
		m_tabParam.addMouseListener(listMouseListener);

		JScrollPane listScroller = new JScrollPane(m_tabParam);
*/
		m_grSelect.setPreferredSize(new Dimension(450, 180));
		m_grSelect.setAlignmentX(LEFT_ALIGNMENT);

 		JPanel PropertyPane = new JPanel(); 
		PropertyPane.add(Box.createRigidArea(new Dimension(0, 10)));
		PropertyPane.add(m_grSelect, BorderLayout.CENTER);
		PropertyPane.add(Box.createRigidArea(new Dimension(0, 10)));

    ////////////////////////////////////////////////////////////////////////////////
    // Panel s butonkama
    m_filterButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
      	// vyfiltrujeme pole podle zadane hodoty
				if (m_fldValue.getText().length() != 0)
					m_grSelect.FilterTable(MePodminka.createInstance("majmeno", MePodminka.OBSAHUJE, m_fldValue.getText()));
				else 
					m_grSelect.FilterTable(null);
      }
    });
		m_okButton.addActionListener(new ActionListener() {
		  public void actionPerformed(ActionEvent e) {
				m_iField.SetRefID(m_grSelect.GetID());
				setVisible(false);
		  }
		});
    m_cancelButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        setVisible(false);
      }
    });
    getRootPane().setDefaultButton(m_cancelButton);

    JPanel ButtonPane = new JPanel();
    ButtonPane.setLayout(new BoxLayout(ButtonPane, BoxLayout.X_AXIS));
    ButtonPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
		ButtonPane.add(Box.createHorizontalGlue());
		ButtonPane.add(m_fldValue);
    ButtonPane.add(Box.createHorizontalGlue());
    ButtonPane.add(m_filterButton);
		ButtonPane.add(Box.createRigidArea(new Dimension(10, 0)));
		ButtonPane.add(m_okButton);
    ButtonPane.add(Box.createRigidArea(new Dimension(10, 0)));
    ButtonPane.add(m_cancelButton);

    ////////////////////////////////////////////////////////////////////////////////
    // a slozime to
    
    Container contentPane = getContentPane();
    contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
    contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
    contentPane.add(HlavickaPane);
		contentPane.add(Box.createRigidArea(new Dimension(0, 10)));
    contentPane.add(PropertyPane);
    contentPane.add(ButtonPane);

/*  // Listener zatim nefunguje
    addKeyListener(new KeyListener() {
      public void keyTyped(KeyEvent e) {
      	System.out.println("Code : [" + e.getKeyCode() + "]");
      }
      public void keyPressed(KeyEvent e) {
      	System.out.println("Code : [" + e.getKeyCode() + "]");
      }
      public void keyReleased(KeyEvent e) {
      	System.out.println("Code : [" + e.getKeyCode() + "]");
      }
    });
*/
    pack();
    return true;
  }

	/** 
	 * Zobrazi dialog 
	 *
	 * @return prubeh metody  
	*/  
  public boolean showDialog() {
    // proste nevim, jak vycentrovat
    Point p = new Point(200, 75);
    setLocation(p);
 
    setVisible(true);
    return true;
  }

}