package cz.luboss.medulla.client.print;

import dori.jasper.engine.*;
import dori.jasper.view.JasperViewer;

// knihovna
import cz.luboss.lubosslib.LException;

// defnice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.factory.MeConnectSQL;
import cz.luboss.medulla.factory.MeDataMachineSQL;

/**
	* Tiskova mashina
	*
	* @author LKC
*/
public class McPrinter {
	
	/**
	  * Vytiskne report
	  *
	  * @param sFileName jmeno souboru se sablonou
	  * @param podminka vyberova podminka pro data
	  * @return prubeh funkce
	*/
	public static boolean PrintData(String sFileName, MePodminka podminka) {
		//  tisky umim pouze pro SQL
		if (!(MedullaContext.GetMachine() instanceof MeDataMachineSQL)) {
			throw new LException(McPrinter.class, "Tisk lze provadet pouze pro SQL pripojeni");
		}
		// Tisky
		try {
			// protoze je report v XML, musime zkompilovat
			JasperReport jm = JasperManager.compileReport(MedullaContext.getConfParam(MeConfig.PRINTDIR) + "/" + sFileName);

			java.util.Map parameters = new java.util.HashMap();
			parameters.put(podminka.GetName(), podminka.GetValue());
			// naplnime
			JasperPrint jsPrint = JasperFillManager.fillReport(jm, parameters, 
				((MeConnectSQL) MedullaContext.GetMachine().GetConnect()).GetDB().GetConect());

			// a zobrazime
			JasperViewer.viewReport(jsPrint, false);
      
      return true;
		}
		catch (Exception e) {
			throw new LException(McPrinter.class, "PePrinter Error", e);
		}
  }

}
