package cz.luboss.medulla.client.view;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.client.dlg.*;
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;

/**
 * Default grid - zobrazeni pro MeArray
 * 
 * @author LKC
*/
public abstract class McGrid extends JScrollPane {

	/** Data */	
	protected MeArray m_arrData;
	/** Filtrovaci podminka dat */
	protected MePodminka m_iPodminka;
	
	/** Nadefinovane sloupce */
	protected MeColumn[] m_arrColumn;
	/** Komletni frame, ve kterem je grid umisten */ 
	public  JFrame       		m_frView = null;
	/** Zobrazeni tabulky */
	public  JTable       		m_tabView = null;
	/** Model tabulky */
	protected McTableArray 	m_tabModel = null;

	/** Oznaceny radek */
	protected int m_nSelectedRow = -1;
	
  /** Ulozime pro reload po trideni */
  int     		m_colSort    	= 0;
  /** Ulozime pro reload po trideni */
  boolean 		m_bAscending 	= true;
  /** atributy pro trideni */
  TableSorter m_DataSorter 	= null;
  /** atributy pro trideni */
  boolean 		m_SortedTable = true;

  /**
   * Vrati vybrany prvek, pokud neni vrati null
   *  
   * @return vybrany prvek 
  */ 
  public MeItem GetSelectedItem() {
		if (m_nSelectedRow < 0) 
			return null;
		return m_arrData.getItem(m_nSelectedRow);
  }

  /**
   * Prida jednu polozku
   *  
   * @return radek nove polozky 
  */ 
	public int AddItem()  {
    throw new LException(this.getClass(), "Pro grid " + this + " neni definovana funkce AddItem");
  }
	
	/**
	 * Smaze jednu polozku
	 *
	 * @param iItem smazana polozka
	 * @return prubeh funkce
	*/ 
	public boolean DeleteItem(MeItem iItem) {
    MedullaContext.StartTransaction();
		iItem.delete();
    MedullaContext.Commit();
		return true;
  }
	
	/**
	 * Udalost na 2 klik mysi
	 *
	 * @param nCol sloupec
	 * @param nRow radek
	*/ 
	public void EventTwoClick(int nCol, int nRow) {
		// zaregistrujeme promennou
		McDialog dlg = McDialog.CreateDlg(m_frView, m_arrData.getItem(nRow)); 
		// spustime editaci    
    MedullaContext.StartTransaction();
		MedullaContext.Register(m_arrData.getItem(nRow));
		dlg.showDialog();
    // pokud stiskl OK
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
			MedullaContext.Commit();
    } else {
			MedullaContext.RollBack();
    }
	}
	
	/**
	 * Udalost na zmenu kurzoru v gridu
	 *
	 * @param e udalost
	*/ 
	public void EventChangeGrid(ListSelectionEvent e) {
		// Ignore extra messages.
		if (e.getValueIsAdjusting()) return;
		ListSelectionModel lsm = (ListSelectionModel)e.getSource();
		if (lsm.isSelectionEmpty()) {
		  m_nSelectedRow = -1;
		} else {
		  m_nSelectedRow = lsm.getMinSelectionIndex();
		}
	}

	/** Stisk klavesy INSERT */ 
	public void EventKeyInsert() {
		int nRowNew = AddItem();
		// oznacime
//		m_tabView.setRowSelectionInterval(nRowNew, nRowNew);
		ReloadTable();
	}
	
	/** Stisk klavesy DELETE */ 
	public void EventKeyDelete() {
		// pokud neni oznacen zadny radek 
		if (m_nSelectedRow < 0) 
			return;
		DeleteItem(m_arrData.getItem(m_nSelectedRow));
		// oznacime predchozi
		int nRow = m_nSelectedRow == 0 ? 0 : m_nSelectedRow - 1;
		m_tabView.setRowSelectionInterval(nRow, nRow);
		ReloadTable();
	}
	
	/** Stisk klavesy P */ 
	public void EventKeyP() {
		// pokud neni oznacen zadny radek 
		if (m_nSelectedRow < 0) 
			return;
		PrintData(true, m_nSelectedRow);
	}
	
	/** Stisk klavesy T */ 
	public void EventKeyT() {
		// pokud neni oznacen zadny radek 
		if (m_nSelectedRow < 0) 
			return;
		PrintData(false, m_nSelectedRow);
	}

	/**
	 * Udalost na stisk klavesnice
	 * 
	 * @param e udalost
	 * @param nCol sloupec
	 * @param nRow radek
	*/ 
	public void EventKeyDown(KeyEvent e, int nCol, int nRow) {
		// Pridani radku
		if (e.getKeyCode() == KeyEvent.VK_INSERT) {
			EventKeyInsert();
		}
		// umazani radku
		if (e.getKeyCode() == KeyEvent.VK_DELETE && nRow >= 0) {
			EventKeyDelete();
		}
		// tisk celeho gridu
		if ((e.getKeyCode() == KeyEvent.VK_P)) {
			EventKeyP();
		}
		// tisk jednoho radku
		if ((e.getKeyCode() == KeyEvent.VK_O)) {
			EventKeyT();
		}
	}

	/** Udalost na klik mysi */ 
  public class GridMouseAdapter extends MouseAdapter {
    public void mouseClicked(MouseEvent e) {
      // najdeme sloupec
      TableColumnModel columnModel = m_tabView.getColumnModel();
      int viewColumn = columnModel.getColumnIndexAtX(e.getX());
      int column = m_tabView.convertColumnIndexToModel(viewColumn);
		  if (e.getClickCount() == 2 && column != -1) {
				EventTwoClick(column, m_nSelectedRow);
		  }
    }
  };

  /** Udalost na zmenu kurzoru v gridu */
	public class GridChangeListener implements ListSelectionListener {
		public void valueChanged(ListSelectionEvent e) {
			EventChangeGrid(e);
		}
	}
	
  /** Udlost na stisk klvesnice */
	public class GridKeyAdapter extends KeyAdapter {
	  public void keyReleased(KeyEvent e) {
			EventKeyDown(e, m_tabView.getSelectedColumn(), m_tabView.getSelectedRow());
	  }
	};
	
	/** 
	 * Nastavi filtrovaci podminku 
	 *
	 * @param podminka podminka
	 * @return prubeh metody 
	*/
  public boolean SetPodminka(MePodminka podminka) {
	  m_iPodminka = podminka;
	  return true;
  }
   
  /** 
   * Vrati filtrovaci podminku 
   *
   * @return podminka podminka
  */
	public MePodminka GetPodminka() {
	  return m_iPodminka;
	}
	
  /** 
   * Inicializuje grid 
   *
   * @param frame frame do ktereho patri grid
   * @return prubeh metody 
  */
  public boolean Inicialize(JFrame frame) {
  	// nacteme aktualni frame
		m_frView = frame;
		 
	  // Create the table
		m_tabModel = McTableArray.CreateTable(m_arrData, m_arrColumn);

    // Bez sortovani
    if (!m_SortedTable) {
      m_tabView = new JTable(m_tabModel);
    }
    else {
      // Create the table aji se sortovanim
      m_DataSorter = new TableSorter(m_tabModel);
	  	m_tabView = new JTable(m_DataSorter);
      m_DataSorter.addMouseListenerToHeaderInTable(m_tabView);
    }
		m_tabView.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

		// klikani na GRID
		GridMouseAdapter listMouseListener = new GridMouseAdapter();
		m_tabView.addMouseListener(listMouseListener);
		// stisk klavesy
		GridKeyAdapter listKeyListener = new GridKeyAdapter();
		m_tabView.addKeyListener(listKeyListener);

    // tady zaznamename kazdy select pro pripadny dvojklik
		m_tabView.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    ListSelectionModel rowSM = m_tabView.getSelectionModel();
    rowSM.addListSelectionListener(new GridChangeListener());

    // vytvorime z dat pohled
    setViewportView(m_tabView);
    // nastavime sirky
		for (int i = 0; i < m_arrColumn.length; i++)
			m_tabView.getColumnModel().getColumn(i).setPreferredWidth(m_arrColumn[i].GetWidth());
			
    return true;
  }

  /** 
   * Filtruje tabulku podle zadaneho filtru 
   *
   * @param iPodminka podminka filtru
   * @return prubeh metody 
  */
  public boolean FilterTable(MePodminka iPodminka) {
		// Bez sortovani
		if (m_SortedTable) {
			m_colSort    = m_DataSorter.m_colSort;
			m_bAscending = m_DataSorter.m_bAscending;
		}
		// nastavime podminku
		m_iPodminka = iPodminka;
		// nacteme pole
		m_arrData.loadArray(m_iPodminka);

		// Bez sortovani
		if (m_SortedTable) {
			m_DataSorter.reallocateIndexes(); 
			m_DataSorter.sortByColumn(m_colSort, m_bAscending);
		}

		// prekreslime
	  m_tabView.revalidate();
		updateUI();

    return true;
  }

  /** 
   * Refreshne tabulku 
   *
   * @return prubeh metody 
  */
  public boolean ReloadTable() {
    return FilterTable(m_iPodminka);
  }

  /** 
	 * Vytiskneme tabulku
	 * 
   * @param bAllRows pokud se ma tisknout cela tabulka
   * @param nRow jeden radek
   * @return prubeh metody 
  */
	public boolean PrintData(boolean bAllRows, int nRow) {
		String[] options = {MedullaContext.getRes("BUTTON_OK")};
		JOptionPane panel = new JOptionPane (
			MedullaContext.getRes("ERROR_CHYBI_TISK_SESTAVA"), JOptionPane.ERROR_MESSAGE,0, null, options); 		 
		JDialog dlg = panel.createDialog(null, MedullaContext.getRes("DLG_CHYBI_TISK_SESTAVA_NADPIS"));
		dlg.setModal(true); 
		dlg.setVisible(true);
		return true;
  }

}
