package cz.luboss.medulla.client.view;

import java.util.ArrayList;

import javax.swing.event.ListSelectionEvent;
import javax.swing.JFrame;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.data.MeItem;
import cz.luboss.medulla.common.MePodminka;
import cz.luboss.medulla.types.*;

/**
 * Default parent grid - rodicovsky grid standardniho gridu
 * 
 * @author LKC 
*/
public abstract class McParentGrid extends McGrid {

	/** Podrizene tabulky */
	protected ArrayList m_arrChild = new ArrayList();

	/**
	 * Udalost na 2 klik mysi
	 *
	 * @param nCol sloupec
	 * @param nRow radek
	*/ 
	public void EventTwoClick(int nCol, int nRow) {
		// zavolama nadrazeny listener
		super.EventTwoClick(nCol, nRow);
		if (m_nSelectedRow != -1) {
			// pretridime podrizene tabulky
			FilterTableChild(m_arrData.getItem(nRow));
		}
	}

	/**
	 * Udalost na zmenu kurzoru v gridu
	 *
	 * @param e udalost
	*/ 
	public void EventChangeGrid(ListSelectionEvent e) {
		// zavolama nadrazeny listener
		super.EventChangeGrid(e);
		if (m_nSelectedRow != -1) {
			// pretridime podrizene tabulky podle vybraneho radku
			FilterTableChild(m_arrData.getItem(m_nSelectedRow));
		}
	}
	
  /** 
   * Prida podrizenou tabulku 
   *
   * @param iChild podrizeny grid
   * @param iPodminka podminka, kterou se filtruje
   * @return prubeh funkce
  */
  public boolean AddTableChild(McGrid iChild, MePodminka iPodminka) {
  	// otestujeme zda sloupec na ktery je navazan child grid je typu REF nebo INT
		if (m_arrData.size() != 0 
			&& m_arrData.getItem(0).getParam(iPodminka.GetName()).GetType() != MeField.REF
			&& m_arrData.getItem(0).getParam(iPodminka.GetName()).GetType() != MeField.INTEGER){
			throw new LException(this.getClass(), "Child grid se da vlozit pouze pro sloupec stypu MeFieldREF nebo MeFieldINT");
		}
		iChild.SetPodminka(iPodminka);
		m_arrChild.add(iChild);
		return true;
  }

  /** 
   * Filtruje podrizene tabulky podle zadaneho filtru 
   * 
   * @param iItem objekt pro nehoz se vyfiltruje podrizena tabulka
   * @return prubeh funkce
  */
  protected boolean FilterTableChild(MeItem iItem) {
  	MePodminka iChangePodminka;
	  // a totez pro deti
	  for (int i = 0; i < m_arrChild.size(); i++) {
			// najdeme podminku potomka
			iChangePodminka = ((McGrid) m_arrChild.get(i)).GetPodminka();
	  	// najdeme hodnotu podle ktere budeme filtrovat
			String sID = String.valueOf(iItem.getParam(iChangePodminka.GetName()).GetInt());
			
			// a zmenime
			iChangePodminka.ChangeValue(sID);
			// a reloadujeme
			((McGrid) m_arrChild.get(i)).ReloadTable();
	  }

		return true;
  }

	/** 
	 * Inicializuje grid 
	 *
	 * @param frame frame, do ktereho patri grid 
	*/
  public boolean Inicialize(JFrame frame) {
		super.Inicialize(frame);
		return true;
  }
  
}
