
package cz.luboss.medulla.common;

/**
	* Obecna filtrovaci podminka
	*
	* @author LKC
*/
public class MePodminka implements java.io.Serializable {
	/** vztah rovno */
	public final static int ROVNO = 0;
	/** vztah nerovno */
	public final static int NEROVNO = 1;
	/** vztah vetsi */
	public final static int VETSI = 2;
	/** vztah mensi */
	public final static int MENSI = 3;
	/** vztah vetsi nebo rovno */
	public final static int VETSIROVNO = 4;
	/** vztah mensi nebo rovno */
	public final static int MENSIROVNO = 5;
	/** vztah obsahuje text */
	public final static int OBSAHUJE = 6;
	
	/** jmeno parametru podminky */
	protected String sName;
	/** vztah mezi jmenem a hodnotou */
	protected int nVztah;
	/** hodnota podminky */
	protected String sValue;
	
	/** nasledujici podminka */
	protected MePodminka nextPodminka;
	/** predchozi podminka */
	protected MePodminka prewPodminka;

	/** Konstruktor */
	public MePodminka() {
	}

	/**
		* Vytvori novou podminku s parametry
		*
		* @param sName jmeno podminky
		* @param nVztah vztah mezi jmenem a hodnotou
		* @param sValue hodnota podminky
		* @return nova podminka 
  */
	public static MePodminka createInstance(String sName, int nVztah, String sValue) {
		MePodminka item = new MePodminka(); 
		item.sName = sName;
		item.nVztah = nVztah;
		item.sValue = sValue;
		return item; 
	}

	/**
		* Vytvori novou podminku s parametry
		*
		* @param sName jmeno podminky
		* @param sValue hodnota podminky
		* @return nova podminka 
  */
	public static MePodminka createInstance(String sName, String sValue) {
		return MePodminka.createInstance(sName, MePodminka.ROVNO, sValue);
	}
 
	/**
		* Vytvori novou podminku s parametry
		*
		* @param sName jmeno podminky
		* @param nID hodnota podminky jako int
		* @return nova podminka 
  */
	public static MePodminka createInstance(String sName, int nID) {
		return MePodminka.createInstance(sName, MePodminka.ROVNO, String.valueOf(nID));
	}

	/**
		* Funkce zmeni hodnotu podminky
		*
		* @param sValue nova hodnota podminky
		* @return prubeh funkce 
  */
	public boolean ChangeValue(String sValue) {
		if (sValue == null)
			return false;
		this.sValue = sValue;
		return true;
	}

	/**
		* Funkce vrati jmeno podminky
		*
		* @return viz popis 
  */
	public String GetName() {
		return sName;
	}

	/**
		* Funkce vrati hodnotu podminky
		*
		* @return viz popis 
  */
	public String GetValue() {
		return sValue;
	}
	
	/**
		* Funkce spojujici dve podminky
		*
		* @param podminka podminka pro spojeni
		* @return nova podminka spojujici obe 
  */
	public MePodminka and(MePodminka podminka) {
		this.nextPodminka = podminka;
		podminka.prewPodminka = this;
		return podminka; 
	}
 	
	/**
		* Vrati prvni podminku
		*
		* @return prvni podminka v rade 
  */
	public MePodminka GetFirst() {
		if (this.prewPodminka == null)
			return this;
		else
			return this.prewPodminka.GetFirst();
	}
 	
	/**
		* Vrati posledni podminku
		*
		* @return posledni podminka v rade 
  */
	public MePodminka GetLast() {
		if (this.IsLast())
			return this;
		else
			return this.prewPodminka.GetFirst();
	}

	/**
		* Zjisti, zda je podminka prvni
		*
		* @return viz popis 
  */
	public boolean IsFirst() {
		return this.prewPodminka == null;
	}
 	
	/**
		* Zjisti, zda je podminka posledni
		*
		* @return viz popis 
  */
	public boolean IsLast() {
		return this.nextPodminka == null;
	}

	/**
		* Vrati SQL dotaz pro vsechny podminky v rade
		*
		* @return SQL dotaz 
  */
	public String GetSQLQuery() {

		MePodminka podAktual = GetFirst();
		String sSQLQuery = podAktual.GetSQLQueryOne();
		// projedem vsechny podminky
		while(!podAktual.IsLast()) {
			podAktual = podAktual.nextPodminka;
			sSQLQuery += " AND " + podAktual.GetSQLQueryOne();
		}
		
		return sSQLQuery;
	}

	/**
		* Vrati SQL dotaz pouze pro tuto podminku
		*
		* @return SQL dotaz 
  */
	public String GetSQLQueryOne() {
		String sSQLQuery = "";
		sSQLQuery += " " + this.sName + "  ";
		// vratime vztah
		switch (this.nVztah) {
			case MePodminka.ROVNO : sSQLQuery += " = "; break;
			case MePodminka.NEROVNO : sSQLQuery += " <> "; break;
			case MePodminka.MENSI : sSQLQuery += " < "; break;
			case MePodminka.VETSI : sSQLQuery += " > "; break;
			case MePodminka.MENSIROVNO : sSQLQuery += " =< "; break;
			case MePodminka.VETSIROVNO : sSQLQuery += " => "; break;
			case MePodminka.OBSAHUJE : sSQLQuery += " LIKE "; break;
		}
		sSQLQuery += " '" + this.sValue + "' ";
		return sSQLQuery;
	}

}
