
package cz.luboss.medulla.data;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.factory.MeDataMachineSQL;
import cz.luboss.medulla.types.*;

/**
	* Zakladni trida pro vsechny polozky <p>
	*
	* @author LKC
*/
public abstract class MeItem implements java.io.Serializable {
 
  /** Stav objektu */
	protected int m_nStatus = MeDefine.DEF_STATUS_NEW;

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
  public abstract int getFieldID();
  
	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public abstract int getID();

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public abstract String getNameID();

	/**
	  * Vytvori nove ID 
	  *
	  * @return vis popis
	*/
	public boolean addSequenceID() {
		// parametr s ID je vzdy INT
		((MeFieldINT) this.getParam(this.getFieldID())).SetInt(
      MedullaContext.GetMachine().AddSequenceID(MedullaContext.GetSession().getID(), this));
		return true;
	}

  /**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public abstract boolean setData(MeItem zdroj);

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public abstract int getParamCount();
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public abstract MeField getParam(int nRow);

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public abstract MeField getParam(String sName);

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public abstract String getDesc(String sName);

  /**
	  * Vrati status objektu
	  *
	  * @param status objektu
	*/
	public int getStatus() {
    return m_nStatus;
	}

  /**
	  * Nastavi status prvku jako novy, loadovay nebo smazany 
    * !!! S touto funkci velmi opatrne, jelikoz ovlivnuje praci s transakci ...
	  *
	  * @param nStatus
	*/
	public void setStatus(int nStatus) {
		if (m_nStatus != MeDefine.DEF_STATUS_NEW && m_nStatus != MeDefine.DEF_STATUS_LOAD
      && m_nStatus != MeDefine.DEF_STATUS_DELETED) {
    	throw new LException(this.getClass(), "Status tohoto typu [" + nStatus + "] neexistuje!"); 
    }
    m_nStatus = nStatus;
	}

  /**
	  * Vrati true, pokud je novy, nezalozeny do databaze
	  *
	  * @return viz popis
	*/
	public boolean isNew() {
		return m_nStatus == MeDefine.DEF_STATUS_NEW;
	}

  /**
	  * Vrati true, pokud je nahrany z databaze
	  *
	  * @return viz popis
	*/
	public boolean isLoaded() {
		return m_nStatus == MeDefine.DEF_STATUS_LOAD;
	}

	/**
	  * Vrati true, pokud je smazany
	  *
	  * @return viz popis
	*/
	public boolean isDeleted() {
		return m_nStatus == MeDefine.DEF_STATUS_DELETED;
	}

  /**
	  * Vrati true, pokud je ID jiz vygenerovano
	  *
	  * @return viz popis
	*/
	public boolean isIDGenerate() {
		return getID() != MeDefine.DEF_NEW_ITEM_ID;
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public abstract String generateKod();

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce z externiho ID
	  *
    * @param nID ID objekt
	  * @return prubeh metody
	*/
	public String generateKod(int nID) {
    return this.getClass().getName() + "  " + nID;
  }

  /**
	  * Nahraje objekt podle podminky
	  *
	  * @param podminka podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean load(int nID) {
		// naplnime pole parametru
		return MedullaContext.LoadData(this, nID);
  }
	
	/**
	  * Znovu nacte prvek
	  *
	  * @return prubeh metody
	*/
	public boolean reload() {
    // pokud je objekt smazan hodime exception
    if (isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    return this.load(this.getID());
	}

	/**
	  * Vymaze prvek
	  *
	  * @return prubeh metody
	*/
	public boolean delete() {
		// rovnou zaregistrujeme
		MedullaContext.Register(this);
		MedullaContext.DeleteData(this, this.getID());
    return true;
	}
}
