package cz.luboss.medulla.factory;

import java.rmi.Naming;
import java.rmi.RMISecurityManager;

/**
	* Pripojeni k datovemu zdroji RMI
	*
	* @author LKC
*/
public class MeConnectRMI implements MeConnect {
	
	/** Connector na server RMI */
	protected MedullaRMI m_dtConnectRMI; 
	/** Adresa RMI serveru */
	protected String m_sRMIServer; 
	/** Jmeno tridy s RMI interfacem */
	protected String m_sRMIClassName; 

	/** 
	 * Vytvori novy objet 
	 * 
	 * Adresa RMI serveru
	 * @param sRMIServer jmeno RMI serveru
	 * @param sRMIClassName jmeno tridy s RMI interfacem
	 * @return viz popis
	*/
	public static MeConnectRMI CreateInstance(String sRMIServer, String sRMIClassName) {
		MeConnectRMI machine = new MeConnectRMI();
		machine.m_sRMIServer = sRMIServer; 
		machine.m_sRMIClassName = sRMIClassName; 
		return machine;  
	}

	/** 
	 * Vrati connector na server RMI 
	 * 
	 * @return connector
	*/
	public MedullaRMI GeRMI() {
		// pokud spojeni existuje, vratime ho
		if (m_dtConnectRMI != null) {
			return m_dtConnectRMI; 
		}
		
		// nastavime manazer bezpecnosti
		RMISecurityManager manager = new RMISecurityManager();
		String name = "";
		if (System.getSecurityManager() == null) {
			System.setSecurityManager(manager);
		}
		try { 
			// assumes remote object is another process running on this machine
			name = m_sRMIServer + m_sRMIClassName;
			m_dtConnectRMI = (MedullaRMI) Naming.lookup(name);
		} catch (Exception e) {
    	throw new cz.luboss.lubosslib.LException(this.getClass(), "Nepodarilo se pripojit k RMI severu [" 
        + m_sRMIServer + "]");
		}
		return m_dtConnectRMI; 
	}

}
