
package cz.luboss.medulla.factory;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Collection;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.data.MeItem;
import cz.luboss.medulla.data.MeSession;

/**
 *  RMI interface pro persistenci objektu
 *
 *@author    LKC
 */
public interface MedullaRMI extends Remote {

	/**
	 *  Otestuje rozhrani RMI
	 *
	 *@param  testing              testovaci objekt
	 *@return                      testovaci objekt
	 *@exception  RemoteException  Description of Exception
	 */
	public MeDataTest sendTest(MeDataTest testing) throws RemoteException;


	/**
	 *  Zaloguje uzivatele a vrati jeho session
	 *
	 *@param  sLogin               login uzivatele
	 *@param  sPassword            heslo uzivatele
	 *@return                      vytvorena Session
	 *@exception  RemoteException  Description of Exception
	 */
	public MeSession LoadSession(String sLogin, String sPassword) throws RemoteException;


	/**
	 *  Zjisti zda je session platna
	 *
	 *@param  nSessionID           ID session, ktera se testuje
	 *@return                      vis popis
	 *@exception  RemoteException  Description of Exception
	 */
	public boolean IsValidSession(int nSessionID) throws RemoteException;


	/**
	 *  Vrati vsechny aktualni session
	 *
	 *@return    vis popis
	 */
	public MeArray GetActualSessions() throws RemoteException;

	/**
	 *  Nahraje data do objektu
	 *
	 *@param  nSessionID  Session
   *@param  item prvek do nehoz se ma nahravat
	 *@param  nID ID prvku pro nacteni
	 *@return             nacteny prvek
	*/
	public MeItem LoadDataRMI(int nSessionID, MeItem item, int nID) throws RemoteException;

  /**
	 *  Nahraje data do pole
	 *
	 *@param  nSessionID  Session
	 *@param  arrayItem   pole do ktereho nahravame
	 *@param  podminka    vyberova podminka
	 *@return             pole objektu, ktery nacitame
	*/
	public MeArray LoadArrayRMI(int nSessionID, MeArray arrayItem, MePodminka podminka) throws RemoteException;

	/**
	 *  Ulozi data transakce
	 *
	 *@param  nSessionID  Session
	 *@param  arrTransData data transakce, kterou ukladame
	 *@return             prubeh funkce
	 */
	public boolean SaveTrans(int nSessionID, Collection arrTransData) throws RemoteException;

	/**
	 *  Prideli ID novemu prvku
	 *
	 *@param  nSessionID  Session
	 *@param  item prvek pro nehoz mame vygenerovat nove ID
	 *@return nove ID
	*/
	public int AddSequenceID(int nSessionID, MeItem item) throws RemoteException;

}
