package cz.luboss.medulla.server;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.*;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.data.MeItem;
import cz.luboss.medulla.data.MeSession;
import cz.luboss.medulla.factory.MedullaRMI;

/**
 *  RMI server pro aplikaci Medulla
 *
 *@author    LKC
 */
public class MeServerRMI extends UnicastRemoteObject implements MedullaRMI {

  /** Signal zda se ma logovat */
  public boolean m_bLogClient = false;
  
  /** Pole prihlasenych uzivatelu */
	public MeArray m_arrSess;

	/**
	 *  Konstruktor
	 *
	 *@exception  RemoteException  Description of Exception
	 */
	public MeServerRMI() throws RemoteException {
		super();
	}

  /**
	 * Ulozi log do uzivatelske session
	 *
   * @param nSessionID ID session
   * @param sLog text pro ulozeni
	 * @return   viz popis
	*/
	public boolean SaveLog(int nSessionID, String sLog) {
    // natahnem session
    MeSession sess = (MeSession) m_arrSess.getItemByID(nSessionID);
		if (sess == null) {
			return false;
		}
 		return sess.saveLog(sLog);
	}

	/**
	 *  Otestuje rozhrani RMI
	 *
	 *@param  message  testovaci objekt
	 *@return          testovaci objekt
	 */
	public MeDataTest sendTest(MeDataTest message) {
		return MedullaContext.GetMachine().sendTest(message);
	}


	/**
	 * Zaloguje uzivatele a vrati jeho session
	 *
	 * @param  sLogin     login uzivatele
	 * @param  sPassword  heslo uzivatele
	 * @return            vytvorena Session
	 */
	public MeSession LoadSession(String sLogin, String sPassword) {
    
    // vytvorime a ulozime novou transakci
    MedullaContext.StartTransaction();
    MeSession sesna = MedullaContext.GetMachine().LoadSession(sLogin, sPassword);
    m_arrSess.addItem(sesna);
    MedullaContext.Commit();

    // nastavime logovani
    m_bLogClient = MedullaContext.getConfParam(MeConfig.DEBUG_CLIENT).equals("TRUE");
		return sesna;
	}

	/**
	 *  Vrati vsechny aktualni session
	 *
	 *@return    vis popis
	 */
	public MeArray GetActualSessions() {
		return m_arrSess;
	}

	/**
	 * Zjisti zda je session platna
	 *
	 * @param  nSessionID  ID session, ktera se testuje
	 * @return             vis popis
	 */
	public boolean IsValidSession(int nSessionID) {
		// TODO: zatim vzdy true, az udelam pole session
		return true;
	}

	/**
	 *  Nahraje data do objektu
	 *
	 *@param  nSessionID  Session
   *@param  item prvek do nehoz se ma nahravat
	 *@param  nID ID prvku pro nacteni
	 *@return             nacteny prvek
	*/
	public MeItem LoadDataRMI(int nSessionID, MeItem item, int nID) {
    // ulozime log
    if (m_bLogClient) {
      String sLog = "LoadDataRMI(" + item.getClass().getName() + ", [" + nID + "]";
      SaveLog(nSessionID, sLog);
    }
    
    // pokracujeme
		if (MedullaContext.GetMachine().LoadData(nSessionID, item, nID)) {
			return item;
		} else {
			return null;
		}
	}

  /**
	 *  Nahraje data do pole
	 *
	 *@param  nSessionID  Session
	 *@param  arrayItem   pole do ktereho nahravame
	 *@param  podminka    vyberova podminka
	 *@return             pole objektu, ktery nacitame
	*/
	public MeArray LoadArrayRMI(int nSessionID, MeArray arrayItem, MePodminka podminka) {
    // ulozime log
    if (m_bLogClient) {
      String sLog = "LoadArrayRMI(" + arrayItem.getClass().getName() + ", " 
        + (podminka == null ? "null" : podminka.getClass().getName()) + "[" 
        + (podminka == null ? "null" : podminka.GetSQLQuery()) + "])";
      SaveLog(nSessionID, sLog);
    }
    
    // pokracujeme
		if (MedullaContext.GetMachine().LoadArray(nSessionID, arrayItem, podminka)) {
			return arrayItem;
		} else {
			return null;
		}
	}

	/**
	 *  Ulozi data transakce
	 *
	 *@param  nSessionID  Session
	 *@param  arrTransData data transakce, kterou ukladame
	 *@return             prubeh funkce
	*/
	public boolean SaveTrans(int nSessionID, Collection arrTransData) {
    // ulozime log
    if (m_bLogClient) {
      SaveLog(nSessionID, "SaveTrans(" + arrTransData.size() + ")");
    }
    // pokracujeme
		return MedullaContext.GetMachine().SaveTrans(nSessionID, arrTransData);
	}

	/**
	 *  Prideli ID novemu prvku
	 *
	 *@param  nSessionID  Session
	 *@param  item prvek pro nehoz mame vygenerovat nove ID
	 *@return nove ID
	*/
	public int AddSequenceID(int nSessionID, MeItem item) {
    // ulozime log
    if (m_bLogClient) {
      SaveLog(nSessionID, "AddSequenceID(" + item.getClass().getName() + ")");
    }
    // pokracujeme
		return MedullaContext.GetMachine().AddSequenceID(nSessionID, item);
	}

}
