
package cz.luboss.medulla.types;

/**
	* Obecny datovy typ
	*
	* @author LKC
*/
public abstract class MeField implements java.io.Serializable {
	
	/** Datovy typ cele cislo */ 
	public static final int INTEGER = 0;
	/** Datovy typ desetinne cislo */ 
	public static final int FLOAT 	= 1;
	/** Datovy typ datum */ 
	public static final int DATE 		= 2;
	/** Datovy typ retezec */ 
	public static final int STRING 	= 3;
	/** Datovy typ odkaz na jiny objekt */ 
	public static final int REF 		= 4;

	/** jmeno zaznamu */ 
	protected String m_sName;
	/** signal zda se muze editovat */
	protected boolean m_bCanEdit;

	/**
	 * Vrati jmeno
	 *
	 * @return jmeno polozky
	*/
	public String GetName() {
		return m_sName;
	}

	/**
	 * Vrati signal, zda se muze editovat
	 *
	 * @return signal persistence
	*/
	public boolean GetCanEdit() {
		return m_bCanEdit;
	}
	
	/**
	 * Vrati ID typu
	 *
	 * @return ID typu
	*/
	public abstract int GetType();

	/**
	 * Nastavi hodnotu z retezce
	 *
	 * @param sParam retezec
	 * @return prubeh funkce
	*/
	public abstract boolean SetString(String sParam);

	/**
	 * Vrati hodnotu jako String
	 *
	 * @return viz popis
	*/
	public abstract String GetString();
	
	/**
	 * Vrati hodnotu jako String - pro SQL
	 *
	 * @return viz popis
	*/
	public abstract String GetSQLString();

	/**
	 * Vrati hodnotu jako String - naformatovanou
	 *
	 * @param sFormat formatovaci retezec
	 * @return viz popis
	*/
	public abstract String GetFormatString(String sFormat);

	/**
	 * Vrati hodnotu jako cele cislo
	 *
	 * @return cele cislo
	*/
	public abstract int GetInt();

}
