
package cz.luboss.medulla.types;

// knihovna
import cz.luboss.lubosslib.LException;

/**
	* Datovy typ desetinne cislo
	*
	* @author LKC
*/
public class MeFieldFLOAT extends MeField{
	
	/** parametr */
	protected float fValue = 0; 

	/** Konstruktor */
	protected MeFieldFLOAT() {
	}

	/**
	 * Vytvari novy objekt i s hodnotami
	 *
	 * @param sName jmeno polozky
	 * @param fParam hodnota parametru
	 * @param bCanEdit signal, zda se muze editovat
	 * @return novy objekt
	*/
	public static MeFieldFLOAT createInstance(String sName, float fParam, boolean bCanEdit) {
		MeFieldFLOAT field = new MeFieldFLOAT();
		field.m_sName = sName;
		field.fValue = fParam;
		field.m_bCanEdit = bCanEdit;
		return field;
	}

	/**
	 * Vrati ID typu
	 *
	 * @return ID typu
	*/
	public int GetType() {
		return MeField.FLOAT;
	}

	/**
	 * Nastavi hodnotu parametru
	 *
	 * @param fParam hodnota parametru
	 * @return prubeh funkce
	*/
	public boolean SetFloat(float fParam) {
		fValue = fParam;
		return true;
	}

	/**
	 * Vrati hodnotu parametru
	 *
	 * @return viz popis
	*/
	public float GetFloat() {
		return fValue;
	}

	/**
	 * Nastavi hodnotu z retezce
	 *
	 * @param sParam retezec
	 * @return prubeh funkce
	*/
	public boolean SetString(String sParam) {
		try {
			fValue = Float.parseFloat(sParam);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	/**
	 * Vrati hodnotu jako String
	 *
	 * @return viz popis
	*/
	public String GetString() {
		return String.valueOf(fValue);
	}
	
	/**
	 * Vrati hodnotu jako String - pro SQL
	 *
	 * @return viz popis
	*/
	public String GetSQLString() {
		return String.valueOf(fValue);
	}

	/**
	 * Vrati hodnotu jako String - naformatovanou
	 *
	 * @param sFormat formatovaci retezec
	 * @return viz popis
	*/
	public String GetFormatString(String sFormat) {
		return String.valueOf(fValue);
	}

	/**
	 * Vrati hodnotu jako cele cislo
	 *
	 * @return cele cislo
	*/
	public int GetInt() {
		throw new LException(this.getClass(), "Typ Integer neni mozne vratit jako Integer.");
	}

}
