////////////////////////////////////////////////////////////////////////////
//
//  Aplikace : Pensum
//  Soubor   : Pensum.java
//  Popis    : Vroba BMB
//  Create   : 28.1.2004 LC 
//
////////////////////////////////////////////////////////////////////////////

package cz.luboss.pensum.client;

////////////////////////////////////////////////////////////////////////////

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JPanel;
//import javax.swing.JScrollPane;
//import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

/*import view.JWeaverTabbedPane;
import view.JWeaverWork;
import view.JWeaverDoch;

import data.JWorkData;

import common.JWeaverToolBar;
import common.JWeaverSplash;
import common.JWeaverUtil;
*/

// definice
//import cz.luboss.medulla.common.MePodminka;
//import cz.luboss.medulla.common.MeDataTest;
//import cz.luboss.medulla.factory.MeDataMachineRMI;
//import cz.luboss.medulla.types.MeColumn;
//import cz.luboss.medulla.common.MeConfig;
import cz.luboss.medulla.common.MeDefine;
//import cz.luboss.medulla.factory.MeConnectSQL;
//import cz.luboss.medulla.view.MeDialog;
//import cz.luboss.medulla.view.MeGrid;

// implmentace
import cz.luboss.pensum.client.panel.*;
import cz.luboss.pensum.gener.*;
//import cz.luboss.pensum.conf.PeConnectRMI;
//import cz.luboss.pensum.conf.PeParametr;
import cz.luboss.pensum.common.PensumContext;
import cz.luboss.pensum.factory.PeDataMachineSQL;
//import cz.luboss.pensum.data.*;
//import cz.luboss.pensum.view.*;

////////////////////////////////////////////////////////////////////////////

public class TestPeClient extends JPanel {
// Atributes

  // defaultni velikost  
  private static final int PREFERRED_WIDTH = 800;
  private static final int PREFERRED_HEIGHT = 550;

  // parametruy pro okno
  private static int numSSs = 0;
  private static Vector swingSets = new Vector();

  // Used only if app is an applet 
//  private WeaverApplet m_applet = null;
  // Used only if app is an application 
  private JFrame m_frame = null;

  // pole argumentu
  static String[] m_args = null;

  // splash 
//  private JWeaverSplash     m_splashScreen  = null;

  // Tool Bar
//  private JWeaverToolBar    m_ToolBarPanel  = null;

  // popis okna
//  private JWeaverMenu       m_MenuBar       = null;
//  private JWeaverTabbedPane m_TabbedPane    = null;
//	private zzz_smazat_JPensumWork       	m_PensumPanel = null;
//	private JWeaverDoch       m_DochazkaPanel = null;

  // data pro workflow
//  public JWorkData m_WorkData = new JWorkData();

  // pomocna trida
//  public JWeaverUtil m_rtUtil = null;
  
////////////////////////////////////////////////////////////////////////////////
// Metody

  // construktor jako aplet
/*  public Weaver(WeaverApplet applet) {
    this(applet, null);
  }
*/
  // construktor jako app
  public TestPeClient(GraphicsConfiguration gc) {
  	// Note that the applet may null if this is started as an application
//  	this.m_applet = applet;

    // nastavime pomocnou tridu
//    m_rtUtil = new JWeaverUtil(m_applet, m_args);
//    m_WorkData.SetParam(this, m_rtUtil);
    
    // Create Frame here for app-mode so the splash screen can get the
    // GraphicsConfiguration from it in createSplashScreen()
//    if (!isApplet()) {
      m_frame = createFrame(gc);
//    }

  	// setLayout(new BorderLayout());
  	setLayout(new BorderLayout());
  	// set the preferred size of the demo
  	setPreferredSize(new Dimension(PREFERRED_WIDTH,PREFERRED_HEIGHT));

    // vytvorime Splash
//    if(!isApplet()) {
//      m_splashScreen = new JWeaverSplash(getFrame(), m_rtUtil);
//    }

   	// do the following on the gui thread
  	SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        // zobrazime Splash
//        if(!isApplet())
//      		m_splashScreen.ShowSplash();
	    }
    });

    // nahraje cele okno
  	InitializeWindow();

		m_frame.pack();

		showWeaver();
 
/*  	SwingUtilities.invokeLater(new Runnable() {
  	  public void run() {
 		    showWeaver();
        // zavrem Splash
        if(!isApplet()) {
  		    m_splashScreen.HideSplash();
  	      m_splashScreen = null;
        }
	    }
  	});
*/
  }
/*
  // otestuje zda se jedna o applet
  public boolean isApplet() {
    return (m_applet != null);
  }

  // vrati na nej parametr
  public WeaverApplet getApplet() {
  	return m_applet;
  }
*/
  // Returns the frame instance
  public JFrame getFrame() {
  	return m_frame;
  }

  // zobrazi okno aplikace 
  public void showWeaver() {
	  if(/*!isApplet() && */getFrame() != null) {
	    // put swingset in a frame and show it
	    JFrame f = getFrame();
	    f.setTitle("Pensum");
	    f.getContentPane().add(this, BorderLayout.CENTER);
	    f.pack();

	    Rectangle screenRect = f.getGraphicsConfiguration().getBounds();
      Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(f.getGraphicsConfiguration());

      // Make sure we don't place the demo off the screen.
      int centerWidth = screenRect.width < f.getSize().width ?
              screenRect.x :
              screenRect.x + screenRect.width/2 - f.getSize().width/2;
      int centerHeight = screenRect.height < f.getSize().height ?
              screenRect.y :
              screenRect.y + screenRect.height/2 - f.getSize().height/2;

      centerHeight = centerHeight < screenInsets.top ? screenInsets.top : centerHeight;

      f.setLocation(centerWidth, centerHeight);
	    f.setVisible(true);
      numSSs++;

      swingSets.add(this);
  	} 
  }

  // hlavni funkce pro app
  public static void main(String[] args) {
    // ulozime si pole argumentu
    m_args = args;
    // Create SwingSet on the default monitor
  	TestPeClient app = new TestPeClient(GraphicsEnvironment.
                                  getLocalGraphicsEnvironment().
                                  getDefaultScreenDevice().
                                  getDefaultConfiguration());
    };

  // pro samostatnou aplikacku vytvori okno
  public static JFrame createFrame(GraphicsConfiguration gc) {
  	JFrame frame = new JFrame(gc);
    if (numSSs == 0) {
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
    else {
	    WindowListener l = new WindowAdapter() {
	      public void windowClosing(WindowEvent e) {
          numSSs--;
          swingSets.remove(this);
	      }
  	  };
  	  frame.addWindowListener(l);
    }
	  return frame;
  }

  // nahraje cele okno
  public void InitializeWindow() {
    //...create the components to go into the frame...
   	JPanel top = new JPanel();
  	top.setLayout(new BorderLayout());
  	add(top, BorderLayout.NORTH);

    // menu
/*   	m_MenuBar = new JWeaverMenu();
    m_MenuBar.CreateMenu();
    top.add(m_MenuBar, BorderLayout.NORTH);
*/
    // status bar
  	JTextField statusField = new JTextField("Pensum 0.1");
  	statusField.setEditable(false);
  	add(statusField, BorderLayout.SOUTH);

		// nastavime Connect SQL
		PeDataMachineSQL dataMachine = PeDataMachineSQL.CreateInstance(PeParamSQL_MySQL.createInstance());
//		MeConnectSQL dbConnect = MeConnectSQL.CreateInstance(conf.GetParam(MeConfig.DRIVERNAME), 
//			conf.GetParam(MeConfig.CONNECTSTRING), conf.GetParam(MeConfig.USERDB), conf.GetParam(MeConfig.PASSDB));
//		dataMachine.SetConnect(dbConnect);

/*		// nastavime Connect RMI
		MeDataMachineRMI dataMachine = new MeDataMachineRMI();
		PeConnectRMI dbConnect = new PeConnectRMI();
		dataMachine.SetConnect(dbConnect);
*/
		// nastavime Context aplikace
		PensumContext.CreateInstance("penclient.cfg", MeDefine.DEF_DATAMACHINE_SQL, "lc", "");

		// otestovani prosteho spojeni
/*		MeDataTest p1 = new MeDataTest(5, "BOB");
		System.out.println("-- Proste spojeni -----------------------------------");
		System.out.println("  Vstup  [" + p1.GetID() + "][" + p1.GetName() + "]");  
		MeDataTest p2 = PensumContext.GetMachine().sendTest(p1);
		System.out.println("  Vystup [" + p2.GetID() + "][" + p2.GetName() + "]");

		System.out.println("-- Jeden prvek --------------------------------------");
		PeJob testJob = PeJob.CreteInstance();
		testJob.LoadData(MePodminka.Create("vyrobek_id", 1)); 

		// Create SwingSet on the default monitor
		MeDialog dlg = MeDialog.CreateDlg(getFrame(), testJob); 
		dlg.showDialog();
*/

		////////////////////////////////////////////////////////////////////////////////////////////////////
	
		// PropertySheet
		JTabbedPane m_TabbedPane = new JTabbedPane();
		m_TabbedPane.addTab("Bc pkazy", PcJobsActualPanel.CreateInstance(m_frame));
		m_TabbedPane.addTab("Vrobky", PcProductsPanel.CreateInstance(m_frame));
		m_TabbedPane.addTab("Dlce", PcPartsPanel.CreateInstance(m_frame));
		m_TabbedPane.addTab("Matro", PcMaterialsPanel.CreateInstance(m_frame));
		m_TabbedPane.addTab("Pracovit", PcPlacesPanel.CreateInstance(m_frame));
		m_TabbedPane.addTab("Pracovnci", PcWorkersPanel.CreateInstance(m_frame));
	
		//////////////////////////////////////////////////////////////
/*
	  String[] arrPopisy = new String[4];
	  arrPopisy[0] = "ID";
	  arrPopisy[1] = "Jmeno";
		arrPopisy[2] = "Vytvoreno";
		arrPopisy[3] = "Popis";
	  
	  PeUniGrid panelUni = PeUniGrid.CreateGrid("SELECT pejob_id, jojmeno, jocreate, jopopis FROM pejob WHERE 1 = 1 ", arrPopisy);
		// a vse zobrazime
		panelUni.FilterTable(MePodminka.Create("1", "1"));

		JScrollPane jp = new JScrollPane();
		jp.add(panelUni);

		m_TabbedPane.addTab("Seznam job", jp);
*/
		////////////////////////////////////////////////////////////

		top.add(m_TabbedPane, BorderLayout.CENTER);
		
		m_frame.getContentPane().add(top);
		m_frame.pack();
		
		// naplnime data
		//m_arrData;
/*
    // pokud se nam nepodari nahrat usera, konec
//    if(m_WorkData.LoadUser()) {
      	// PropertySheet
//			m_TabbedPane = new JWeaverTabbedPane();
  
      // Panely PropertySheetu
    	m_PensumPanel = new zzz_smazat_JPensumWork();
      // nahrajemem  data pro aktualniho uzivatele
			m_PensumPanel.CreateWorkPanel();
//			m_PensumPanel.SetStatusBar(statusField);
//     	m_TabbedPane.addTab("WorkFlow", m_PensumPanel);
    
      // Panely PropertySheetu
//	  	m_DochazkaPanel = new JWeaverDoch();
//      m_DochazkaPanel.CreateDochPanel();
//      m_DochazkaPanel.SetStatusBar(statusField);
//    	m_TabbedPane.addTab("Dochzka", m_DochazkaPanel);

      // toolbar
//    	m_ToolBarPanel = new JWeaverToolBar();
//    	m_ToolBarPanel.CreateToolBar(m_WorkFlowPanel, m_rtUtil);

      //nakonec pridame do celeho okna
//    	top.add(m_ToolBarPanel, BorderLayout.SOUTH);
    	add(m_PensumPanel, BorderLayout.CENTER);
    	
    	// nakonec to reloadnem
//			m_PensumPanel.ReloadTable();
/*    }
    // jinak nastavime chybovou chlasku
    else {
      //...create the components to go into the frame...
     	JPanel errorPane = new JPanel();
    	errorPane.setLayout(new BorderLayout());
    	JTextField errorField = new JTextField("Nepihlen!");
    	errorField.setEditable(false);
    	errorPane.add(errorField, BorderLayout.CENTER);
    	top.add(errorPane, BorderLayout.CENTER);
    }

    if (!isApplet()) {
      //...stick them in a container named contents...
      m_frame.getContentPane().add(this, BorderLayout.CENTER);
      //Finish setting up the frame, and show it.
      m_frame.pack();
      m_frame.setVisible(true);
    }
*/  }
}