
package cz.luboss.pensum.client.panel;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

// definice
import cz.luboss.medulla.client.dlg.McDlgSelect;
import cz.luboss.medulla.client.view.McGrid;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;
import cz.luboss.pensum.gener.*;

/**
 * Panel pro grid s hlavickou (tlacitka, filtr, ...)
 * 
 * @author LKC
*/
public class PcHeaderPanel extends JScrollPane {
	
	/** Typ hlavicky pouze se jmenem */
	public static final int DEF_HEAD_ONLY_LABEL = 0;
	/** Typ hlavicky pouze s tlacitky pridat .. */
	public static final int DEF_HEAD_WITH_GRID_BUTTONS = 1;
	/** Typ hlavicky pouze se filtrovacimi poli a tlacitky */
	public static final int DEF_HEAD_WITH_FILTER = 2;
	/** Typ hlavicky pouze se zmenou statusu */
	public static final int DEF_HEAD_WITH_STATUS_BUTTONS = 3;
	/** Typ hlavicky pouze se pridavanim vyrobku */
	public static final int DEF_HEAD_WITH_ADD_PRODUCT_BUTTONS = 4;
	
	/** Konstruktor */
	public PcHeaderPanel() {
	}

	/** 
	 * Konstruktor s panelem
	 * 
	 * @param panel panel pro vlozeni
	*/
	public PcHeaderPanel(JPanel panel) {
		super (panel);
	}

	/** 
	 * Vytvori objekt
	 * 
	 * @param grid tabulka
	 * @param nType typ hlavicky
	 * @return vis popis  
	*/
	public static PcHeaderPanel CreateInstance(McGrid grid, int nType) {
		return PcHeaderPanel.CreateInstance(grid, new int[] {nType});
	}

	/** 
	 * Vytvori objekt
	 * 
	 * @param grid tabulka
	 * @param arrType pole typu hlavicky
	 * @return vis popis  
	*/
	public static PcHeaderPanel CreateInstance(McGrid grid, int[] arrType) {
		// vytvorime toolbar
		JPanel panelTool = new JPanel();
		panelTool.setLayout(new BorderLayout());	
		panelTool.add(PcHeaderPanel.CreateToolBar(grid, arrType), BorderLayout.WEST);

		JPanel panelAllTemp = new JPanel(); 
		panelAllTemp.setLayout(new BoxLayout(panelAllTemp, BoxLayout.Y_AXIS));
		panelAllTemp.add(panelTool);
		panelAllTemp.add(grid);

		return new PcHeaderPanel(panelAllTemp);
	}

	/** 
	 * Vytvori ToolBar s tlacitky, ...
	 * 
	 * @param grid tabulka
	 * @param arrType pole typu hlavicky
	 * @return vis popis  
	*/
	public static JToolBar CreateToolBar(McGrid grid, int[] arrType) {
		JToolBar toolBar = new JToolBar();
		// pridame nadpis 
		JLabel sNadpis = new JLabel(grid.getName());
		toolBar.add(Box.createRigidArea(new Dimension(5, 0)));
	  toolBar.add(sNadpis);
	  toolBar.add(Box.createRigidArea(new Dimension(15, 0)));

		// projedem a pridame vsechny tlacitka
		for (int i = 0 ; i < arrType.length; i++) {
			// pokud mame butony
			if (arrType[i] == PcHeaderPanel.DEF_HEAD_WITH_GRID_BUTTONS) {
				AddButtons(toolBar, grid);
			}
			// pokud mame button ze statusem
			if (arrType[i] == PcHeaderPanel.DEF_HEAD_WITH_STATUS_BUTTONS) {
				AddStatusButtons(toolBar, grid);
			}
			// pokud mame button s pridanim vyrobku
			if (arrType[i] == PcHeaderPanel.DEF_HEAD_WITH_ADD_PRODUCT_BUTTONS) {
				AddAddProductButtons(toolBar, grid);
			}
			// pokud mame pridat filter
			if (arrType[i] == PcHeaderPanel.DEF_HEAD_WITH_FILTER) {
				AddFilter(toolBar, grid);
			}
		}
	
		return toolBar;
	}

	/** 
	 * Prida tlacitka Vlozit, Smazat, Tisknout ...
	 * 
	 * @param toolBar toolbar do ktereho budeme pridavat
	 * @param grid tabulka s daty
	 * @return prubeh metody  
	*/
	public static boolean AddButtons(JToolBar toolBar, McGrid grid) {
		final McGrid gridFinal = grid;
		JButton buttNew = new JButton(PensumContext.getRes("BUTTON_PRIDAT"));
		buttNew.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				gridFinal.EventKeyInsert();
			}
	  });
	  JButton buttDelete = new JButton(PensumContext.getRes("BUTTON_SMAZAT"));
	  buttDelete.addActionListener(new ActionListener() {
		  public void actionPerformed(ActionEvent e) {
			gridFinal.EventKeyDelete();
		  }
		});
		JButton buttPrintRow = new JButton(PensumContext.getRes("BUTTON_TISK_RADKU"));
		buttPrintRow.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				gridFinal.EventKeyP();
			}
		});
		JButton buttPrint = new JButton(PensumContext.getRes("BUTTON_TISK_TABULKY"));
		buttPrint.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				gridFinal.EventKeyT();
			}
		});

		// dame tlacitka k sobe		
		JPanel paneBut = new JPanel();
		GridBagLayout gridbag = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		paneBut.setFont(new Font("Helvetica", Font.PLAIN, 14));
		paneBut.setLayout(gridbag);
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		gridbag.setConstraints(buttNew, c);
		paneBut.add(buttNew);
		gridbag.setConstraints(buttDelete, c);
		paneBut.add(buttDelete);
		gridbag.setConstraints(buttPrint, c);
		paneBut.add(buttPrint);
		gridbag.setConstraints(buttPrintRow, c);
		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		paneBut.add(buttPrintRow);
		
		toolBar.add(paneBut);
		return true;
  }

  /** 
   * Prida tlacitka Zmenit stav ...
   * 
   * @param toolBar toolbar do ktereho budeme pridavat
   * @param grid tabulka s daty
   * @return prubeh metody  
  */
  public static boolean AddStatusButtons(JToolBar toolBar, McGrid grid) {
	  final McGrid gridFinal = grid;
	  JButton buttStavSet = new JButton(PensumContext.getRes("BUTTON_ZMENA_STAVU"));
	  buttStavSet.addActionListener(new ActionListener() {
		  public void actionPerformed(ActionEvent e) {
			  MeItem item = gridFinal.GetSelectedItem();
			  if (item != null) {
			  	// vybereme stav 
					MeFieldREF m_iField = MeFieldREF.createInstance("stav", PeStatus.class, "stname", 0, false);
					McDlgSelect dlg = McDlgSelect.CreateDlg(null, (MeFieldREF) m_iField);
					dlg.showDialog();
			  	
				  // spustime podle typu
				  if (item instanceof PeRunProduct) {
					  PensumContext.GetRunMachine().SetStavProduct(PensumContext.GetSessionID(), (PeRunProduct) item, m_iField.GetRefID());
				  }
				  else if (item instanceof PeRunPart) {
					  PensumContext.GetRunMachine().SetStavPart(PensumContext.GetSessionID(), (PeRunPart) item, 2);
				  }
				  else if (item instanceof PeRunOperation) {
					  PensumContext.GetRunMachine().SetStavOper(PensumContext.GetSessionID(), (PeRunOperation) item, 2);
				  }
			  }
		  }
	  });

	  // dame tlacitka k sobe		
	  JPanel paneBut = new JPanel();
	  GridBagLayout gridbag = new GridBagLayout();
	  GridBagConstraints c = new GridBagConstraints();
	  paneBut.setFont(new Font("Helvetica", Font.PLAIN, 14));
	  paneBut.setLayout(gridbag);
	  c.fill = GridBagConstraints.BOTH;
	  c.weightx = 1.0;
	  gridbag.setConstraints(buttStavSet, c);
	  c.gridwidth = GridBagConstraints.REMAINDER; //end row
	  paneBut.add(buttStavSet);
		
	  toolBar.add(paneBut);
	  return true;
	}
  
	/** 
	 * Prida tlacitka Pridat vyrobek ...
	 * 
	 * @param toolBar toolbar do ktereho budeme pridavat
	 * @param grid tabulka s daty
	 * @return prubeh metody  
	*/
	public static boolean AddAddProductButtons(JToolBar toolBar, McGrid grid) {
		final McGrid gridFinal = grid;
		JButton buttStavSet = new JButton(PensumContext.getRes("BUTTON_PRIDAT_VYROBEK"));
		buttStavSet.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				MeItem item = gridFinal.GetSelectedItem();
				if (item != null) {
				  // vybereme stav 
				  MeFieldREF m_iField = MeFieldREF.createInstance("vyrobek", PeProduct.class, "prjmeno", 0, false);
				  McDlgSelect dlg = McDlgSelect.CreateDlg(null, (MeFieldREF) m_iField);
				  dlg.showDialog();
			  	
					// spustime pridani
					if (item instanceof PeJob) {
						PensumContext.GetRunMachine().AddProduct(PensumContext.GetSessionID(), 
              (PeJob) item, (PeProduct) m_iField.GetRef());
					}
				}
			}
		});

		// dame tlacitka k sobe		
		JPanel paneBut = new JPanel();
		GridBagLayout gridbag = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		paneBut.setFont(new Font("Helvetica", Font.PLAIN, 14));
		paneBut.setLayout(gridbag);
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		gridbag.setConstraints(buttStavSet, c);
		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		paneBut.add(buttStavSet);
		
		toolBar.add(paneBut);
		return true;
	  }

	/** 
	 * Prida filter
	 * 
	 * @param toolBar toolbar do ktereho budeme pridavat
	 * @param grid tabulka s daty
	 * @return prubeh metody  
	*/
  public static boolean AddFilter(JToolBar toolBar, McGrid grid) {
		return true;
  }
}
