package cz.luboss.pensum.client.panel;

import java.awt.Component;
import javax.swing.*;

// implementace
import cz.luboss.pensum.client.view.*;
import cz.luboss.pensum.common.PensumContext;
import cz.luboss.pensum.gener.PeSessionArray;

/**
 * Okno s vypisem uzivatelych session
 * 
 * @author LKC 
*/
public class PcSessionPanel extends JSplitPane {

	/** 
	 * Konstruktor s parametry 
	 * 
	 * @param newOrientation orientace oken ve splitu
	 * @param newLeftComponent leve okno splitu
	 * @param newRightComponent prave okno splitu
	*/ 
	public PcSessionPanel(int newOrientation, Component newLeftComponent, Component newRightComponent) {
		super(newOrientation, newLeftComponent, newRightComponent);		
	}

  /** 
	 * Vytvorime objekt
	 * 
	 * @param frame aktualni frame
	 * @return novy objekt  
	*/
  public static PcSessionPanel CreateInstance(JFrame frame) {
		// vytvorime data
		PeSessionArray arrSess = (PeSessionArray) PensumContext.GetRunMachine().GetActualSessions();
    // pokud je null
    if (arrSess == null) {
      arrSess = PeSessionArray.createInstance();
    }
  	
		// vytvorime tabulky
		PeSessionGrid panel10 = PeSessionGrid.CreateGrid(frame, arrSess);
//		JPanel panel11 = new JPanel();
    JEditorPane panel11 = new JEditorPane();
    panel11.setText("Aheheh");
    panel11.setEditable(false);

		// splitove okno
		PcSessionPanel pane = new PcSessionPanel(JSplitPane.VERTICAL_SPLIT, 
      PcHeaderPanel.CreateInstance(panel10, PcHeaderPanel.DEF_HEAD_ONLY_LABEL), panel11);
		pane.setContinuousLayout(true);
		pane.setOneTouchExpandable(true);
		pane.setDividerLocation(150);
    return pane;
  }
}
