package cz.luboss.pensum.client.view;

import javax.swing.JFrame;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeArray;

// implementace
import cz.luboss.pensum.gener.PeJob;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McParentGrid;

/**
 * Grid pro zobrazeni PeJob
 * 
 * @author LKC
*/
public class PeJobGrid extends McParentGrid {
	
	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PeJobGrid CreateGrid(JFrame frame, MeArray arrData) {
		PeJobGrid grid = new PeJobGrid();
		grid.setName("Objednvky");
	  grid.m_arrData = arrData;
	  	
		// nacteme defaultni sloupce
		PeJob job = (PeJob) PeJob.createInstance();
		grid.m_arrColumn = job.getColumns();
		
		grid.Inicialize(frame);
  	return grid; 
 	}
  
	/**
	 * Prida jednu polozku
	 *  
	 * @return radek nove polozky 
	*/ 
	public int AddItem() {
    MedullaContext.StartTransaction();
    PeJob job = (PeJob) PeJob.createInstance();
    MedullaContext.Register(job);
		McDialog dlg = McDialog.CreateDlg(null, job);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		// skocime na prvni
		return 0;
	}

}
