package cz.luboss.pensum.client.view;

import javax.swing.JFrame;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeArray;

// implementace
import cz.luboss.pensum.gener.PeMaterial;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McParentGrid;

/**
 * Grid pro zobrazeni PeMaterial
 * 
 * @author LKC
*/
public class PeMaterialGrid extends McParentGrid {
	
	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PeMaterialGrid CreateGrid(JFrame frame, MeArray arrData) {
		PeMaterialGrid grid = new PeMaterialGrid();
		grid.setName("Materily");
		grid.m_arrData = arrData;

		// nacteme defaultni sloupce
		PeMaterial mater = (PeMaterial) PeMaterial.createInstance();
		grid.m_arrColumn = mater.getColumns();

	  grid.Inicialize(frame);
	  return grid; 
  }
  
  /**
   * Prida jednu polozku
   *  
   * @return radek nove polozky 
  */ 
	public int AddItem() {
    MedullaContext.StartTransaction();
		PeMaterial mater = (PeMaterial) PeMaterial.createInstance();
    MedullaContext.Register(mater);
		McDialog dlg = McDialog.CreateDlg(null, mater);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		return 0;
	}
}
