package cz.luboss.pensum.client.view;

import javax.swing.JFrame;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeArray;

// implementace
import cz.luboss.pensum.gener.PePart;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McParentGrid;

/**
 * Grid pro zobrazeni PePart
 * 
 * @author LKC
*/
public class PePartGrid extends McParentGrid {

	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PePartGrid CreateGrid(JFrame frame, MeArray arrData) {
		PePartGrid grid = new PePartGrid();
	  grid.m_arrData = arrData;
	  grid.setName("Dlce");

		// nacteme defaultni sloupce
		PePart part = (PePart) PePart.createInstance();
		grid.m_arrColumn = part.getColumns();

		grid.Inicialize(frame);
		return grid; 
	}
  
	/**
	 * Prida jednu polozku
	 *  
	 * @return radek nove polozky 
	*/ 
	public int AddItem() {
    MedullaContext.StartTransaction();
		PePart dilec = (PePart) PePart.createInstance();
    MedullaContext.Register(dilec);
		dilec.getParam("peproduct_id").SetString(m_iPodminka.GetValue());
		McDialog dlg = McDialog.CreateDlg(null, dilec);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		return 0;
	}
	
}
