package cz.luboss.pensum.client.view;

import javax.swing.JFrame;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeArray;

// implementace
import cz.luboss.pensum.gener.PePlace;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McParentGrid;

/**
 * Grid pro zobrazeni PePlace
 * 
 * @author LKC
*/
public class PePlaceGrid extends McParentGrid {

	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PePlaceGrid CreateGrid(JFrame frame, MeArray arrData) {
		PePlaceGrid grid = new PePlaceGrid();
  	grid.m_arrData = arrData;
  	grid.setName("Pracovist");
	  
	  	// nacteme defaultni sloupce
		PePlace place = (PePlace) PePlace.createInstance();
  	grid.m_arrColumn = place.getColumns();
  
  	grid.Inicialize(frame);
  	return grid; 
	}
  
	/**
	 * Prida jednu polozku
	 *  
	 * @return radek nove polozky 
	*/ 
	public int AddItem() {
    MedullaContext.StartTransaction();
    PePlace misto = PePlace.createInstance();
    MedullaContext.Register(misto);
		McDialog dlg = McDialog.CreateDlg(null, misto);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		// skocime na prvni
		return 0;
	}

}
