package cz.luboss.pensum.client.view;

import javax.swing.JFrame;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.data.MeItem;

// implementace
import cz.luboss.pensum.gener.PeScrap;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McParentGrid;

/**
 * Grid pro zobrazeni PeScrap
 * 
 * @author LKC
*/
public class PeScrapGrid extends McParentGrid {
	
	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PeScrapGrid CreateGrid(JFrame frame, MeArray arrData) {
		PeScrapGrid grid = new PeScrapGrid();
		grid.m_arrData = arrData;
		grid.setName("Zmetky");
	  
		// nacteme defaultni sloupce
		PeScrap scrap = (PeScrap) PeScrap.createInstance();
		grid.m_arrColumn = scrap.getColumns();

		grid.Inicialize(frame);
		return grid; 
 	}
  
	/**
	 * Prida jednu polozku
	 *  
	 * @return radek nove polozky 
	*/ 
	public int AddItem() {
    MedullaContext.StartTransaction();
    PeScrap scrap = (PeScrap) PeScrap.createInstance();
    MedullaContext.Register(scrap);
		McDialog dlg = McDialog.CreateDlg(null, scrap);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		// skocime na prvni
		return 0;
	}

	/**
	 * Smaze jednu polozku
	 *
	 * @param iItem smazana polozka
	 * @return prubeh funkce
	*/ 
	public boolean DeleteItem(MeItem iItem) {
		iItem.delete();
		return true;
	}

}
