package cz.luboss.pensum.client.view;

import javax.swing.event.ListSelectionEvent;
import javax.swing.JFrame;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.data.MeItem;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McParentGrid;

// implementace
import cz.luboss.pensum.gener.PeSession;

/**
 * Grid pro zobrazeni PeSession
 * 
 * @author LKC
*/
public class PeSessionGrid extends McParentGrid {
	
	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PeSessionGrid CreateGrid(JFrame frame, MeArray arrData) {
		PeSessionGrid grid = new PeSessionGrid();
  	grid.m_arrData = arrData;
  	grid.setName("Relace");

		// nacteme defaultni sloupce
		PeSession session = (PeSession) PeSession.createInstance();
		grid.m_arrColumn = session.getColumns();

		grid.Inicialize(frame);
		return grid; 
 	}
  
	/**
	 * Prida jednu polozku
	 *  
	 * @return radek nove polozky 
	*/ 
	public int AddItem() {
    MedullaContext.StartTransaction();
    PeSession session = (PeSession) PeSession.createInstance();
    MedullaContext.Register(session);
		McDialog dlg = McDialog.CreateDlg(null, session);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		// skocime na prvni
		return 0;
	}

	/**
	 * Smaze jednu polozku
	 *
	 * @param iItem smazana polozka
	 * @return prubeh funkce
	*/ 
	public boolean DeleteItem(MeItem iItem) {
		iItem.delete();
		return true;
	}

  /**
	 * Udalost na zmenu kurzoru v gridu
	 *
	 * @param e udalost
	*/ 
	public void EventChangeGrid(ListSelectionEvent e) {
    super.EventChangeGrid(e);
    // prepisem session
//    m_arrData.GetItem(m_nSelectedRow)
	}

}
