package cz.luboss.pensum.client.view;

import javax.swing.JFrame;

// defnice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeArray;
import cz.luboss.medulla.data.MeItem;

// implementace
import cz.luboss.pensum.gener.PeTask;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McParentGrid;

/**
 * Grid pro zobrazeni Task
 * 
 * @author LKC
*/
public class PeTaskGrid extends McParentGrid {
	
	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PeTaskGrid CreateGrid(JFrame frame, MeArray arrData) {
		PeTaskGrid grid = new PeTaskGrid();
  	grid.m_arrData = arrData;
  	grid.setName("Pkazy");

		// nacteme defaultni sloupce
		PeTask task = (PeTask) PeTask.createInstance();
		grid.m_arrColumn = task.getColumns();

  	grid.Inicialize(frame);
  	return grid; 
	}
  
	/**
	 * Prida jednu polozku
	 *  
	 * @return radek nove polozky 
	*/ 
	public int AddItem() {
    MedullaContext.StartTransaction();
		PeTask job = PeTask.createInstance();
    MedullaContext.Register(job);
		McDialog dlg = McDialog.CreateDlg(null, job);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		// skocime na prvni
		return 0;
	}

	/**
	 * Smaze jednu polozku
	 *
	 * @param iItem smazana polozka
	 * @return prubeh funkce
	*/ 
	public boolean DeleteItem(MeItem iItem) {
		iItem.delete();
		return true;
	}

}
