package cz.luboss.pensum.client.view;

import javax.swing.JFrame;

// definice
import cz.luboss.medulla.common.MedullaContext;
import cz.luboss.medulla.common.MeDefine;
import cz.luboss.medulla.data.MeArray;

// implementace
import cz.luboss.pensum.gener.PeWorker;
import cz.luboss.medulla.client.dlg.McDialog;
import cz.luboss.medulla.client.view.McParentGrid;

/**
 * Grid pro zobrazeni PeWorker
 * 
 * @author LKC
*/
public class PeWorkerGrid extends McParentGrid {
	
	/** 
	 * Vytvori grid s parametry
	 * 
	 * @param frame prislusny frame
	 * @param arrData pole s daty
	 * @return novy objekt
	*/
	public static PeWorkerGrid CreateGrid(JFrame frame, MeArray arrData) {
		PeWorkerGrid grid = new PeWorkerGrid();
  	grid.m_arrData = arrData;
  	grid.setName("Pracovnci");

		// nacteme defaultni sloupce
		PeWorker worker = (PeWorker) PeWorker.createInstance();
		grid.m_arrColumn = worker.getColumns();

		grid.Inicialize(frame);
		return grid; 
 	}
  
	/**
	 * Prida jednu polozku
	 *  
	 * @return radek nove polozky 
	*/ 
	public int AddItem() {
    MedullaContext.StartTransaction();
		PeWorker worker = (PeWorker) PeWorker.createInstance();
    MedullaContext.Register(worker);
		McDialog dlg = McDialog.CreateDlg(null, worker);
		dlg.showDialog();
    if (dlg.GetButton() == MeDefine.DEF_BUTTON_OK) {
      MedullaContext.Commit();
    } else {
      MedullaContext.RollBack();
    }
		// skocime na prvni
		return 0;
	}


}
