
package cz.luboss.pensum.factory;

// definice
import cz.luboss.medulla.factory.MeDataMachine;

// implemetace
import cz.luboss.pensum.gener.PeJob;
import cz.luboss.pensum.gener.PeProduct;
import cz.luboss.pensum.gener.PeRunProduct;
import cz.luboss.pensum.gener.PeRunPart;
import cz.luboss.pensum.gener.PeRunOperation;

/**
	* Tovarna pro business funkce Pensum
	*
	* @author LKC
*/
public interface PeDataMachine extends MeDataMachine {

	/**
	  * Prida vyrobek do jobu
	  *
	  * @param nSessionID Session
	  * @param job job, do ktereho je treba dat cely vyrobek
	  * @param product vkladany vyrobek
	  * @return prubeh funkce
	*/
	public boolean AddProduct(int nSessionID, PeJob job, PeProduct product);

	/**
	  * Nastavi na produktu a jeho dilcich stav   
	  *
	  * @param nSessionID Session
	  * @param product vyrobek
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavProduct(int nSessionID, PeRunProduct product, int nStav);

	/**
	  * Nastavi na dilci a jeho operacich stav
	  *
	  * @param nSessionID Session
	  * @param part dilec
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavPart(int nSessionID, PeRunPart part, int nStav);

	/**
	  * Nastavi na operaci stav
	  *
	  * @param nSessionID Session
	  * @param operation operace
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavOper(int nSessionID, PeRunOperation operation, int nStav);

}
