package cz.luboss.pensum.factory;

// definice
import cz.luboss.medulla.factory.MeDataMachineRMI;

// implementace
import cz.luboss.pensum.common.PensumContext;
import cz.luboss.pensum.gener.*;

/**
	* RMI tovarna pro business funkce Pensum
	*
	* @author LKC
*/
public class PeDataMachineRMI	extends MeDataMachineRMI implements PeDataMachine, PensumRMI {

	/**
	  * Vytvori novy objekt
	  *
	  * @return novy objekt
	*/
	public static PeDataMachineRMI CreateInstance() {
		PeDataMachineRMI machine = new PeDataMachineRMI();
		return machine;  
	}

	/**
	  * Prida vyrobek do jobu
	  *
	  * @param nSessionID Session
	  * @param job job, do ktereho je treba dat cely vyrobek
	  * @param product vkladany vyrobek
	  * @return prubeh funkce
	*/
	public boolean AddProduct(int nSessionID, PeJob job, PeProduct product) {
    // zalogujeme DEBBUG
    PensumContext.logDebug(this.getClass(), "S[" + nSessionID + "] AddProduct PeJob [" + job.getID() + "], PeProduct [" 
      + product.getID() + "] .");

    try {  
			return ((PensumRMI) m_dtConnectRMI.GeRMI()).AddProduct(nSessionID, job, product);
		} catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "S[" + nSessionID + "] AddProduct Error " 
        + " PeJob[" + job.getID() + "], PeProduct[" + product.getID() + "]", e);
		}
	}

	/**
	  * Nastavi na produktu a jeho dilcich stav   
	  *
	  * @param nSessionID Session
	  * @param product vyrobek
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavProduct(int nSessionID, PeRunProduct product, int nStav) {
    // zalogujeme DEBBUG
    PensumContext.logDebug(this.getClass(), "SetStavProduct PeRunProduct [" + product.getID() 
      + "], stav [" + nStav + "] .");

    try {  
			return ((PensumRMI) m_dtConnectRMI.GeRMI()).SetStavProduct(nSessionID, product, nStav);
		} catch (Exception e) {
      throw new cz.luboss.lubosslib.LException(this.getClass(), "SetStavProduct Error PeRunProduct[" 
        + product.getID() + "], stav [" + nStav + "] .", e);
		}
	}

	/**
	  * Nastavi na dilci a jeho operacich stav
	  *
	  * @param nSessionID Session
	  * @param part dilec
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavPart(int nSessionID, PeRunPart part, int nStav) {
    // zalogujeme DEBBUG
    PensumContext.logDebug(this.getClass(), "SetStavPart PeRunPart [" + part.getID() 
      + "], stav [" + nStav + "] .");

    try {  
			return ((PensumRMI) m_dtConnectRMI.GeRMI()).SetStavPart(nSessionID, part, nStav);
		} catch (Exception e) {
      // zalogujeme DEBBUG
      throw new cz.luboss.lubosslib.LException(this.getClass(), "SetStavPart PeRunPart [" + part.getID() 
        + "], stav [" + nStav + "] .", e);
		}
	}

	/**
	  * Nastavi na operaci stav
	  *
	  * @param nSessionID Session
	  * @param operation operace
	  * @param nStav stav pro nastaveni
	  * @return prubeh funkce
	*/
	public boolean SetStavOper(int nSessionID, PeRunOperation operation, int nStav) {
    // zalogujeme DEBBUG
    PensumContext.logDebug(this.getClass(), "SetStavOper PeRunOperation [" + operation.getID() 
      + "], stav [" + nStav + "] .");

    try {  
			return ((PensumRMI) m_dtConnectRMI.GeRMI()).SetStavOper(nSessionID, operation, nStav);
		} catch (Exception e) {
      // zalogujeme DEBBUG
      throw new cz.luboss.lubosslib.LException(this.getClass(), "SetStavOper PeRunOperation [" + operation.getID() 
        + "], stav [" + nStav + "] .", e);
		}
	}

}
