
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Job - skupina zpracovavanych vyrobku (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:28:57</b>
	*
	* @author Spinster Generator
*/
public class PeJob extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT pejob_id = MeFieldINT.createInstance("pejob_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldSTRING jojmeno = MeFieldSTRING.createInstance("jojmeno", "", true);
	MeFieldDATE jovytvoren = MeFieldDATE.createInstance("jovytvoren", null, true);
	MeFieldSTRING jopopis = MeFieldSTRING.createInstance("jopopis", "", true);
	MeFieldINT johotovo = MeFieldINT.createInstance("johotovo", 0, true);
	MeFieldINT jorozpracovano = MeFieldINT.createInstance("jorozpracovano", 0, true);
	MeFieldINT jozalozeno = MeFieldINT.createInstance("jozalozeno", 0, true);

	/** pole vyrobku v jobu */
	protected PeRunProductArray m_arrgetRunProductArray = null;

	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PeJob createInstance() {
		PeJob newItem = new PeJob();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PeJob.m_mapDescParam = new HashMap();
			PeJob.m_mapDescParam.put("pejob_id", "GRID_POL_ID");
			PeJob.m_mapDescParam.put("jojmeno", "GRID_POL_JMENO");
			PeJob.m_mapDescParam.put("jovytvoren", "GRID_POL_VYTVORENO");
			PeJob.m_mapDescParam.put("jopopis", "GRID_POL_POPIS");
			PeJob.m_mapDescParam.put("johotovo", "GRID_POL_ZALOZENO");
			PeJob.m_mapDescParam.put("jorozpracovano", "GRID_POL_ROZPRACOVANO");
			PeJob.m_mapDescParam.put("jozalozeno", "GRID_POL_HOTOVO");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PeJob createInstance(int nID) {
		PeJob newItem = PeJob.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return pejob_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "pejob_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.pejob_id = ((PeJob) zdroj).pejob_id;
		this.jojmeno = ((PeJob) zdroj).jojmeno;
		this.jovytvoren = ((PeJob) zdroj).jovytvoren;
		this.jopopis = ((PeJob) zdroj).jopopis;
		this.johotovo = ((PeJob) zdroj).johotovo;
		this.jorozpracovano = ((PeJob) zdroj).jorozpracovano;
		this.jozalozeno = ((PeJob) zdroj).jozalozeno;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 7;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return pejob_id;
		} else if (nRow == 1) {
			return jojmeno;
		} else if (nRow == 2) {
			return jovytvoren;
		} else if (nRow == 3) {
			return jopopis;
		} else if (nRow == 4) {
			return johotovo;
		} else if (nRow == 5) {
			return jorozpracovano;
		} else if (nRow == 6) {
			return jozalozeno;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("pejob_id")) {
			return pejob_id;
		} else if (sName.equals("jojmeno")) {
			return jojmeno;
		} else if (sName.equals("jovytvoren")) {
			return jovytvoren;
		} else if (sName.equals("jopopis")) {
			return jopopis;
		} else if (sName.equals("johotovo")) {
			return johotovo;
		} else if (sName.equals("jorozpracovano")) {
			return jorozpracovano;
		} else if (sName.equals("jozalozeno")) {
			return jozalozeno;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(pejob_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////
	/**
	 	* Vrati pole vyrobku v jobu, pokud neexistuje, vytvorime
	 	*
	 	* @return viz popis metody
	*/
	public PeRunProductArray getRunProductArray() {
		// pokud pole neni naplneno
		if (m_arrgetRunProductArray == null) {
			m_arrgetRunProductArray = PeRunProductArray.createInstance();
			m_arrgetRunProductArray.loadArray(MePodminka.createInstance("pejob_id", this.getID()));
		}
		return m_arrgetRunProductArray;
	}

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[7];
		arrColumn[0] = MeColumn.createInstance("pejob_id", PensumContext.getRes(this.getDesc("pejob_id")), 30);
		arrColumn[1] = MeColumn.createInstance("jojmeno", PensumContext.getRes(this.getDesc("jojmeno")), 150);
		arrColumn[2] = MeColumn.createInstance("jovytvoren", PensumContext.getRes(this.getDesc("jovytvoren")), 150);
		arrColumn[3] = MeColumn.createInstance("jopopis", PensumContext.getRes(this.getDesc("jopopis")), 150);
		arrColumn[4] = MeColumn.createInstance("jozalozeno", PensumContext.getRes(this.getDesc("jozalozeno")), 100);
		arrColumn[5] = MeColumn.createInstance("jorozpracovano", PensumContext.getRes(this.getDesc("jorozpracovano")), 100);
		arrColumn[6] = MeColumn.createInstance("johotovo", PensumContext.getRes(this.getDesc("johotovo")), 100);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr pejob_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPeJob() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.pejob_id.GetInt();
	}

	/**
	  * Nastavi parametr pejob_id  
	  *
	  * @param pejob_id hodnota parametru
	*/
	public void setPeJob(int pejob_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pejob_id.SetInt(pejob_id_temp);
	}
	/**
	  * Vrati hodnotu parametr jojmeno  
	  *
	  * @return hodnota parametru
	*/
	public String getJoJmeno() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.jojmeno.GetString();
	}

	/**
	  * Nastavi parametr jojmeno  
	  *
	  * @param jojmeno hodnota parametru
	*/
	public void setJoJmeno(String jojmeno_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.jojmeno.SetString(jojmeno_temp);
	}
	/**
	  * Vrati hodnotu parametr jovytvoren  
	  *
	  * @return hodnota parametru
	*/
	public java.util.Date getJoVytvoren() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (java.util.Date) this.jovytvoren.GetDate();
	}

	/**
	  * Nastavi parametr jovytvoren  
	  *
	  * @param jovytvoren hodnota parametru
	*/
	public void setJoVytvoren(java.util.Date jovytvoren_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.jovytvoren.SetDate(jovytvoren_temp);
	}
	/**
	  * Vrati hodnotu parametr jopopis  
	  *
	  * @return hodnota parametru
	*/
	public String getJoPopis() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.jopopis.GetString();
	}

	/**
	  * Nastavi parametr jopopis  
	  *
	  * @param jopopis hodnota parametru
	*/
	public void setJoPopis(String jopopis_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.jopopis.SetString(jopopis_temp);
	}
	/**
	  * Vrati hodnotu parametr johotovo  
	  *
	  * @return hodnota parametru
	*/
	public int getJoHotovo() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.johotovo.GetInt();
	}

	/**
	  * Nastavi parametr johotovo  
	  *
	  * @param johotovo hodnota parametru
	*/
	public void setJoHotovo(int johotovo_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.johotovo.SetInt(johotovo_temp);
	}
	/**
	  * Vrati hodnotu parametr jorozpracovano  
	  *
	  * @return hodnota parametru
	*/
	public int getJoRozpracovano() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.jorozpracovano.GetInt();
	}

	/**
	  * Nastavi parametr jorozpracovano  
	  *
	  * @param jorozpracovano hodnota parametru
	*/
	public void setJoRozpracovano(int jorozpracovano_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.jorozpracovano.SetInt(jorozpracovano_temp);
	}
	/**
	  * Vrati hodnotu parametr jozalozeno  
	  *
	  * @return hodnota parametru
	*/
	public int getJoZalozeno() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.jozalozeno.GetInt();
	}

	/**
	  * Nastavi parametr jozalozeno  
	  *
	  * @param jozalozeno hodnota parametru
	*/
	public void setJoZalozeno(int jozalozeno_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.jozalozeno.SetInt(jozalozeno_temp);
	}

}
