
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Operace na dilci (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:28:58</b>
	*
	* @author Spinster Generator
*/
public class PeOperation extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT peoperation_id = MeFieldINT.createInstance("peoperation_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldREF peplace_id = MeFieldREF.createInstance("peplace_id", PePlace.class, "pljmeno", 0, true);
	MeFieldREF pepart_id = MeFieldREF.createInstance("pepart_id", PePart.class, "ptjmeno", 0, false);
	MeFieldSTRING opjmeno = MeFieldSTRING.createInstance("opjmeno", "", true);
	MeFieldINT optime = MeFieldINT.createInstance("optime", 0, true);
	MeFieldFLOAT opmzda = MeFieldFLOAT.createInstance("opmzda", 0, true);


	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PeOperation createInstance() {
		PeOperation newItem = new PeOperation();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PeOperation.m_mapDescParam = new HashMap();
			PeOperation.m_mapDescParam.put("peoperation_id", "GRID_POL_ID");
			PeOperation.m_mapDescParam.put("peplace_id", "GRID_POL_PRACOVISTE");
			PeOperation.m_mapDescParam.put("pepart_id", "");
			PeOperation.m_mapDescParam.put("opjmeno", "GRID_POL_JMENO");
			PeOperation.m_mapDescParam.put("optime", "GRID_POL_CAS");
			PeOperation.m_mapDescParam.put("opmzda", "GRID_POL_MZDA");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PeOperation createInstance(int nID) {
		PeOperation newItem = PeOperation.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return peoperation_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "peoperation_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.peoperation_id = ((PeOperation) zdroj).peoperation_id;
		this.peplace_id = ((PeOperation) zdroj).peplace_id;
		this.pepart_id = ((PeOperation) zdroj).pepart_id;
		this.opjmeno = ((PeOperation) zdroj).opjmeno;
		this.optime = ((PeOperation) zdroj).optime;
		this.opmzda = ((PeOperation) zdroj).opmzda;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 6;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return peoperation_id;
		} else if (nRow == 1) {
			return peplace_id;
		} else if (nRow == 2) {
			return pepart_id;
		} else if (nRow == 3) {
			return opjmeno;
		} else if (nRow == 4) {
			return optime;
		} else if (nRow == 5) {
			return opmzda;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("peoperation_id")) {
			return peoperation_id;
		} else if (sName.equals("peplace_id")) {
			return peplace_id;
		} else if (sName.equals("pepart_id")) {
			return pepart_id;
		} else if (sName.equals("opjmeno")) {
			return opjmeno;
		} else if (sName.equals("optime")) {
			return optime;
		} else if (sName.equals("opmzda")) {
			return opmzda;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(peoperation_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[5];
		arrColumn[0] = MeColumn.createInstance("peoperation_id", PensumContext.getRes(this.getDesc("peoperation_id")), 20);
		arrColumn[1] = MeColumn.createInstance("peplace_id", PensumContext.getRes(this.getDesc("peplace_id")), 100);
		arrColumn[2] = MeColumn.createInstance("opjmeno", PensumContext.getRes(this.getDesc("opjmeno")), 100);
		arrColumn[3] = MeColumn.createInstance("optime", PensumContext.getRes(this.getDesc("optime")), 80);
		arrColumn[4] = MeColumn.createInstance("opmzda", PensumContext.getRes(this.getDesc("opmzda")), 80);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr peoperation_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPeOperation() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.peoperation_id.GetInt();
	}

	/**
	  * Nastavi parametr peoperation_id  
	  *
	  * @param peoperation_id hodnota parametru
	*/
	public void setPeOperation(int peoperation_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.peoperation_id.SetInt(peoperation_id_temp);
	}
	/**
	  * Vrati hodnotu parametr peplace_id  
	  *
	  * @return hodnota parametru
	*/
	public PePlace getPePlace() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PePlace) this.peplace_id.GetRef();
	}

	/**
	  * Nastavi parametr peplace_id  
	  *
	  * @param peplace_id hodnota parametru
	*/
	public void setPePlace(PePlace peplace_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.peplace_id.SetRef(peplace_id_temp);
	}
	/**
	  * Vrati hodnotu parametr pepart_id  
	  *
	  * @return hodnota parametru
	*/
	public PePart getPePart() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PePart) this.pepart_id.GetRef();
	}

	/**
	  * Nastavi parametr pepart_id  
	  *
	  * @param pepart_id hodnota parametru
	*/
	public void setPePart(PePart pepart_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pepart_id.SetRef(pepart_id_temp);
	}
	/**
	  * Vrati hodnotu parametr opjmeno  
	  *
	  * @return hodnota parametru
	*/
	public String getOpJmeno() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.opjmeno.GetString();
	}

	/**
	  * Nastavi parametr opjmeno  
	  *
	  * @param opjmeno hodnota parametru
	*/
	public void setOpJmeno(String opjmeno_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.opjmeno.SetString(opjmeno_temp);
	}
	/**
	  * Vrati hodnotu parametr optime  
	  *
	  * @return hodnota parametru
	*/
	public int getOpTime() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.optime.GetInt();
	}

	/**
	  * Nastavi parametr optime  
	  *
	  * @param optime hodnota parametru
	*/
	public void setOpTime(int optime_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.optime.SetInt(optime_temp);
	}
	/**
	  * Vrati hodnotu parametr opmzda  
	  *
	  * @return hodnota parametru
	*/
	public float getOpMzda() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (float) this.opmzda.GetFloat();
	}

	/**
	  * Nastavi parametr opmzda  
	  *
	  * @param opmzda hodnota parametru
	*/
	public void setOpMzda(float opmzda_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.opmzda.SetFloat(opmzda_temp);
	}

}
