
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Dilec (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:28:58</b>
	*
	* @author Spinster Generator
*/
public class PePart extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT pepart_id = MeFieldINT.createInstance("pepart_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldSTRING ptjmeno = MeFieldSTRING.createInstance("ptjmeno", "", true);
	MeFieldSTRING ptsirka = MeFieldSTRING.createInstance("ptsirka", "", true);
	MeFieldSTRING ptdelka = MeFieldSTRING.createInstance("ptdelka", "", true);
	MeFieldSTRING pthloubka = MeFieldSTRING.createInstance("pthloubka", "", true);
	MeFieldSTRING ptpozn = MeFieldSTRING.createInstance("ptpozn", "", true);

	/** pole operaci */
	protected PeOperationArray m_arrgetOperArray = null;

	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PePart createInstance() {
		PePart newItem = new PePart();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PePart.m_mapDescParam = new HashMap();
			PePart.m_mapDescParam.put("pepart_id", "GRID_POL_ID");
			PePart.m_mapDescParam.put("ptjmeno", "GRID_POL_JMENO");
			PePart.m_mapDescParam.put("ptsirka", "GRID_POL_SIRKA");
			PePart.m_mapDescParam.put("ptdelka", "GRID_POL_DELKA");
			PePart.m_mapDescParam.put("pthloubka", "GRID_POL_HLOUBKA");
			PePart.m_mapDescParam.put("ptpozn", "GRID_POL_POZNAMKA");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PePart createInstance(int nID) {
		PePart newItem = PePart.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return pepart_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "pepart_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.pepart_id = ((PePart) zdroj).pepart_id;
		this.ptjmeno = ((PePart) zdroj).ptjmeno;
		this.ptsirka = ((PePart) zdroj).ptsirka;
		this.ptdelka = ((PePart) zdroj).ptdelka;
		this.pthloubka = ((PePart) zdroj).pthloubka;
		this.ptpozn = ((PePart) zdroj).ptpozn;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 6;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return pepart_id;
		} else if (nRow == 1) {
			return ptjmeno;
		} else if (nRow == 2) {
			return ptsirka;
		} else if (nRow == 3) {
			return ptdelka;
		} else if (nRow == 4) {
			return pthloubka;
		} else if (nRow == 5) {
			return ptpozn;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("pepart_id")) {
			return pepart_id;
		} else if (sName.equals("ptjmeno")) {
			return ptjmeno;
		} else if (sName.equals("ptsirka")) {
			return ptsirka;
		} else if (sName.equals("ptdelka")) {
			return ptdelka;
		} else if (sName.equals("pthloubka")) {
			return pthloubka;
		} else if (sName.equals("ptpozn")) {
			return ptpozn;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(pepart_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////
	/**
	 	* Vrati pole operaci, pokud neexistuje, vytvorime
	 	*
	 	* @return viz popis metody
	*/
	public PeOperationArray getOperArray() {
		// pokud pole neni naplneno
		if (m_arrgetOperArray == null) {
			m_arrgetOperArray = PeOperationArray.createInstance();
			m_arrgetOperArray.loadArray(MePodminka.createInstance("pepart_id", this.getID()));
		}
		return m_arrgetOperArray;
	}

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[6];
		arrColumn[0] = MeColumn.createInstance("pepart_id", PensumContext.getRes(this.getDesc("pepart_id")), 20);
		arrColumn[1] = MeColumn.createInstance("ptjmeno", PensumContext.getRes(this.getDesc("ptjmeno")), 100);
		arrColumn[2] = MeColumn.createInstance("ptsirka", PensumContext.getRes(this.getDesc("ptsirka")), 150);
		arrColumn[3] = MeColumn.createInstance("ptdelka", PensumContext.getRes(this.getDesc("ptdelka")), 100);
		arrColumn[4] = MeColumn.createInstance("pthloubka", PensumContext.getRes(this.getDesc("pthloubka")), 150);
		arrColumn[5] = MeColumn.createInstance("ptpozn", PensumContext.getRes(this.getDesc("ptpozn")), 150);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr pepart_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPePart() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.pepart_id.GetInt();
	}

	/**
	  * Nastavi parametr pepart_id  
	  *
	  * @param pepart_id hodnota parametru
	*/
	public void setPePart(int pepart_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pepart_id.SetInt(pepart_id_temp);
	}
	/**
	  * Vrati hodnotu parametr ptjmeno  
	  *
	  * @return hodnota parametru
	*/
	public String getPtJmeno() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.ptjmeno.GetString();
	}

	/**
	  * Nastavi parametr ptjmeno  
	  *
	  * @param ptjmeno hodnota parametru
	*/
	public void setPtJmeno(String ptjmeno_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.ptjmeno.SetString(ptjmeno_temp);
	}
	/**
	  * Vrati hodnotu parametr ptsirka  
	  *
	  * @return hodnota parametru
	*/
	public String getPtSirka() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.ptsirka.GetString();
	}

	/**
	  * Nastavi parametr ptsirka  
	  *
	  * @param ptsirka hodnota parametru
	*/
	public void setPtSirka(String ptsirka_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.ptsirka.SetString(ptsirka_temp);
	}
	/**
	  * Vrati hodnotu parametr ptdelka  
	  *
	  * @return hodnota parametru
	*/
	public String getPtDelka() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.ptdelka.GetString();
	}

	/**
	  * Nastavi parametr ptdelka  
	  *
	  * @param ptdelka hodnota parametru
	*/
	public void setPtDelka(String ptdelka_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.ptdelka.SetString(ptdelka_temp);
	}
	/**
	  * Vrati hodnotu parametr pthloubka  
	  *
	  * @return hodnota parametru
	*/
	public String getPtHloubka() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.pthloubka.GetString();
	}

	/**
	  * Nastavi parametr pthloubka  
	  *
	  * @param pthloubka hodnota parametru
	*/
	public void setPtHloubka(String pthloubka_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pthloubka.SetString(pthloubka_temp);
	}
	/**
	  * Vrati hodnotu parametr ptpozn  
	  *
	  * @return hodnota parametru
	*/
	public String getPtPozn() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.ptpozn.GetString();
	}

	/**
	  * Nastavi parametr ptpozn  
	  *
	  * @param ptpozn hodnota parametru
	*/
	public void setPtPozn(String ptpozn_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.ptpozn.SetString(ptpozn_temp);
	}

}
