
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Material dilce (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:28:58</b>
	*
	* @author Spinster Generator
*/
public class PePartMaterial extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT pepart_material_id = MeFieldINT.createInstance("pepart_material_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldREF pepart_id = MeFieldREF.createInstance("pepart_id", PePart.class, "ptjmeno", 0, false);
	MeFieldREF pematerial_id = MeFieldREF.createInstance("pematerial_id", PeMaterial.class, "majmeno", 0, true);
	MeFieldFLOAT pmpocet = MeFieldFLOAT.createInstance("pmpocet", 0, true);


	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PePartMaterial createInstance() {
		PePartMaterial newItem = new PePartMaterial();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PePartMaterial.m_mapDescParam = new HashMap();
			PePartMaterial.m_mapDescParam.put("pepart_material_id", "GRID_POL_ID");
			PePartMaterial.m_mapDescParam.put("pepart_id", "GRID_POL_MATERIAL");
			PePartMaterial.m_mapDescParam.put("pematerial_id", "");
			PePartMaterial.m_mapDescParam.put("pmpocet", "GRID_POL_POCET");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PePartMaterial createInstance(int nID) {
		PePartMaterial newItem = PePartMaterial.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return pepart_material_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "pepart_material_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.pepart_material_id = ((PePartMaterial) zdroj).pepart_material_id;
		this.pepart_id = ((PePartMaterial) zdroj).pepart_id;
		this.pematerial_id = ((PePartMaterial) zdroj).pematerial_id;
		this.pmpocet = ((PePartMaterial) zdroj).pmpocet;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 4;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return pepart_material_id;
		} else if (nRow == 1) {
			return pepart_id;
		} else if (nRow == 2) {
			return pematerial_id;
		} else if (nRow == 3) {
			return pmpocet;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("pepart_material_id")) {
			return pepart_material_id;
		} else if (sName.equals("pepart_id")) {
			return pepart_id;
		} else if (sName.equals("pematerial_id")) {
			return pematerial_id;
		} else if (sName.equals("pmpocet")) {
			return pmpocet;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(pepart_material_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[3];
		arrColumn[0] = MeColumn.createInstance("pepart_material_id", PensumContext.getRes(this.getDesc("pepart_material_id")), 20);
		arrColumn[1] = MeColumn.createInstance("pematerial_id", PensumContext.getRes(this.getDesc("pematerial_id")), 200);
		arrColumn[2] = MeColumn.createInstance("pmpocet", PensumContext.getRes(this.getDesc("pmpocet")), 100);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr pepart_material_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPePart_material() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.pepart_material_id.GetInt();
	}

	/**
	  * Nastavi parametr pepart_material_id  
	  *
	  * @param pepart_material_id hodnota parametru
	*/
	public void setPePart_material(int pepart_material_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pepart_material_id.SetInt(pepart_material_id_temp);
	}
	/**
	  * Vrati hodnotu parametr pepart_id  
	  *
	  * @return hodnota parametru
	*/
	public PePart getPePart() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PePart) this.pepart_id.GetRef();
	}

	/**
	  * Nastavi parametr pepart_id  
	  *
	  * @param pepart_id hodnota parametru
	*/
	public void setPePart(PePart pepart_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pepart_id.SetRef(pepart_id_temp);
	}
	/**
	  * Vrati hodnotu parametr pematerial_id  
	  *
	  * @return hodnota parametru
	*/
	public PeMaterial getPeMaterial() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeMaterial) this.pematerial_id.GetRef();
	}

	/**
	  * Nastavi parametr pematerial_id  
	  *
	  * @param pematerial_id hodnota parametru
	*/
	public void setPeMaterial(PeMaterial pematerial_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pematerial_id.SetRef(pematerial_id_temp);
	}
	/**
	  * Vrati hodnotu parametr pmpocet  
	  *
	  * @return hodnota parametru
	*/
	public float getPmPocet() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (float) this.pmpocet.GetFloat();
	}

	/**
	  * Nastavi parametr pmpocet  
	  *
	  * @param pmpocet hodnota parametru
	*/
	public void setPmPocet(float pmpocet_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pmpocet.SetFloat(pmpocet_temp);
	}

}
