
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Pracovni misto (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:28:58</b>
	*
	* @author Spinster Generator
*/
public class PePlace extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT peplace_id = MeFieldINT.createInstance("peplace_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldREF parent_id = MeFieldREF.createInstance("parent_id", PePlace.class, "pljmeno", 0, false);
	MeFieldSTRING pljmeno = MeFieldSTRING.createInstance("pljmeno", "", true);

	/** pole podrizenych pracovist */
	protected PePlaceArray m_arrgetPlaceArray = null;

	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PePlace createInstance() {
		PePlace newItem = new PePlace();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PePlace.m_mapDescParam = new HashMap();
			PePlace.m_mapDescParam.put("peplace_id", "GRID_POL_ID");
			PePlace.m_mapDescParam.put("parent_id", "GRID_POL_ID_NADRIZENEHO");
			PePlace.m_mapDescParam.put("pljmeno", "GRID_POL_JMENO");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PePlace createInstance(int nID) {
		PePlace newItem = PePlace.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return peplace_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "peplace_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.peplace_id = ((PePlace) zdroj).peplace_id;
		this.parent_id = ((PePlace) zdroj).parent_id;
		this.pljmeno = ((PePlace) zdroj).pljmeno;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 3;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return peplace_id;
		} else if (nRow == 1) {
			return parent_id;
		} else if (nRow == 2) {
			return pljmeno;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("peplace_id")) {
			return peplace_id;
		} else if (sName.equals("parent_id")) {
			return parent_id;
		} else if (sName.equals("pljmeno")) {
			return pljmeno;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(peplace_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////
	/**
	 	* Vrati pole podrizenych pracovist, pokud neexistuje, vytvorime
	 	*
	 	* @return viz popis metody
	*/
	public PePlaceArray getPlaceArray() {
		// pokud pole neni naplneno
		if (m_arrgetPlaceArray == null) {
			m_arrgetPlaceArray = PePlaceArray.createInstance();
			m_arrgetPlaceArray.loadArray(MePodminka.createInstance("parent_id", this.getID()));
		}
		return m_arrgetPlaceArray;
	}

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[3];
		arrColumn[0] = MeColumn.createInstance("peplace_id", PensumContext.getRes(this.getDesc("peplace_id")), 20);
		arrColumn[1] = MeColumn.createInstance("parent_id", PensumContext.getRes(this.getDesc("parent_id")), 100);
		arrColumn[2] = MeColumn.createInstance("pljmeno", PensumContext.getRes(this.getDesc("pljmeno")), 200);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr peplace_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPePlace() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.peplace_id.GetInt();
	}

	/**
	  * Nastavi parametr peplace_id  
	  *
	  * @param peplace_id hodnota parametru
	*/
	public void setPePlace(int peplace_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.peplace_id.SetInt(peplace_id_temp);
	}
	/**
	  * Vrati hodnotu parametr parent_id  
	  *
	  * @return hodnota parametru
	*/
	public PePlace getPaRent() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PePlace) this.parent_id.GetRef();
	}

	/**
	  * Nastavi parametr parent_id  
	  *
	  * @param parent_id hodnota parametru
	*/
	public void setPaRent(PePlace parent_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.parent_id.SetRef(parent_id_temp);
	}
	/**
	  * Vrati hodnotu parametr pljmeno  
	  *
	  * @return hodnota parametru
	*/
	public String getPlJmeno() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.pljmeno.GetString();
	}

	/**
	  * Nastavi parametr pljmeno  
	  *
	  * @param pljmeno hodnota parametru
	*/
	public void setPlJmeno(String pljmeno_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pljmeno.SetString(pljmeno_temp);
	}

}
