
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Vyrobek (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:28:58</b>
	*
	* @author Spinster Generator
*/
public class PeProduct extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT peproduct_id = MeFieldINT.createInstance("peproduct_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldSTRING pojmeno = MeFieldSTRING.createInstance("pojmeno", "", true);
	MeFieldINT potyp = MeFieldINT.createInstance("potyp", 0, true);
	MeFieldINT posklad = MeFieldINT.createInstance("posklad", 0, true);

	/** pole dilcu ve vyrobku */
	protected PeProductPartArray m_arrgetProductPartArray = null;

	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PeProduct createInstance() {
		PeProduct newItem = new PeProduct();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PeProduct.m_mapDescParam = new HashMap();
			PeProduct.m_mapDescParam.put("peproduct_id", "GRID_POL_ID");
			PeProduct.m_mapDescParam.put("pojmeno", "GRID_POL_JMENO");
			PeProduct.m_mapDescParam.put("potyp", "GRID_POL_TYP");
			PeProduct.m_mapDescParam.put("posklad", "GRID_POL_SKLAD");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PeProduct createInstance(int nID) {
		PeProduct newItem = PeProduct.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return peproduct_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "peproduct_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.peproduct_id = ((PeProduct) zdroj).peproduct_id;
		this.pojmeno = ((PeProduct) zdroj).pojmeno;
		this.potyp = ((PeProduct) zdroj).potyp;
		this.posklad = ((PeProduct) zdroj).posklad;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 4;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return peproduct_id;
		} else if (nRow == 1) {
			return pojmeno;
		} else if (nRow == 2) {
			return potyp;
		} else if (nRow == 3) {
			return posklad;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("peproduct_id")) {
			return peproduct_id;
		} else if (sName.equals("pojmeno")) {
			return pojmeno;
		} else if (sName.equals("potyp")) {
			return potyp;
		} else if (sName.equals("posklad")) {
			return posklad;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(peproduct_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////
	/**
	 	* Vrati pole dilcu ve vyrobku, pokud neexistuje, vytvorime
	 	*
	 	* @return viz popis metody
	*/
	public PeProductPartArray getProductPartArray() {
		// pokud pole neni naplneno
		if (m_arrgetProductPartArray == null) {
			m_arrgetProductPartArray = PeProductPartArray.createInstance();
			m_arrgetProductPartArray.loadArray(MePodminka.createInstance("peproduct_id", this.getID()));
		}
		return m_arrgetProductPartArray;
	}

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[4];
		arrColumn[0] = MeColumn.createInstance("peproduct_id", PensumContext.getRes(this.getDesc("peproduct_id")), 20);
		arrColumn[1] = MeColumn.createInstance("pojmeno", PensumContext.getRes(this.getDesc("pojmeno")), 100);
		arrColumn[2] = MeColumn.createInstance("potyp", PensumContext.getRes(this.getDesc("potyp")), 150);
		arrColumn[3] = MeColumn.createInstance("posklad", PensumContext.getRes(this.getDesc("posklad")), 100);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr peproduct_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPeProduct() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.peproduct_id.GetInt();
	}

	/**
	  * Nastavi parametr peproduct_id  
	  *
	  * @param peproduct_id hodnota parametru
	*/
	public void setPeProduct(int peproduct_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.peproduct_id.SetInt(peproduct_id_temp);
	}
	/**
	  * Vrati hodnotu parametr pojmeno  
	  *
	  * @return hodnota parametru
	*/
	public String getPoJmeno() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (String) this.pojmeno.GetString();
	}

	/**
	  * Nastavi parametr pojmeno  
	  *
	  * @param pojmeno hodnota parametru
	*/
	public void setPoJmeno(String pojmeno_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pojmeno.SetString(pojmeno_temp);
	}
	/**
	  * Vrati hodnotu parametr potyp  
	  *
	  * @return hodnota parametru
	*/
	public int getPoTyp() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.potyp.GetInt();
	}

	/**
	  * Nastavi parametr potyp  
	  *
	  * @param potyp hodnota parametru
	*/
	public void setPoTyp(int potyp_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.potyp.SetInt(potyp_temp);
	}
	/**
	  * Vrati hodnotu parametr posklad  
	  *
	  * @return hodnota parametru
	*/
	public int getPoSklad() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.posklad.GetInt();
	}

	/**
	  * Nastavi parametr posklad  
	  *
	  * @param posklad hodnota parametru
	*/
	public void setPoSklad(int posklad_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.posklad.SetInt(posklad_temp);
	}

}
