
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Dilce vyrobku(implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:28:59</b>
	*
	* @author Spinster Generator
*/
public class PeProductPart extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT peproduct_part_id = MeFieldINT.createInstance("peproduct_part_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldREF peproduct_id = MeFieldREF.createInstance("peproduct_id", PeProduct.class, "pojmeno", 0, false);
	MeFieldREF pepart_id = MeFieldREF.createInstance("pepart_id", PePart.class, "ptjmeno", 0, true);


	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PeProductPart createInstance() {
		PeProductPart newItem = new PeProductPart();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PeProductPart.m_mapDescParam = new HashMap();
			PeProductPart.m_mapDescParam.put("peproduct_part_id", "GRID_POL_ID");
			PeProductPart.m_mapDescParam.put("peproduct_id", "");
			PeProductPart.m_mapDescParam.put("pepart_id", "GRID_POL_DILEC");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PeProductPart createInstance(int nID) {
		PeProductPart newItem = PeProductPart.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return peproduct_part_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "peproduct_part_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.peproduct_part_id = ((PeProductPart) zdroj).peproduct_part_id;
		this.peproduct_id = ((PeProductPart) zdroj).peproduct_id;
		this.pepart_id = ((PeProductPart) zdroj).pepart_id;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 3;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return peproduct_part_id;
		} else if (nRow == 1) {
			return peproduct_id;
		} else if (nRow == 2) {
			return pepart_id;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("peproduct_part_id")) {
			return peproduct_part_id;
		} else if (sName.equals("peproduct_id")) {
			return peproduct_id;
		} else if (sName.equals("pepart_id")) {
			return pepart_id;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(peproduct_part_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[2];
		arrColumn[0] = MeColumn.createInstance("peproduct_part_id", PensumContext.getRes(this.getDesc("peproduct_part_id")), 20);
		arrColumn[1] = MeColumn.createInstance("pepart_id", PensumContext.getRes(this.getDesc("pepart_id")), 200);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr peproduct_part_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPeProduct_part() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.peproduct_part_id.GetInt();
	}

	/**
	  * Nastavi parametr peproduct_part_id  
	  *
	  * @param peproduct_part_id hodnota parametru
	*/
	public void setPeProduct_part(int peproduct_part_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.peproduct_part_id.SetInt(peproduct_part_id_temp);
	}
	/**
	  * Vrati hodnotu parametr peproduct_id  
	  *
	  * @return hodnota parametru
	*/
	public PeProduct getPeProduct() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeProduct) this.peproduct_id.GetRef();
	}

	/**
	  * Nastavi parametr peproduct_id  
	  *
	  * @param peproduct_id hodnota parametru
	*/
	public void setPeProduct(PeProduct peproduct_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.peproduct_id.SetRef(peproduct_id_temp);
	}
	/**
	  * Vrati hodnotu parametr pepart_id  
	  *
	  * @return hodnota parametru
	*/
	public PePart getPePart() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PePart) this.pepart_id.GetRef();
	}

	/**
	  * Nastavi parametr pepart_id  
	  *
	  * @param pepart_id hodnota parametru
	*/
	public void setPePart(PePart pepart_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pepart_id.SetRef(pepart_id_temp);
	}

}
