
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Operace na bezicim dilci (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:28:59</b>
	*
	* @author Spinster Generator
*/
public class PeRunOperation extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT perunoperation_id = MeFieldINT.createInstance("perunoperation_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldREF peoperation_id = MeFieldREF.createInstance("peoperation_id", PeOperation.class, "opjmeno", 0, true);
	MeFieldREF perunpart_id = MeFieldREF.createInstance("perunpart_id", PePart.class, "ptjmeno", 0, false);
	MeFieldREF peworker_id = MeFieldREF.createInstance("peworker_id", PeWorker.class, "wkjmeno", 0, true);
	MeFieldREF rostav = MeFieldREF.createInstance("rostav", PeStatus.class, "stjmeno", 0, false);
	MeFieldINT rotime = MeFieldINT.createInstance("rotime", 0, true);


	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PeRunOperation createInstance() {
		PeRunOperation newItem = new PeRunOperation();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PeRunOperation.m_mapDescParam = new HashMap();
			PeRunOperation.m_mapDescParam.put("perunoperation_id", "GRID_POL_ID");
			PeRunOperation.m_mapDescParam.put("peoperation_id", "GRID_POL_POPIS_OPER");
			PeRunOperation.m_mapDescParam.put("perunpart_id", "GRID_POL_DILEC");
			PeRunOperation.m_mapDescParam.put("peworker_id", "GRID_POL_PRACOVNIK");
			PeRunOperation.m_mapDescParam.put("rostav", "GRID_POL_STAV");
			PeRunOperation.m_mapDescParam.put("rotime", "GRID_POL_CAS");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PeRunOperation createInstance(int nID) {
		PeRunOperation newItem = PeRunOperation.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return perunoperation_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "perunoperation_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.perunoperation_id = ((PeRunOperation) zdroj).perunoperation_id;
		this.peoperation_id = ((PeRunOperation) zdroj).peoperation_id;
		this.perunpart_id = ((PeRunOperation) zdroj).perunpart_id;
		this.peworker_id = ((PeRunOperation) zdroj).peworker_id;
		this.rostav = ((PeRunOperation) zdroj).rostav;
		this.rotime = ((PeRunOperation) zdroj).rotime;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 6;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return perunoperation_id;
		} else if (nRow == 1) {
			return peoperation_id;
		} else if (nRow == 2) {
			return perunpart_id;
		} else if (nRow == 3) {
			return peworker_id;
		} else if (nRow == 4) {
			return rostav;
		} else if (nRow == 5) {
			return rotime;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("perunoperation_id")) {
			return perunoperation_id;
		} else if (sName.equals("peoperation_id")) {
			return peoperation_id;
		} else if (sName.equals("perunpart_id")) {
			return perunpart_id;
		} else if (sName.equals("peworker_id")) {
			return peworker_id;
		} else if (sName.equals("rostav")) {
			return rostav;
		} else if (sName.equals("rotime")) {
			return rotime;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(perunoperation_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[6];
		arrColumn[0] = MeColumn.createInstance("perunoperation_id", PensumContext.getRes(this.getDesc("perunoperation_id")), 20);
		arrColumn[1] = MeColumn.createInstance("peoperation_id", PensumContext.getRes(this.getDesc("peoperation_id")), 150);
		arrColumn[2] = MeColumn.createInstance("perunpart_id", PensumContext.getRes(this.getDesc("perunpart_id")), 100);
		arrColumn[3] = MeColumn.createInstance("peworker_id", PensumContext.getRes(this.getDesc("peworker_id")), 100);
		arrColumn[4] = MeColumn.createInstance("rostav", PensumContext.getRes(this.getDesc("rostav")), 100);
		arrColumn[5] = MeColumn.createInstance("rotime", PensumContext.getRes(this.getDesc("rotime")), 150);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr perunoperation_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPeRunoperation() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.perunoperation_id.GetInt();
	}

	/**
	  * Nastavi parametr perunoperation_id  
	  *
	  * @param perunoperation_id hodnota parametru
	*/
	public void setPeRunoperation(int perunoperation_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.perunoperation_id.SetInt(perunoperation_id_temp);
	}
	/**
	  * Vrati hodnotu parametr peoperation_id  
	  *
	  * @return hodnota parametru
	*/
	public PeOperation getPeOperation() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeOperation) this.peoperation_id.GetRef();
	}

	/**
	  * Nastavi parametr peoperation_id  
	  *
	  * @param peoperation_id hodnota parametru
	*/
	public void setPeOperation(PeOperation peoperation_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.peoperation_id.SetRef(peoperation_id_temp);
	}
	/**
	  * Vrati hodnotu parametr perunpart_id  
	  *
	  * @return hodnota parametru
	*/
	public PePart getPeRunpart() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PePart) this.perunpart_id.GetRef();
	}

	/**
	  * Nastavi parametr perunpart_id  
	  *
	  * @param perunpart_id hodnota parametru
	*/
	public void setPeRunpart(PePart perunpart_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.perunpart_id.SetRef(perunpart_id_temp);
	}
	/**
	  * Vrati hodnotu parametr peworker_id  
	  *
	  * @return hodnota parametru
	*/
	public PeWorker getPeWorker() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeWorker) this.peworker_id.GetRef();
	}

	/**
	  * Nastavi parametr peworker_id  
	  *
	  * @param peworker_id hodnota parametru
	*/
	public void setPeWorker(PeWorker peworker_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.peworker_id.SetRef(peworker_id_temp);
	}
	/**
	  * Vrati hodnotu parametr rostav  
	  *
	  * @return hodnota parametru
	*/
	public PeStatus getRoStav() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeStatus) this.rostav.GetRef();
	}

	/**
	  * Nastavi parametr rostav  
	  *
	  * @param rostav hodnota parametru
	*/
	public void setRoStav(PeStatus rostav_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.rostav.SetRef(rostav_temp);
	}
	/**
	  * Vrati hodnotu parametr rotime  
	  *
	  * @return hodnota parametru
	*/
	public int getRoTime() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.rotime.GetInt();
	}

	/**
	  * Nastavi parametr rotime  
	  *
	  * @param rotime hodnota parametru
	*/
	public void setRoTime(int rotime_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.rotime.SetInt(rotime_temp);
	}

}
