
package cz.luboss.pensum.gener;

import java.util.HashMap;
import java.util.Map;

// knihovna
import cz.luboss.lubosslib.LException;

// definice
import cz.luboss.medulla.common.*;
import cz.luboss.medulla.data.*;
import cz.luboss.medulla.types.*;

// implementace
import cz.luboss.pensum.common.PensumContext;

/**
	* Jeden bezici vyrobek (implementace pro Pensum)<p>
	* Vygenerovano <b>22.08.2004 14:28:59</b>
	*
	* @author Spinster Generator
*/
public class PeRunProduct extends MeItem {

	/** pole popisu parametru */
	protected static Map m_mapDescParam = null;

	// Parametry
	MeFieldINT perunproduct_id = MeFieldINT.createInstance("perunproduct_id", MeDefine.DEF_NEW_ITEM_ID, false);
	MeFieldREF peproduct_id = MeFieldREF.createInstance("peproduct_id", PeProduct.class, "pojmeno", 0, false);
	MeFieldREF pejob_id = MeFieldREF.createInstance("pejob_id", PeJob.class, "jojmeno", 0, false);
	MeFieldFLOAT pdcena = MeFieldFLOAT.createInstance("pdcena", 0, true);

	/** pole dilcu na vyrobku */
	protected PeRunPartArray m_arrgetRunPartArray = null;

	/**
	  * Vytvori novy prvek
	  *
	  * @return novy prvek
	*/
	public static PeRunProduct createInstance() {
		PeRunProduct newItem = new PeRunProduct();
    // pokud neexistuje polo popisu prvku 
    if (m_mapDescParam == null) {
			// naplnime pole popisu parametru
			PeRunProduct.m_mapDescParam = new HashMap();
			PeRunProduct.m_mapDescParam.put("perunproduct_id", "GRID_POL_ID");
			PeRunProduct.m_mapDescParam.put("peproduct_id", "GRID_POL_POPIS_VYROBKU");
			PeRunProduct.m_mapDescParam.put("pejob_id", "GRID_POL_OBJEDNAVKA");
			PeRunProduct.m_mapDescParam.put("pdcena", "GRID_POL_CENA");
		}
		return newItem;
	}

	/**
	  * Vytvori novy objekt a nacte
	  *
	  * @param nID ID noveho prvku
	  * @return novy prvek
	*/
	public static PeRunProduct createInstance(int nID) {
		PeRunProduct newItem = PeRunProduct.createInstance();
		// pokud se nepodari nahrat, vratime null
		if (!newItem.load(nID)) {
      return null;
    }
		return newItem;
	}

	/**
	  * Vrati poradi parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public int getFieldID() {
		return 0;
	}

	/**
	  * Vrati ID objektu
	  *
	  * @return ID
	*/
	public int getID() {
    return perunproduct_id.GetInt();
  }

	/**
	  * Vrati jmeno parametru s ID objektu
	  *
	  * @return vis popis
	*/
	public String getNameID() {
    return "perunproduct_id";
	}

	/**
	  * Nastavi data objektu na data z jineho objektu, 
    * tzn oba objekty budou mit stejne datove pole 
    * (zmeny dat u jednoho se projevi i u druheho)
    * U nastavi i status objektu
	  *
	  * @param zdroj podminka pro nahrani
	  * @return prubeh metody
	*/
	public boolean setData(MeItem zdroj) {
		this.perunproduct_id = ((PeRunProduct) zdroj).perunproduct_id;
		this.peproduct_id = ((PeRunProduct) zdroj).peproduct_id;
		this.pejob_id = ((PeRunProduct) zdroj).pejob_id;
		this.pdcena = ((PeRunProduct) zdroj).pdcena;
    return true;
  }

  /**
	  * Vrati pocet parametru
	  *
	  * @return pocet parametru
	*/
	public int getParamCount() {
    return 4;
  }
  
	/**
	  * Vrati parametr podle poradi
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param nRow poradi parametru
	  * @return parametr parametru
	*/
	public MeField getParam(int nRow) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (nRow == 0) {
			return perunproduct_id;
		} else if (nRow == 1) {
			return peproduct_id;
		} else if (nRow == 2) {
			return pejob_id;
		} else if (nRow == 3) {
			return pdcena;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym poradi!"); 
    }
	}

	/**
	  * Vrati parametr podle jmena
    * !!! Pozor, pokud budete chtit meni hodnotu zaznamu MeField, 
    * musite nejdrive zaregistrovat do transakce
	  *
	  * @param sName jmeno parametru
	  * @return parametr parametru
	*/
	public MeField getParam(String sName) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    	throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
    if (sName.equals("perunproduct_id")) {
			return perunproduct_id;
		} else if (sName.equals("peproduct_id")) {
			return peproduct_id;
		} else if (sName.equals("pejob_id")) {
			return pejob_id;
		} else if (sName.equals("pdcena")) {
			return pdcena;
		} else  {
    	throw new LException(this.getClass(), "Pozadujete atribut s neplatnym jmenem!"); 
    }
	}

  /**
	  * Vygeneruje jedinecny kod pro ulozeni do transakce
	  *
	  * @return prubeh metody
	*/
	public String generateKod() {
    return this.generateKod(perunproduct_id.GetInt());
  }

	/**
	  * Vrati popis parametru podle jmena
	  *
	  * @param sName jmeno parametru
	  * @return viz popis
	*/
	public String getDesc(String sName) {
		if (m_mapDescParam == null || sName == null || sName.length() == 0) {
			return null;
    }
		return (String) m_mapDescParam.get(sName);
	}

//////////////////////////////////////////////////////////////////////////////////////
//
// Cast textu mezi slovy NEGENEROVANO se neprepisuje pri pregenerovani, zde muzete psat svoje rozsireni
//
//@@@@ NEGENEROVANO
//@@@@ NEGENEROVANO
//////////////////////////////////////////////////////////////////////////////////////
	/**
	 	* Vrati pole dilcu na vyrobku, pokud neexistuje, vytvorime
	 	*
	 	* @return viz popis metody
	*/
	public PeRunPartArray getRunPartArray() {
		// pokud pole neni naplneno
		if (m_arrgetRunPartArray == null) {
			m_arrgetRunPartArray = PeRunPartArray.createInstance();
			m_arrgetRunPartArray.loadArray(MePodminka.createInstance("perunproduct_id", this.getID()));
		}
		return m_arrgetRunPartArray;
	}

	/**
		* Vrati seznam sloupcu pro defaultni grid
		*
		* @return seznam sloupcu pro zobrazeni
	*/
	public MeColumn[] getColumns() {
		MeColumn[] arrColumn = new MeColumn[4];
		arrColumn[0] = MeColumn.createInstance("perunproduct_id", PensumContext.getRes(this.getDesc("perunproduct_id")), 20);
		arrColumn[1] = MeColumn.createInstance("peproduct_id", PensumContext.getRes(this.getDesc("peproduct_id")), 150);
		arrColumn[2] = MeColumn.createInstance("pejob_id", PensumContext.getRes(this.getDesc("pejob_id")), 120);
		arrColumn[3] = MeColumn.createInstance("pdcena", PensumContext.getRes(this.getDesc("pdcena")), 100);
		return arrColumn;
	}

	/**
	  * Vrati hodnotu parametr perunproduct_id  
	  *
	  * @return hodnota parametru
	*/
	public int getPeRunproduct() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (int) this.perunproduct_id.GetInt();
	}

	/**
	  * Nastavi parametr perunproduct_id  
	  *
	  * @param perunproduct_id hodnota parametru
	*/
	public void setPeRunproduct(int perunproduct_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.perunproduct_id.SetInt(perunproduct_id_temp);
	}
	/**
	  * Vrati hodnotu parametr peproduct_id  
	  *
	  * @return hodnota parametru
	*/
	public PeProduct getPeProduct() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeProduct) this.peproduct_id.GetRef();
	}

	/**
	  * Nastavi parametr peproduct_id  
	  *
	  * @param peproduct_id hodnota parametru
	*/
	public void setPeProduct(PeProduct peproduct_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.peproduct_id.SetRef(peproduct_id_temp);
	}
	/**
	  * Vrati hodnotu parametr pejob_id  
	  *
	  * @return hodnota parametru
	*/
	public PeJob getPeJob() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (PeJob) this.pejob_id.GetRef();
	}

	/**
	  * Nastavi parametr pejob_id  
	  *
	  * @param pejob_id hodnota parametru
	*/
	public void setPeJob(PeJob pejob_id_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pejob_id.SetRef(pejob_id_temp);
	}
	/**
	  * Vrati hodnotu parametr pdcena  
	  *
	  * @return hodnota parametru
	*/
	public float getPdCena() {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		return (float) this.pdcena.GetFloat();
	}

	/**
	  * Nastavi parametr pdcena  
	  *
	  * @param pdcena hodnota parametru
	*/
	public void setPdCena(float pdcena_temp) {
    // pokud je objekt smazan hodime exception
    if (this.isDeleted()) {
    		throw new LException(this.getClass(), "Tento objekt [" + this.generateKod() + "] je jiz smazan!"); 
    }
		// rovnou zaregistrujeme
		PensumContext.Register(this);
		this.pdcena.SetFloat(pdcena_temp);
	}

}
